/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.predicate;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.ReduceType;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.Element;
import io.doov.core.dsl.meta.ElementType;
import io.doov.core.dsl.meta.EmptyMetadata;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.NaryMetadata;
import io.doov.core.dsl.meta.Operator;
import io.doov.core.dsl.meta.predicate.BinaryPredicateMetadata;
import io.doov.core.dsl.meta.predicate.PredicateMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class NaryPredicateMetadata
extends NaryMetadata
implements PredicateMetadata {
    private final AtomicInteger evalTrue = new AtomicInteger();
    private final AtomicInteger evalFalse = new AtomicInteger();

    private NaryPredicateMetadata(Operator operator, List<Metadata> values) {
        super(operator, values);
    }

    @Override
    public AtomicInteger evalTrue() {
        return this.evalTrue;
    }

    @Override
    public AtomicInteger evalFalse() {
        return this.evalFalse;
    }

    public static NaryPredicateMetadata matchAnyMetadata(List<Metadata> values) {
        return new NaryPredicateMetadata(DefaultOperator.match_any, values);
    }

    public static NaryPredicateMetadata matchAllMetadata(List<Metadata> values) {
        return new NaryPredicateMetadata(DefaultOperator.match_all, values);
    }

    public static NaryPredicateMetadata matchNoneMetadata(List<Metadata> values) {
        return new NaryPredicateMetadata(DefaultOperator.match_none, values);
    }

    public static NaryPredicateMetadata countMetadata(List<Metadata> values) {
        return new NaryPredicateMetadata(DefaultOperator.count, values);
    }

    public static NaryPredicateMetadata sumMetadata(List<Metadata> values) {
        return new NaryPredicateMetadata(DefaultOperator.sum, values);
    }

    public static NaryPredicateMetadata minMetadata(List<Metadata> values) {
        return new NaryPredicateMetadata(DefaultOperator.min, values);
    }

    @Override
    public Metadata reduce(Context context, ReduceType type) {
        if (this.getOperator() == DefaultOperator.match_all || this.getOperator() == DefaultOperator.match_any) {
            boolean result;
            boolean bl = result = context.isEvalTrue(this) || !context.isEvalFalse(this);
            if (!result && type == ReduceType.SUCCESS) {
                return new EmptyMetadata();
            }
            if (result && type == ReduceType.FAILURE) {
                return new EmptyMetadata();
            }
            if (this.getOperator() == DefaultOperator.match_all && context.isEvalFalse(this)) {
                List<Metadata> children = this.children().filter(md -> context.isEvalFalse((Metadata)md)).map(md -> md.reduce(context, type)).filter(Objects::nonNull).filter(md -> MetadataType.EMPTY != md.type()).collect(Collectors.toList());
                if (children.size() == 1) {
                    return (Metadata)children.get(0);
                }
                return new NaryPredicateMetadata(this.getOperator(), children);
            }
            if (this.getOperator() == DefaultOperator.match_any && context.isEvalTrue(this)) {
                List<Metadata> children = this.children().filter(md -> context.isEvalTrue((Metadata)md)).map(md -> md.reduce(context, type)).filter(Objects::nonNull).filter(md -> MetadataType.EMPTY != md.type()).collect(Collectors.toList());
                if (children.size() == 1) {
                    return (Metadata)children.get(0);
                }
                if (children.size() == 0) {
                    return new EmptyMetadata();
                }
                return new NaryPredicateMetadata(this.getOperator(), children);
            }
        } else {
            if (this.getOperator() == DefaultOperator.sum) {
                return new NaryPredicateMetadata(DefaultOperator.sum, this.children().filter(md -> NaryPredicateMetadata.sumContentFilter(context, md)).map(md -> md.reduce(context, type)).filter(Objects::nonNull).filter(md -> MetadataType.EMPTY != md.type()).collect(Collectors.toList()));
            }
            if (this.getOperator() == DefaultOperator.count) {
                List<Metadata> children = this.children().filter(md -> this.countFilter(context, type, (Metadata)md)).map(md -> md.reduce(context, type)).filter(Objects::nonNull).filter(md -> MetadataType.EMPTY != md.type()).collect(Collectors.toList());
                return NaryPredicateMetadata.rewriteCount(children);
            }
        }
        return new NaryPredicateMetadata(this.getOperator(), this.children().map(md -> md.reduce(context, type)).filter(Objects::nonNull).filter(md -> MetadataType.EMPTY != md.type()).collect(Collectors.toList()));
    }

    private boolean countFilter(Context context, ReduceType type, Metadata md) {
        return type == ReduceType.FAILURE && context.isEvalFalse(md) || type == ReduceType.SUCCESS && context.isEvalTrue(md);
    }

    private static boolean sumContentFilter(Context context, Metadata md) {
        if (md.type() != MetadataType.FIELD_PREDICATE) {
            return true;
        }
        ArrayList<Element> elements = new ArrayList<Element>(((LeafMetadata)md).elements());
        if (elements.size() < 1) {
            return true;
        }
        if (((Element)elements.get(0)).getType() != ElementType.FIELD) {
            return true;
        }
        Object value = context.getEvalValue(((DslField)((Element)elements.get(0)).getReadable()).id());
        if (value == null) {
            return false;
        }
        try {
            return Double.parseDouble(value.toString()) != 0.0;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    private static Metadata rewriteCount(List<Metadata> childMsgs) {
        if (childMsgs.size() == 0) {
            return new EmptyMetadata();
        }
        if (childMsgs.size() == 1) {
            return childMsgs.get(0);
        }
        return new BinaryPredicateMetadata(childMsgs.get(0), DefaultOperator.and, NaryPredicateMetadata.rewriteCount(childMsgs.subList(1, childMsgs.size())));
    }
}

