/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl;

import io.doov.core.FieldModel;
import io.doov.core.dsl.DslField;
import io.doov.core.dsl.Streams;
import io.doov.core.dsl.field.types.Function;
import io.doov.core.dsl.field.types.NumericFieldInfo;
import io.doov.core.dsl.impl.DefaultFunction;
import io.doov.core.dsl.impl.DefaultStepCondition;
import io.doov.core.dsl.impl.DefaultStepWhen;
import io.doov.core.dsl.impl.LogicalNaryCondition;
import io.doov.core.dsl.impl.LogicalUnaryCondition;
import io.doov.core.dsl.impl.base.IterableFunction;
import io.doov.core.dsl.impl.num.IntegerFunction;
import io.doov.core.dsl.impl.num.NumericFunction;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.MappingInput;
import io.doov.core.dsl.lang.MappingRule;
import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.lang.StepWhen;
import io.doov.core.dsl.mapping.MappingRegistry;
import io.doov.core.dsl.mapping.builder.BiContextawareStepMap;
import io.doov.core.dsl.mapping.builder.BiStepMap;
import io.doov.core.dsl.mapping.builder.ContextawareStepMap;
import io.doov.core.dsl.mapping.builder.IterableStepMap;
import io.doov.core.dsl.mapping.builder.NaryStepMap;
import io.doov.core.dsl.mapping.builder.SimpleStepMap;
import io.doov.core.dsl.mapping.builder.StaticStepMap;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.predicate.FieldMetadata;
import io.doov.core.dsl.meta.predicate.PredicateMetadata;
import io.doov.core.dsl.meta.predicate.ValuePredicateMetadata;
import io.doov.core.dsl.template.TemplateParam;
import io.doov.core.dsl.template.TemplateSpec;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class DOOV {
    private DOOV() {
    }

    public static StepWhen when(StepCondition condition) {
        return new DefaultStepWhen(condition);
    }

    public static StepCondition alwaysTrue() {
        return new DefaultStepCondition((PredicateMetadata)ValuePredicateMetadata.trueMetadata(), (model, context) -> true);
    }

    public static StepCondition alwaysTrue(String readable) {
        return new DefaultStepCondition((PredicateMetadata)((LeafMetadata)ValuePredicateMetadata.trueMetadata()).valueReadable(() -> readable), (model, context) -> true);
    }

    public static StepCondition alwaysFalse() {
        return new DefaultStepCondition((PredicateMetadata)ValuePredicateMetadata.falseMetadata(), (model, context) -> false);
    }

    public static StepCondition alwaysFalse(String readable) {
        return new DefaultStepCondition((PredicateMetadata)((LeafMetadata)ValuePredicateMetadata.falseMetadata()).valueReadable(() -> readable), (model, context) -> false);
    }

    public static IntegerFunction count(StepCondition ... steps) {
        return LogicalNaryCondition.count(Arrays.asList(steps));
    }

    public static StepCondition matchAny(StepCondition ... steps) {
        return LogicalNaryCondition.matchAny(Arrays.asList(steps));
    }

    public static StepCondition not(StepCondition step) {
        return LogicalUnaryCondition.negate(step);
    }

    public static StepCondition matchAny(Stream<? extends DslField<?>> dslFields, java.util.function.Function<DefaultFunction<?, ?>, StepCondition> stepConditionFunction) {
        return LogicalNaryCondition.matchAny(dslFields.filter(Objects::nonNull).map(DslField::getDefaultFunction).map(stepConditionFunction).collect(Collectors.toList()));
    }

    public static StepCondition matchAll(StepCondition ... steps) {
        return LogicalNaryCondition.matchAll(Arrays.asList(steps));
    }

    public static StepCondition matchAll(Stream<? extends DslField<?>> dslFields, java.util.function.Function<DefaultFunction<?, ?>, StepCondition> stepConditionFunction) {
        return LogicalNaryCondition.matchAll(dslFields.filter(Objects::nonNull).map(DslField::getDefaultFunction).map(stepConditionFunction).collect(Collectors.toList()));
    }

    public static StepCondition matchNone(StepCondition ... steps) {
        return LogicalNaryCondition.matchNone(Arrays.asList(steps));
    }

    public static StepCondition matchNone(Stream<? extends DslField<?>> dslFields, java.util.function.Function<DefaultFunction<?, ?>, StepCondition> stepConditionFunction) {
        return LogicalNaryCondition.matchNone(dslFields.filter(Objects::nonNull).map(DslField::getDefaultFunction).map(stepConditionFunction).collect(Collectors.toList()));
    }

    public static <I> SimpleStepMap<I> map(DslField<I> inFieldInfo) {
        return new SimpleStepMap<I>(inFieldInfo);
    }

    public static <I, J> BiStepMap<I, J> map(DslField<I> inFieldInfo, DslField<J> in2FieldInfo) {
        return new BiStepMap<I, J>(inFieldInfo, in2FieldInfo);
    }

    public static NaryStepMap map(DslField<?> ... inFieldInfos) {
        return new NaryStepMap(Arrays.asList(inFieldInfos));
    }

    public static NaryStepMap map(Stream<? extends DslField<?>> inFieldInfos) {
        return new NaryStepMap(inFieldInfos.collect(Collectors.toList()));
    }

    public static <I> StaticStepMap<I> map(Supplier<I> valueSupplier) {
        return new StaticStepMap<I>(valueSupplier);
    }

    public static <I> StaticStepMap<I> map(I value) {
        return new StaticStepMap<Object>(() -> value);
    }

    public static <I, C extends Iterable<I>> IterableStepMap<I, C> mapIter(C value) {
        return new IterableStepMap(() -> value);
    }

    @SafeVarargs
    public static <I> IterableStepMap<I, List<I>> mapIter(I ... values) {
        return new IterableStepMap(() -> Arrays.asList(values));
    }

    public static <O> MappingRule mapNull(DslField<O> outFieldInfo) {
        return new StaticStepMap<Object>(() -> null).to(outFieldInfo);
    }

    public static <I> ContextawareStepMap<I> map(BiFunction<FieldModel, Context, I> valueFunction) {
        return new ContextawareStepMap<I>(valueFunction);
    }

    public static <I> ContextawareStepMap<I> map(MappingInput<I> input) {
        return new ContextawareStepMap<I>(input);
    }

    public static <I, J> BiContextawareStepMap<I, J> map(MappingInput<I> input, MappingInput<J> input2) {
        return new BiContextawareStepMap<I, J>(input, input2);
    }

    public static <I, J> BiContextawareStepMap<I, J> map(BiFunction<FieldModel, Context, I> valueFunction, BiFunction<FieldModel, Context, J> valueFunction2) {
        return new BiContextawareStepMap<I, J>(valueFunction, valueFunction2);
    }

    public static MappingRegistry mappings(MappingRule ... mappingRules) {
        return MappingRegistry.mappings(mappingRules);
    }

    public static MappingRegistry mapRange(int startInclusive, int endExclusive, java.util.function.Function<Integer, MappingRule> mappingRuleFunction) {
        return MappingRegistry.mappings((MappingRule[])IntStream.range(startInclusive, endExclusive).mapToObj(mappingRuleFunction::apply).toArray(MappingRule[]::new));
    }

    public static <T extends DslField<?>> MappingRegistry mapFor(Stream<T> fieldStream, java.util.function.Function<T, MappingRule> mappingRuleFunction) {
        return MappingRegistry.mappings((MappingRule[])fieldStream.filter(Objects::nonNull).map(mappingRuleFunction).toArray(MappingRule[]::new));
    }

    public static <T extends DslField<?>> MappingRegistry mapWithIndex(Stream<T> fieldStream, BiFunction<T, Integer, MappingRule> mappingRuleFunction) {
        return MappingRegistry.mappings((MappingRule[])Streams.mapWithIndex(fieldStream, (? super T f, Long l) -> (MappingRule)mappingRuleFunction.apply(f, l.intValue())).toArray(MappingRule[]::new));
    }

    public static <T extends DslField<?>> T fieldInPosition(Stream<T> fieldStream, int index) {
        return (T)fieldStream.filter(Objects::nonNull).filter(f -> f.id().position() == index).findFirst().orElseThrow(() -> new IllegalArgumentException("Field with position " + index + " not found."));
    }

    @SafeVarargs
    public static <N extends Number> NumericFunction<N> min(NumericFieldInfo<N> ... fields) {
        return Arrays.stream(fields).filter(Objects::nonNull).findFirst().map(NumericFieldInfo::getNumericFunction).map(c -> c.min(Arrays.asList(fields))).orElseThrow(IllegalArgumentException::new);
    }

    @SafeVarargs
    public static <N extends Number> NumericFunction<N> sum(NumericFieldInfo<N> ... fields) {
        return Arrays.stream(fields).filter(Objects::nonNull).findFirst().map(NumericFieldInfo::getNumericFunction).map(c -> c.sum(Arrays.asList(fields))).orElseThrow(IllegalArgumentException::new);
    }

    @SafeVarargs
    public static <N extends Number> NumericFunction<N> sum(NumericFunction<N> ... conditions) {
        return Arrays.stream(conditions).filter(Objects::nonNull).findFirst().map(c -> c.sumConditions(Arrays.asList(conditions))).orElseThrow(IllegalArgumentException::new);
    }

    public static <T1 extends DslField<?>> TemplateSpec.Template1<T1> template(Supplier<TemplateParam<T1>> param1) {
        return new TemplateSpec.Template1<T1>(param1);
    }

    public static <T1 extends DslField<?>, T2 extends DslField<?>> TemplateSpec.Template2<T1, T2> template(Supplier<TemplateParam<T1>> param1, Supplier<TemplateParam<T2>> param2) {
        return new TemplateSpec.Template2<T1, T2>(param1, param2);
    }

    public static <T1 extends DslField<?>, T2 extends DslField<?>, T3 extends DslField<?>> TemplateSpec.Template3<T1, T2, T3> template(Supplier<TemplateParam<T1>> param1, Supplier<TemplateParam<T2>> param2, Supplier<TemplateParam<T3>> param3) {
        return new TemplateSpec.Template3<T1, T2, T3>(param1, param2, param3);
    }

    public static <T1 extends DslField<?>, T2 extends DslField<?>, T3 extends DslField<?>, T4 extends DslField<?>> TemplateSpec.Template4<T1, T2, T3, T4> template(Supplier<TemplateParam<T1>> param1, Supplier<TemplateParam<T2>> param2, Supplier<TemplateParam<T3>> param3, Supplier<TemplateParam<T4>> param4) {
        return new TemplateSpec.Template4<T1, T2, T3, T4>(param1, param2, param3, param4);
    }

    public static <T1 extends DslField<?>, T2 extends DslField<?>, T3 extends DslField<?>, T4 extends DslField<?>, T5 extends DslField<?>> TemplateSpec.Template5<T1, T2, T3, T4, T5> template(Supplier<TemplateParam<T1>> param1, Supplier<TemplateParam<T2>> param2, Supplier<TemplateParam<T3>> param3, Supplier<TemplateParam<T4>> param4, Supplier<TemplateParam<T5>> param5) {
        return new TemplateSpec.Template5<T1, T2, T3, T4, T5>(param1, param2, param3, param4, param5);
    }

    public static <T, F extends Function<T>, M extends ValuePredicateMetadata<M>> F lift(T value, BiFunction<ValuePredicateMetadata, BiFunction<FieldModel, Context, Optional<T>>, F> constructorRef) {
        return (F)((Function)constructorRef.apply((ValuePredicateMetadata)ValuePredicateMetadata.valueMetadata(value), (m, c) -> Optional.ofNullable(value)));
    }

    @SafeVarargs
    public static <T> IterableFunction<T, List<T>> lift(T ... value) {
        List valueList = Arrays.asList(value);
        return new IterableFunction((PredicateMetadata)ValuePredicateMetadata.valueListMetadata(valueList), (m, c) -> Optional.of(valueList));
    }

    public static <T, F extends Function<T>> F fieldFunction(DslField<T> field, BiFunction<FieldMetadata<?>, BiFunction<FieldModel, Context, Optional<T>>, F> constructorRef) {
        return (F)((Function)constructorRef.apply(FieldMetadata.fieldMetadata(field), (m, c) -> FieldModel.valueModel(m, field)));
    }
}

