/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.meta.BinaryMetadata;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.NaryMetadata;
import io.doov.core.dsl.meta.ast.AstTextVisitor;
import io.doov.core.dsl.meta.i18n.ResourceProvider;
import java.util.Locale;

public class AstLineVisitor
extends AstTextVisitor {
    public AstLineVisitor(StringBuilder stringBuilder, ResourceProvider bundle, Locale locale) {
        super(stringBuilder, bundle, locale);
    }

    @Override
    protected String formatCurrentIndent() {
        return "";
    }

    @Override
    protected String formatNewLine() {
        return " ";
    }

    @Override
    public void startNary(NaryMetadata metadata, int depth) {
        super.startNary(metadata, depth);
        this.sb.append("[");
    }

    @Override
    public void afterChildNary(NaryMetadata metadata, Metadata child, boolean hasNext, int depth) {
        super.visitNary(metadata, depth);
        if (hasNext) {
            this.sb.delete(this.sb.length() - 1, this.sb.length());
            this.sb.append(", ");
        }
    }

    @Override
    public void endNary(NaryMetadata metadata, int depth) {
        super.endNary(metadata, depth);
        this.sb.delete(this.sb.length() - 1, this.sb.length());
        this.sb.append("] ");
    }

    @Override
    public void startBinary(BinaryMetadata metadata, int depth) {
        super.startBinary(metadata, depth);
        if (metadata.getOperator() == DefaultOperator.and || metadata.getOperator() == DefaultOperator.or || metadata.getLeft().type() == MetadataType.NARY_PREDICATE) {
            this.sb.append(depth > 0 ? "(" : "");
        } else if (metadata.type() == MetadataType.TEMPLATE_PARAM) {
            this.sb.append("{");
        }
    }

    @Override
    public void afterChildBinary(BinaryMetadata metadata, Metadata child, boolean hasNext, int depth) {
        if (metadata.type() == MetadataType.TEMPLATE_PARAM && metadata.getRight().type() != MetadataType.EMPTY) {
            this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
        } else if (hasNext && metadata.type() != MetadataType.TEMPLATE_PARAM) {
            this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
            this.sb.append(this.formatNewLine());
        } else if (hasNext) {
            this.sb.append(this.formatNewLine());
        }
    }

    @Override
    public void endBinary(BinaryMetadata metadata, int depth) {
        super.endBinary(metadata, depth);
        this.sb.delete(this.sb.length() - 1, this.sb.length());
        if (metadata.getOperator() == DefaultOperator.and || metadata.getOperator() == DefaultOperator.or || metadata.getLeft().type() == MetadataType.NARY_PREDICATE) {
            this.sb.append(depth > 0 ? ") " : " ");
        } else if (metadata.type() == MetadataType.TEMPLATE_PARAM) {
            this.sb.append("}");
        } else {
            this.sb.append(" ");
        }
    }

    @Override
    public void endRule(Metadata metadata, int depth) {
        super.endRule(metadata, depth);
        this.formatNewLine();
    }
}

