/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl.num;

import io.doov.core.FieldModel;
import io.doov.core.dsl.DslField;
import io.doov.core.dsl.field.types.NumericFieldInfo;
import io.doov.core.dsl.impl.num.NumericCondition;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.function.NumericFunctionMetadata;
import io.doov.core.dsl.meta.predicate.NaryPredicateMetadata;
import io.doov.core.dsl.meta.predicate.PredicateMetadata;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class NumericFunction<N extends Number>
extends NumericCondition<N> {
    public NumericFunction(DslField<N> field) {
        super(field);
    }

    public NumericFunction(PredicateMetadata metadata, BiFunction<FieldModel, Context, Optional<N>> value) {
        super(metadata, value);
    }

    protected abstract NumericFunction<N> numericFunction(PredicateMetadata var1, BiFunction<FieldModel, Context, Optional<N>> var2);

    public final NumericFunction<N> times(int multiplier) {
        return this.numericFunction(NumericFunctionMetadata.timesMetadata(this.metadata, multiplier), (model, context) -> this.value((FieldModel)model, (Context)context).map(v -> (Number)this.timesFunction().apply(v, multiplier)));
    }

    public final NumericFunction<N> plus(NumericFieldInfo<N> field) {
        return this.numericFunction(NumericFunctionMetadata.plusMetadata(this.metadata, field), (model, context) -> this.value((FieldModel)model, (Context)context).map(v -> (Number)this.sumFunction().apply(v, Optional.ofNullable(model.get(field.id())).orElse(this.identity()))));
    }

    public final NumericFunction<N> plus(N value) {
        return this.numericFunction(NumericFunctionMetadata.plusMetadata(this.metadata, value), (model, context) -> this.value((FieldModel)model, (Context)context).map(v -> (Number)this.sumFunction().apply(v, value)));
    }

    public final NumericFunction<N> plus(NumericFunction<N> numericFunction) {
        return this.numericFunction(NumericFunctionMetadata.plusMetadata(this.metadata, numericFunction), (model, context) -> this.value((FieldModel)model, (Context)context).map(v -> (Number)this.sumFunction().apply(v, numericFunction.value((FieldModel)model, (Context)context).orElse(this.identity()))));
    }

    public final NumericFunction<N> minus(NumericFieldInfo<N> field) {
        return this.numericFunction(NumericFunctionMetadata.minusMetadata(this.metadata, field), (model, context) -> this.value((FieldModel)model, (Context)context).map(v -> (Number)this.minusFunction().apply(v, Optional.ofNullable(model.get(field.id())).orElse(this.identity()))));
    }

    public final NumericFunction<N> minus(N value) {
        return this.numericFunction(NumericFunctionMetadata.minusMetadata(this.metadata, value), (model, context) -> this.value((FieldModel)model, (Context)context).map(v -> (Number)this.minusFunction().apply(v, value)));
    }

    public final NumericFunction<N> minus(NumericFunction<N> numericFunction) {
        return this.numericFunction(NumericFunctionMetadata.minusMetadata(this.metadata, numericFunction), (model, context) -> this.value((FieldModel)model, (Context)context).map(v -> (Number)this.minusFunction().apply(v, numericFunction.value((FieldModel)model, (Context)context).orElse(this.identity()))));
    }

    public final NumericFunction<N> min(List<NumericFieldInfo<N>> fields) {
        return this.numericFunction(NaryPredicateMetadata.minMetadata(NumericFunction.getMetadataForFields(fields)), (model, context) -> fields.stream().map(f -> Optional.ofNullable(model.get(f.id()))).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).reduce(this.minFunction()));
    }

    public final NumericFunction<N> sum(List<NumericFieldInfo<N>> fields) {
        return this.numericFunction(NaryPredicateMetadata.sumMetadata(NumericFunction.getMetadataForFields(fields)), (model, context) -> Optional.of(fields.stream().map(f -> Optional.ofNullable(model.get(f.id()))).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).reduce(this.identity(), this.sumFunction())));
    }

    public final NumericFunction<N> sumConditions(List<NumericCondition<N>> conditions) {
        return this.numericFunction(NaryPredicateMetadata.sumMetadata(NumericFunction.getMetadataForConditions(conditions)), (model, context) -> Optional.of(conditions.stream().map(c -> c.getFunction().apply((FieldModel)model, (Context)context)).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).reduce(this.identity(), this.sumFunction())));
    }

    private static <N extends Number> List<Metadata> getMetadataForFields(List<NumericFieldInfo<N>> fields) {
        return fields.stream().map(field -> (PredicateMetadata)field.getNumericFunction().getMetadata()).collect(Collectors.toList());
    }

    private static <N extends Number> List<Metadata> getMetadataForConditions(List<NumericCondition<N>> conditions) {
        return conditions.stream().map(condition -> (PredicateMetadata)condition.getMetadata()).collect(Collectors.toList());
    }

    public final NumericFunction<N> when(StepCondition condition) {
        return this.numericFunction(NumericFunctionMetadata.whenMetadata(this.metadata, condition), (model, context) -> condition.predicate().test((FieldModel)model, (Context)context) ? this.value((FieldModel)model, (Context)context) : Optional.empty());
    }
}

