/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl;

import io.doov.core.FieldModel;
import io.doov.core.dsl.DslField;
import io.doov.core.dsl.field.types.Function;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.meta.Metadata;
import java.util.Optional;
import java.util.function.BiFunction;

public class DefaultFunction<N, M extends Metadata>
implements Function<N> {
    protected final M metadata;
    protected final BiFunction<FieldModel, Context, Optional<N>> function;

    protected static <T> Optional<T> valueModel(FieldModel model, DslField<T> field) {
        return Optional.ofNullable(model.get(field.id()));
    }

    protected DefaultFunction(M metadata, BiFunction<FieldModel, Context, Optional<N>> function) {
        this.metadata = metadata;
        this.function = function;
    }

    @Override
    public Optional<N> value(FieldModel model, Context context) {
        return this.function.apply(model, context);
    }

    public M getMetadata() {
        return this.metadata;
    }

    public BiFunction<FieldModel, Context, Optional<N>> getFunction() {
        return this.function;
    }

    @Override
    public String readable() {
        return this.metadata.readable();
    }
}

