/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.meta.BinaryMetadata;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.NaryMetadata;
import io.doov.core.dsl.meta.ReturnType;
import io.doov.core.dsl.meta.ast.AstLineVisitor;
import io.doov.core.dsl.meta.i18n.ResourceProvider;
import io.doov.core.dsl.meta.predicate.PredicateMetadata;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import java.util.stream.Collectors;

public class AstLinePercentVisitor
extends AstLineVisitor {
    public AstLinePercentVisitor(StringBuilder stringBuilder, ResourceProvider bundle, Locale locale) {
        super(stringBuilder, bundle, locale);
    }

    @Override
    public void startWhen(Metadata metadata, int depth) {
        this.sb.append(this.percentage(metadata.children().findFirst().orElse(null)) + " ");
        super.startWhen(metadata, depth);
    }

    @Override
    public void startBinary(BinaryMetadata metadata, int depth) {
        super.startBinary(metadata, depth);
        if (((Metadata)metadata.children().collect(Collectors.toList()).get(0)).type() == MetadataType.NARY_PREDICATE) {
            this.sb.append(this.percentage(metadata));
        }
    }

    @Override
    public void startNary(NaryMetadata metadata, int depth) {
        if (metadata.getOperator() != DefaultOperator.count && metadata.getOperator() != DefaultOperator.sum) {
            this.sb.append(this.percentage(metadata));
        }
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
        this.sb.append(this.formatNewLine());
        this.sb.append("[");
    }

    @Override
    protected String formatLeafMetadata(LeafMetadata<?> metadata) {
        if (this.stackPeekType() == MetadataType.BINARY_PREDICATE) {
            return super.formatLeafMetadata(metadata);
        }
        return this.percentage(metadata) + super.formatLeafMetadata(metadata);
    }

    private String percentage(Metadata metadata) {
        if (metadata.getOperator().returnType() == ReturnType.BOOLEAN) {
            PredicateMetadata pmd = (PredicateMetadata)metadata;
            int t = pmd.trueEvalCount();
            int f = pmd.falseEvalCount();
            if (f == 0 && t == 0) {
                return "[n/a]";
            }
            BigDecimal percentage = BigDecimal.valueOf(this.getPercentage(t, f)).setScale(1, RoundingMode.HALF_UP);
            return "[" + percentage.toPlainString() + "]";
        }
        return "";
    }

    protected double getPercentage(int t, int f) {
        return (double)t / ((double)t + (double)f) * 100.0;
    }
}

