/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core;

import io.doov.core.FieldId;
import io.doov.core.FieldModel;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class FieldModels {
    public static <Fm extends FieldModel> Collector<Map.Entry<FieldId, Object>, ?, Fm> toFieldModel(Fm model) {
        return new FieldModelCollector<Fm>(model);
    }

    public static <Fm extends FieldModel> Collector<Map.Entry<FieldId, Object>, ?, Fm> toConcurrentFieldModel(Fm model) {
        return new ConcurrentFieldModelCollector<Fm>(model);
    }

    private static final class ConcurrentFieldModelCollector<Fm extends FieldModel>
    implements Collector<Map.Entry<FieldId, Object>, Fm, Fm> {
        private final Fm model;
        private final ReentrantLock lock;

        ConcurrentFieldModelCollector(Fm model) {
            this.model = model;
            this.lock = new ReentrantLock();
        }

        @Override
        public Supplier<Fm> supplier() {
            return () -> this.model;
        }

        @Override
        public BiConsumer<Fm, Map.Entry<FieldId, Object>> accumulator() {
            return (supplier, entry) -> {
                Object value = entry.getValue();
                if (value == null) {
                    return;
                }
                this.lock.lock();
                try {
                    supplier.set((FieldId)entry.getKey(), value);
                }
                finally {
                    this.lock.unlock();
                }
            };
        }

        @Override
        public BinaryOperator<Fm> combiner() {
            return (m1, m2) -> m1;
        }

        @Override
        public Function<Fm, Fm> finisher() {
            return m -> this.model;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.allOf(Collector.Characteristics.class);
        }
    }

    private static final class FieldModelCollector<Fm extends FieldModel>
    implements Collector<Map.Entry<FieldId, Object>, Fm, Fm> {
        private final Fm model;

        FieldModelCollector(Fm model) {
            this.model = model;
        }

        @Override
        public Supplier<Fm> supplier() {
            return () -> this.model;
        }

        @Override
        public BiConsumer<Fm, Map.Entry<FieldId, Object>> accumulator() {
            return (model, entry) -> {
                Object value = entry.getValue();
                if (value != null) {
                    model.set((FieldId)entry.getKey(), value);
                }
            };
        }

        @Override
        public BinaryOperator<Fm> combiner() {
            return (m1, m2) -> m1;
        }

        @Override
        public Function<Fm, Fm> finisher() {
            return m -> this.model;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.allOf(Collector.Characteristics.class);
        }
    }
}

