/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.lang.ValidationRule;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.Operator;
import io.doov.core.dsl.meta.ReturnType;
import io.doov.core.dsl.meta.ast.ExclusionBar;
import io.doov.core.dsl.meta.ast.HtmlWriter;
import io.doov.core.dsl.meta.i18n.ResourceProvider;
import io.doov.core.dsl.meta.predicate.PredicateMetadata;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.text.StringEscapeUtils;

public class DefaultHtmlWriter
implements HtmlWriter {
    private final Locale locale;
    private final OutputStream os;
    private final ResourceProvider resources;
    private static final List<Operator> OP_BOOLEAN_PARAMS = Arrays.asList(DefaultOperator.and, DefaultOperator.or, DefaultOperator.match_all, DefaultOperator.match_any, DefaultOperator.match_none, DefaultOperator.count, DefaultOperator.when);
    private static final List<Operator> OP_BIG_BAR = Arrays.asList(DefaultOperator.match_all, DefaultOperator.match_any, DefaultOperator.match_none);

    public DefaultHtmlWriter(Locale locale, OutputStream os, ResourceProvider resources) {
        this.locale = locale;
        this.os = os;
        this.resources = resources;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void write(String value) {
        try {
            this.os.write(value.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String beginElement(String elementType, String ... classes) {
        return "<" + elementType + (classes.length > 0 ? " class='" + String.join((CharSequence)" ", classes) + "'" : "") + ">";
    }

    private static String beginElementWithStyle(String elementType, String style, String ... classes) {
        return "<" + elementType + (classes.length > 0 ? " class='" + String.join((CharSequence)" ", classes) + "'" : "") + (style != null ? " style='" + style + "'" : "") + ">";
    }

    private static String endElement(String elementType) {
        return "</" + elementType + ">";
    }

    private static String beginLi(String ... classes) {
        return DefaultHtmlWriter.beginElement("li", classes);
    }

    private static String endLi() {
        return DefaultHtmlWriter.endElement("li");
    }

    private static String beginUl(String ... classes) {
        return DefaultHtmlWriter.beginElement("ul", classes);
    }

    private static String endUl() {
        return DefaultHtmlWriter.endElement("ul");
    }

    private static String beginOl(String ... classes) {
        return DefaultHtmlWriter.beginElement("ol", classes);
    }

    private static String endOl() {
        return DefaultHtmlWriter.endElement("ol");
    }

    private static String beginDiv(String ... classes) {
        return DefaultHtmlWriter.beginElement("div", classes);
    }

    private static String beginSpan(String ... classes) {
        return DefaultHtmlWriter.beginElement("span", classes);
    }

    private static String beginDivWithStyle(String style, String ... classes) {
        return DefaultHtmlWriter.beginElementWithStyle("div", style, classes);
    }

    private static String endDiv() {
        return DefaultHtmlWriter.endElement("div");
    }

    private static String endSpan() {
        return DefaultHtmlWriter.endElement("span");
    }

    private static String exclusionBar(PredicateMetadata metadata, ExclusionBar cssClass, Locale locale) {
        int nbTrue = metadata.trueEvalCount();
        int nbFalse = metadata.falseEvalCount();
        if (nbTrue == 0 && nbFalse == 0) {
            return DefaultHtmlWriter.formatExclusionBar(cssClass);
        }
        double percentage = Math.floor((double)nbTrue / ((double)nbTrue + (double)nbFalse) * 1000.0) / 10.0;
        return DefaultHtmlWriter.formatExclusionBar(cssClass, percentage, locale);
    }

    private static String formatExclusionBar(ExclusionBar cssClass) {
        return DefaultHtmlWriter.beginDiv(cssClass.getWrapperClass()) + DefaultHtmlWriter.beginDiv("percentage-value") + " n/a" + DefaultHtmlWriter.endDiv() + DefaultHtmlWriter.beginDiv(cssClass.getBorderClass()) + DefaultHtmlWriter.beginDivWithStyle("width:0%;", cssClass.getFillingClass()) + DefaultHtmlWriter.endDiv() + DefaultHtmlWriter.endDiv() + DefaultHtmlWriter.endDiv();
    }

    private static String formatExclusionBar(ExclusionBar cssClass, double percentage, Locale locale) {
        return DefaultHtmlWriter.beginDiv(cssClass.getWrapperClass()) + DefaultHtmlWriter.beginDiv("percentage-value") + NumberFormat.getInstance(locale).format(percentage) + " %" + DefaultHtmlWriter.endDiv() + DefaultHtmlWriter.beginDiv(cssClass.getBorderClass()) + DefaultHtmlWriter.beginDivWithStyle("width:" + percentage + "%;", cssClass.getFillingClass()) + DefaultHtmlWriter.endDiv() + DefaultHtmlWriter.endDiv() + DefaultHtmlWriter.endDiv();
    }

    public static String exclusionBar(ValidationRule rule, ExclusionBar cssClass, Locale locale) {
        Metadata conditionMetadata = rule.getStepWhen().stepCondition().metadata();
        if (conditionMetadata instanceof PredicateMetadata) {
            return DefaultHtmlWriter.exclusionBar((PredicateMetadata)conditionMetadata, cssClass, locale);
        }
        return "";
    }

    @Override
    public void writeFromBundle(Operator operator) {
        this.write(this.resources.get(operator, this.locale));
    }

    @Override
    public void writeFromBundle(String key) {
        this.write(this.resources.get(key, this.locale));
    }

    @Override
    public void writeBeginLi(String ... classes) {
        this.write(DefaultHtmlWriter.beginLi(classes));
    }

    @Override
    public void writeEndLi() {
        this.write(DefaultHtmlWriter.endLi());
    }

    @Override
    public void writeBeginUl(String ... classes) {
        this.write(DefaultHtmlWriter.beginUl(classes));
    }

    @Override
    public void writeEndUl() {
        this.write(DefaultHtmlWriter.endUl());
    }

    @Override
    public void writeBeginOl(String ... classes) {
        this.write(DefaultHtmlWriter.beginOl(classes));
    }

    @Override
    public void writeEndOl() {
        this.write(DefaultHtmlWriter.endOl());
    }

    @Override
    public void writeBeginDiv(String ... classes) {
        this.write(DefaultHtmlWriter.beginDiv(classes));
    }

    @Override
    public void writeBeginSpan(String ... classes) {
        this.write(DefaultHtmlWriter.beginSpan(classes));
    }

    @Override
    public void writeBeginDivWithStyle(String style, String ... classes) {
        this.write(DefaultHtmlWriter.beginDivWithStyle(style, classes));
    }

    @Override
    public void writeEndDiv() {
        this.write(DefaultHtmlWriter.endDiv());
    }

    @Override
    public void writeEndSpan() {
        this.write(DefaultHtmlWriter.endSpan());
    }

    @Override
    public void writeExclusionBar(Metadata metadata, ArrayDeque<Metadata> parents) {
        Optional pmd = parents.stream().skip(1L).findFirst();
        if (metadata.getOperator().returnType() == ReturnType.BOOLEAN || pmd.map(m -> OP_BOOLEAN_PARAMS.contains(m.getOperator())).orElse(false).booleanValue()) {
            ExclusionBar barSize = pmd.map(m -> m.getOperator() == DefaultOperator.when || OP_BIG_BAR.contains(metadata.getOperator()) ? ExclusionBar.BIG : ExclusionBar.SMALL).orElse(ExclusionBar.SMALL);
            this.write(DefaultHtmlWriter.exclusionBar((PredicateMetadata)metadata, barSize, this.locale));
        }
    }

    @Override
    public String escapeHtml4(String readable) {
        return StringEscapeUtils.escapeHtml4((String)readable);
    }
}

