/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataVisitor;
import io.doov.core.dsl.meta.ast.AstHtmlRenderer;
import io.doov.core.dsl.meta.ast.AstLineVisitor;
import io.doov.core.dsl.meta.ast.AstMarkdownRenderer;
import io.doov.core.dsl.meta.ast.DefaultHtmlWriter;
import io.doov.core.dsl.meta.i18n.ResourceBundleProvider;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class AstVisitorUtils {
    public static String astToString(Metadata metadata, Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        new AstLineVisitor(stringBuilder, ResourceBundleProvider.BUNDLE, locale).browse(metadata, 0);
        return stringBuilder.toString();
    }

    public static String astToMarkdown(Metadata metadata, Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        new AstMarkdownRenderer(stringBuilder, ResourceBundleProvider.BUNDLE, locale).toMarkdown(metadata);
        return stringBuilder.toString();
    }

    public static Set<Metadata> collectMetadata(Metadata root) {
        final HashSet<Metadata> metadatas = new HashSet<Metadata>();
        new MetadataVisitor(){

            @Override
            public void start(Metadata metadata, int depth) {
                metadatas.add(metadata);
            }
        }.browse(root, 0);
        return metadatas;
    }

    public static String toHtml(Metadata metadata, Locale locale) {
        ByteArrayOutputStream ops = new ByteArrayOutputStream();
        DefaultHtmlWriter htmlWriter = new DefaultHtmlWriter(locale, ops, ResourceBundleProvider.BUNDLE);
        new AstHtmlRenderer(htmlWriter).toHtml(metadata);
        return new String(ops.toByteArray(), StandardCharsets.UTF_8);
    }
}

