/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.Element;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.MappingOperator;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.Operator;
import io.doov.core.dsl.meta.ReturnType;
import io.doov.core.dsl.meta.function.TemplateParamMetadata;
import io.doov.core.dsl.meta.i18n.ResourceBundleProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;

public class AstMarkdownRenderer {
    private static final List<Operator> AND_OR = Arrays.asList(DefaultOperator.and, DefaultOperator.or);
    private static final List<Operator> MATCH_VALUES = Arrays.asList(DefaultOperator.all_match_values, DefaultOperator.any_match_values);
    private StringBuilder sb;
    private ResourceBundleProvider bundle;
    private Locale locale;

    public AstMarkdownRenderer(StringBuilder sb, ResourceBundleProvider bundle, Locale locale) {
        this.sb = sb;
        this.bundle = bundle;
        this.locale = locale;
    }

    public String toString() {
        return this.sb.toString();
    }

    public void toMarkdown(Metadata metadata) {
        this.toMarkdown(metadata, new ArrayDeque<Metadata>(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void toMarkdown(Metadata metadata, ArrayDeque<Metadata> parents, int indent) {
        parents.push(metadata);
        try {
            switch (metadata.type()) {
                case RULE: {
                    this.rule(metadata, parents, indent);
                    return;
                }
                case WHEN: {
                    this.when(metadata, parents, indent);
                    return;
                }
                case BINARY_PREDICATE: 
                case TEMPLATE_PARAM: {
                    this.binary(metadata, parents, indent);
                    return;
                }
                case LEAF_PREDICATE: 
                case FIELD_PREDICATE: 
                case LEAF_VALUE: 
                case MAPPING_LEAF: 
                case TEMPLATE_IDENTIFIER: 
                case FIELD_PREDICATE_MATCH_ANY: {
                    this.leaf(metadata, parents, indent);
                    return;
                }
                case UNARY_PREDICATE: {
                    this.unary(metadata, parents, indent);
                    return;
                }
                case NARY_PREDICATE: {
                    this.nary(metadata, parents, indent);
                    return;
                }
                case SINGLE_MAPPING: {
                    this.singleMapping(metadata, parents, indent);
                    return;
                }
                case MULTIPLE_MAPPING: {
                    this.multipleMapping(metadata, parents, indent);
                    return;
                }
                case TYPE_CONVERTER: {
                    this.typeConverter(metadata, parents, indent);
                }
                case THEN_MAPPING: 
                case ELSE_MAPPING: 
                case MAPPING_INPUT: {
                    this.mappingFragment(metadata, parents, indent);
                    return;
                }
                default: {
                    throw new IllegalStateException(metadata.type().name());
                }
            }
        }
        finally {
            parents.pop();
        }
    }

    private void mappingFragment(Metadata metadata, ArrayDeque<Metadata> parents, int indent) {
        switch (metadata.type()) {
            case THEN_MAPPING: {
                this.sb.append(this.bundle.get(MappingOperator.then, this.locale));
                this.sb.append("\n");
                break;
            }
            case ELSE_MAPPING: {
                this.sb.append(this.bundle.get(MappingOperator._else, this.locale));
                this.sb.append("\n");
                break;
            }
        }
        Optional pmd = parents.stream().skip(1L).findFirst();
        List childs = metadata.children().collect(Collectors.toList());
        for (Metadata child : childs) {
            if (childs.indexOf(child) == 0 && pmd.isPresent() && ((Metadata)pmd.get()).type() != MetadataType.MULTIPLE_MAPPING) {
                this.toMarkdown(child, parents, indent + 1);
            } else {
                this.formatIndent(indent + 2);
                this.sb.append("* ");
                this.toMarkdown(child, parents, indent + 2);
            }
            if (childs.indexOf(child) == childs.size() - 1) continue;
            this.sb.append("\n");
        }
    }

    private void typeConverter(Metadata metadata, ArrayDeque<Metadata> parents, int indent) {
        this.sb.append(this.bundle.get(MappingOperator.using, this.locale));
        this.sb.append(" ");
        this.leaf(metadata, parents, indent);
    }

    private void singleMapping(Metadata metadata, ArrayDeque<Metadata> parents, int indent) {
        Optional pmd = parents.stream().skip(1L).findFirst();
        if (!pmd.isPresent()) {
            this.formatIndent(indent);
            this.sb.append("* ");
        }
        this.sb.append(this.bundle.get(MappingOperator.map, this.locale));
        this.sb.append(" ");
        this.toMarkdown(metadata.childAt(0), parents, indent);
        this.sb.append("\n");
        this.formatIndent(indent + 1);
        this.sb.append("* ");
        this.sb.append(this.bundle.get(MappingOperator.to, this.locale));
        this.sb.append(" ");
        this.toMarkdown(metadata.childAt(1), parents, indent + 1);
        this.sb.append("\n");
    }

    private void multipleMapping(Metadata metadata, ArrayDeque<Metadata> parents, int indent) {
        Optional pmd = parents.stream().skip(1L).findFirst();
        if (!pmd.isPresent()) {
            this.formatIndent(indent);
            this.sb.append("* ");
        }
        this.sb.append(this.bundle.get(MappingOperator.mappings, this.locale));
        this.sb.append("\n");
        List childs = metadata.children().filter(m -> m.children().count() > 0L).collect(Collectors.toList());
        for (Metadata child : childs) {
            this.formatIndent(indent + 1);
            this.sb.append("* ");
            this.toMarkdown(child, parents, indent + 1);
            if (childs.indexOf(child) == childs.size() - 1) continue;
            this.sb.append("\n");
        }
    }

    private void nary(Metadata metadata, ArrayDeque<Metadata> parents, int indent) {
        this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
        this.sb.append("\n");
        List childs = metadata.children().collect(Collectors.toList());
        for (Metadata child : childs) {
            this.formatIndent(indent + 1);
            this.sb.append("* ");
            this.toMarkdown(child, parents, indent + 1);
            if (childs.indexOf(child) == childs.size() - 1) continue;
            this.sb.append("\n");
        }
    }

    private void unary(Metadata metadata, ArrayDeque<Metadata> parents, int indent) {
        if (metadata.getOperator() == DefaultOperator.not) {
            this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
            this.sb.append("\n");
            this.formatIndent(indent + 1);
            this.sb.append("* ");
            this.toMarkdown(metadata.childAt(0), parents, indent + 1);
        } else {
            this.toMarkdown(metadata.childAt(0), parents, indent + 1);
            this.sb.append(" ");
            this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
        }
    }

    private void leaf(Metadata metadata, ArrayDeque<Metadata> parents, int indent) {
        ArrayList<Element> elts = new ArrayList<Element>(((LeafMetadata)metadata).elements());
        for (Element e : elts) {
            switch (e.getType()) {
                case OPERATOR: {
                    this.sb.append(this.bundle.get((Operator)e.getReadable(), this.locale));
                    break;
                }
                case TEMPORAL_UNIT: {
                    this.sb.append(this.bundle.get(e.getReadable().readable(), this.locale));
                    break;
                }
                case FIELD: {
                    Metadata fieldMetadata = ((DslField)e.getReadable()).getMetadata();
                    if (fieldMetadata.type() == MetadataType.TEMPLATE_PARAM) {
                        this.templateParam((TemplateParamMetadata)fieldMetadata);
                        break;
                    }
                    this.sb.append(fieldMetadata.readable(this.locale));
                    break;
                }
                case STRING_VALUE: {
                    this.sb.append("&apos;");
                    this.sb.append(e.getReadable().readable());
                    this.sb.append("&apos;");
                    break;
                }
                case VALUE: {
                    this.sb.append("'");
                    this.sb.append(e.getReadable().readable());
                    this.sb.append("'");
                    break;
                }
                default: {
                    this.sb.append(e.getReadable().readable());
                }
            }
            if (elts.indexOf(e) == elts.size() - 1) continue;
            this.sb.append(" ");
        }
    }

    private void templateParam(TemplateParamMetadata metadata) {
        this.sb.append("{");
        this.sb.append(metadata.childAt(0).readable(this.locale));
        if (metadata.getRight().type() != MetadataType.EMPTY) {
            this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
            this.sb.append(metadata.childAt(1).readable(this.locale));
        }
        this.sb.append("}");
    }

    private void binary(Metadata metadata, ArrayDeque<Metadata> parents, int indent) {
        if (metadata.type() == MetadataType.TEMPLATE_PARAM) {
            this.templateParam((TemplateParamMetadata)metadata);
        } else if (MATCH_VALUES.contains(metadata.getOperator())) {
            this.toMarkdown(metadata.childAt(0), parents, indent + 1);
            this.sb.append(" ");
            this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
            this.sb.append(" ");
            this.toMarkdown(metadata.childAt(1), parents, indent + 1);
            this.sb.append("\n");
        } else if (metadata.getOperator().returnType() == ReturnType.BOOLEAN) {
            Metadata childAt_0 = metadata.childAt(0);
            Metadata childAt_1 = metadata.childAt(1);
            if (childAt_0 != null && childAt_1 != null) {
                if (AND_OR.contains(childAt_1.getOperator())) {
                    this.toMarkdown(metadata.childAt(0), parents, indent + 1);
                    this.sb.append(" ");
                    this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
                    this.sb.append("\n");
                    this.formatIndent(indent + 1);
                    this.sb.append("* ");
                    this.toMarkdown(childAt_1, parents, indent + 1);
                } else if (childAt_1.getOperator().returnType() == ReturnType.BOOLEAN) {
                    this.toMarkdown(metadata.childAt(0), parents, indent);
                    this.sb.append(" ");
                    this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
                    this.sb.append("\n");
                    this.formatIndent(indent);
                    this.sb.append("* ");
                    this.toMarkdown(childAt_1, parents, indent);
                } else if (childAt_0.type() == MetadataType.FIELD_PREDICATE || childAt_0.type() != MetadataType.NARY_PREDICATE && (childAt_1.type() == MetadataType.LEAF_VALUE || childAt_1.type() == MetadataType.FIELD_PREDICATE)) {
                    this.toMarkdown(metadata.childAt(0), parents, indent);
                    this.sb.append(" ");
                    this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
                    this.sb.append(" ");
                    this.toMarkdown(childAt_1, parents, indent);
                } else {
                    this.toMarkdown(metadata.childAt(0), parents, indent);
                    this.sb.append(" ");
                    this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
                    this.sb.append("\n");
                    this.formatIndent(indent);
                    this.sb.append("* ");
                    this.toMarkdown(childAt_1, parents, indent);
                }
            }
        } else {
            this.toMarkdown(metadata.childAt(0), parents, indent + 1);
            this.sb.append(" ");
            this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
            this.sb.append(" ");
            this.toMarkdown(metadata.childAt(1), parents, indent + 1);
        }
    }

    private void when(Metadata metadata, ArrayDeque<Metadata> parents, int indent) {
        Optional pmd = parents.stream().skip(1L).findFirst();
        this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
        this.sb.append("\n");
        metadata.children().forEach(md -> {
            this.formatIndent(indent + 1);
            this.sb.append("* ");
            this.toMarkdown((Metadata)md, parents, indent + 1);
        });
        if (pmd.isPresent() && ((Metadata)pmd.get()).type() == MetadataType.RULE) {
            this.sb.append("\n");
            this.formatIndent(indent);
            this.sb.append("* ");
            this.sb.append(this.bundle.get(DefaultOperator.validate, this.locale));
            this.sb.append("\n");
        }
    }

    private void rule(Metadata metadata, ArrayDeque<Metadata> parents, int indent) {
        this.formatIndent(indent);
        this.sb.append("* ");
        this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
        this.sb.append("\n");
        this.formatIndent(indent + 1);
        this.sb.append("* ");
        metadata.children().forEach(md -> this.toMarkdown((Metadata)md, parents, indent + 1));
    }

    private void formatIndent(int indent) {
        for (int i = 0; i < indent; ++i) {
            this.sb.append("  ");
        }
    }
}

