/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.meta.BinaryMetadata;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.MappingOperator;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.NaryMetadata;
import io.doov.core.dsl.meta.Operator;
import io.doov.core.dsl.meta.UnaryMetadata;
import io.doov.core.dsl.meta.ast.AbstractAstVisitor;
import io.doov.core.dsl.meta.i18n.ResourceProvider;
import java.util.Locale;
import java.util.stream.Collectors;

public class AstTextVisitor
extends AbstractAstVisitor {
    private static final int INDENT_SIZE = 2;
    protected final StringBuilder sb;
    protected final ResourceProvider bundle;
    protected final Locale locale;
    protected int newLineIndex = 0;

    public AstTextVisitor(StringBuilder sb, ResourceProvider bundle, Locale locale) {
        this.sb = sb;
        this.bundle = bundle;
        this.locale = locale;
    }

    protected int getNewLineIndex() {
        return this.newLineIndex;
    }

    @Override
    protected String formatNewLine() {
        this.newLineIndex = this.sb.length();
        return "\n";
    }

    @Override
    public void startLeaf(LeafMetadata<?> metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(this.formatLeafMetadata(metadata));
        if (this.stackPeek() != null && this.stackPeek().type() != MetadataType.TEMPLATE_PARAM) {
            this.sb.append(this.formatNewLine());
        }
    }

    @Override
    public void endUnary(UnaryMetadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void afterChildBinary(BinaryMetadata metadata, Metadata child, boolean hasNext, int depth) {
        if (hasNext) {
            this.sb.delete(this.getNewLineIndex(), this.sb.length());
            this.sb.append(" ");
            this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
            this.sb.append(this.formatNewLine());
        }
    }

    @Override
    public void startNary(NaryMetadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void startRule(Metadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(this.formatRule());
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void endRule(Metadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(this.formatValidate());
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void startWhen(Metadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(this.formatWhen());
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void startTypeConverter(LeafMetadata<?> metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(this.formatUsing());
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void endTypeConverter(LeafMetadata<?> metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(this.formatLeafMetadata(metadata));
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void startMappingRule(Metadata metadata, int depth) {
        switch (metadata.type()) {
            case SINGLE_MAPPING: {
                this.sb.append(this.formatCurrentIndent());
                this.sb.append(this.formatOperator(MappingOperator.map));
                this.sb.append(this.formatNewLine());
                break;
            }
            case THEN_MAPPING: {
                this.sb.append(this.formatCurrentIndent());
                this.sb.append(this.formatOperator(MappingOperator.then));
                this.sb.append(this.formatNewLine());
                break;
            }
            case ELSE_MAPPING: {
                this.sb.append(this.formatCurrentIndent());
                this.sb.append(this.formatOperator(MappingOperator._else));
                this.sb.append(this.formatNewLine());
                break;
            }
            case MAPPING_LEAF: {
                this.sb.append(this.formatCurrentIndent());
                this.sb.append(this.formatLeafMetadata((LeafMetadata)metadata));
                this.sb.append(this.formatNewLine());
                break;
            }
        }
    }

    @Override
    public void afterChildMappingRule(Metadata metadata, Metadata child, boolean hasNext, int depth) {
        switch (metadata.type()) {
            case MAPPING_LEAF: {
                this.sb.append(this.formatCurrentIndent());
                this.sb.append(this.formatLeafMetadata((LeafMetadata)metadata));
                this.sb.append(this.formatNewLine());
                break;
            }
            case SINGLE_MAPPING: {
                if (!hasNext) break;
                this.sb.append(this.formatCurrentIndent());
                this.sb.append(this.formatOperator(MappingOperator.to));
                this.sb.append(this.formatNewLine());
                break;
            }
        }
    }

    @Override
    protected int getIndentSize() {
        return 2;
    }

    @Override
    protected int getCurrentIndentSize() {
        if (MetadataType.BINARY_PREDICATE == this.stackPeekType()) {
            return (int)this.stackSteam().filter(e -> !MetadataType.BINARY_PREDICATE.equals(e)).count() * this.getIndentSize();
        }
        return super.getCurrentIndentSize();
    }

    protected String formatLeafMetadata(LeafMetadata<?> metadata) {
        return metadata.elements().stream().map(e -> {
            switch (e.getType()) {
                case OPERATOR: {
                    return this.bundle.get((Operator)e.getReadable(), this.locale);
                }
                case FIELD: {
                    return this.bundle.get(e.getReadable().readable(), this.locale);
                }
                case STRING_VALUE: {
                    return "'" + this.bundle.get(e.getReadable().readable(), this.locale) + "'";
                }
            }
            return this.bundle.get(e.getReadable().readable(), this.locale);
        }).collect(Collectors.joining(" "));
    }

    protected String formatOperator(Operator operator) {
        return operator == null ? null : operator.readable();
    }

    protected String formatRule() {
        return this.bundle.get(DefaultOperator.rule, this.locale);
    }

    protected String formatValidate() {
        return this.bundle.get(DefaultOperator.validate, this.locale);
    }

    protected String formatWhen() {
        return this.bundle.get(DefaultOperator.when, this.locale);
    }

    private String formatUsing() {
        return this.bundle.get(MappingOperator.using, this.locale);
    }
}

