/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta;

import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.Readable;
import io.doov.core.dsl.lang.ReduceType;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.Operator;
import io.doov.core.dsl.meta.ast.AstVisitorUtils;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Metadata
extends Readable {
    default public Operator getOperator() {
        return DefaultOperator.no_operator;
    }

    default public String readable(Locale locale) {
        return AstVisitorUtils.astToString(this, locale).trim();
    }

    @Override
    default public String readable() {
        return this.readable(Locale.getDefault());
    }

    default public String markdown() {
        return this.markdown(Locale.getDefault());
    }

    default public String markdown(Locale locale) {
        return AstVisitorUtils.astToMarkdown(this, locale);
    }

    default public Stream<Metadata> left() {
        return Stream.empty();
    }

    default public Stream<Metadata> right() {
        return Stream.empty();
    }

    default public Stream<Metadata> children() {
        return Stream.concat(this.left(), this.right());
    }

    default public Metadata childAt(int ... positions) {
        if (positions == null) {
            return null;
        }
        if (positions.length == 0) {
            return null;
        }
        return this.childAt(positions, 0);
    }

    default public Metadata childAt(int[] positions, int level) {
        List childrens = this.children().collect(Collectors.toList());
        Metadata child = (Metadata)childrens.get(positions[level]);
        if (level < positions.length - 1) {
            return child.childAt(positions, level + 1);
        }
        return child;
    }

    public MetadataType type();

    default public Metadata reduce(Context context, ReduceType type) {
        return this;
    }
}

