/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl.num;

import io.doov.core.dsl.impl.num.NumericOperators;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;

public interface FloatOperators
extends NumericOperators<Float> {
    @Override
    default public BiFunction<Float, Float, Boolean> lesserThanFunction() {
        return (l, r) -> l.floatValue() < r.floatValue();
    }

    @Override
    default public BiFunction<Float, Float, Boolean> lesserOrEqualsFunction() {
        return (l, r) -> l.floatValue() <= r.floatValue();
    }

    @Override
    default public BiFunction<Float, Float, Boolean> greaterThanFunction() {
        return (l, r) -> l.floatValue() > r.floatValue();
    }

    @Override
    default public BiFunction<Float, Float, Boolean> greaterOrEqualsFunction() {
        return (l, r) -> l.floatValue() >= r.floatValue();
    }

    @Override
    default public BinaryOperator<Float> minFunction() {
        return Float::min;
    }

    @Override
    default public BinaryOperator<Float> sumFunction() {
        return Float::sum;
    }

    @Override
    default public BiFunction<Float, Integer, Float> timesFunction() {
        return (l, r) -> Float.valueOf(l.floatValue() * (float)r.intValue());
    }

    @Override
    default public Float identity() {
        return Float.valueOf(0.0f);
    }
}

