/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.ast.AstTextVisitor;
import io.doov.core.dsl.meta.i18n.ResourceProvider;
import io.doov.core.dsl.meta.predicate.BinaryPredicateMetadata;
import io.doov.core.dsl.meta.predicate.NaryPredicateMetadata;
import java.util.Locale;

public class AstLineVisitor
extends AstTextVisitor {
    public AstLineVisitor(StringBuilder stringBuilder, ResourceProvider bundle, Locale locale) {
        super(stringBuilder, bundle, locale);
    }

    @Override
    protected String formatCurrentIndent() {
        return "";
    }

    @Override
    protected String formatNewLine() {
        return " ";
    }

    @Override
    public void startNary(NaryPredicateMetadata metadata, int depth) {
        super.startNary(metadata, depth);
        this.sb.append("[");
    }

    @Override
    public void afterChildNary(NaryPredicateMetadata metadata, Metadata child, boolean hasNext, int depth) {
        super.visitNary(metadata, depth);
        if (hasNext) {
            this.sb.delete(this.sb.length() - 1, this.sb.length());
            this.sb.append(", ");
        }
    }

    @Override
    public void endNary(NaryPredicateMetadata metadata, int depth) {
        super.endNary(metadata, depth);
        this.sb.delete(this.sb.length() - 1, this.sb.length());
        this.sb.append("] ");
    }

    @Override
    public void startBinary(BinaryPredicateMetadata metadata, int depth) {
        super.startBinary(metadata, depth);
        if (metadata.getOperator() == DefaultOperator.and || metadata.getOperator() == DefaultOperator.or || metadata.getLeft().type() == MetadataType.NARY_PREDICATE) {
            this.sb.append(depth > 0 ? "(" : "");
        }
    }

    @Override
    public void afterChildBinary(BinaryPredicateMetadata metadata, Metadata child, boolean hasNext, int depth) {
        if (hasNext) {
            this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
            this.sb.append(this.formatNewLine());
        }
    }

    @Override
    public void endBinary(BinaryPredicateMetadata metadata, int depth) {
        super.endBinary(metadata, depth);
        this.sb.delete(this.sb.length() - 1, this.sb.length());
        if (metadata.getOperator() == DefaultOperator.and || metadata.getOperator() == DefaultOperator.or || metadata.getLeft().type() == MetadataType.NARY_PREDICATE) {
            this.sb.append(depth > 0 ? ") " : " ");
        } else {
            this.sb.append(" ");
        }
    }

    @Override
    public void endRule(Metadata metadata, int depth) {
        super.endRule(metadata, depth);
        this.formatNewLine();
    }
}

