/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.meta.Element;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.ast.AbstractAstVisitor;
import io.doov.core.dsl.meta.predicate.BinaryPredicateMetadata;
import io.doov.core.dsl.meta.predicate.NaryPredicateMetadata;
import io.doov.core.dsl.meta.predicate.UnaryPredicateMetadata;

public class AstFullVisitor
extends AbstractAstVisitor {
    private static final int INDENT_SIZE = 4;
    private final StringBuilder sb;

    public AstFullVisitor(StringBuilder sb) {
        this.sb = sb;
    }

    @Override
    public void afterChildDefault(Metadata metadata, Metadata child, boolean hasNext, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("visit Metadata ").append(metadata);
        this.sb.append("\n");
    }

    @Override
    public void startLeaf(LeafMetadata<?> metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("start FieldMetadata ").append(metadata).append(" = ");
        metadata.elements().stream().map(Element::getReadable).forEach(this.sb::append);
        this.sb.append("\n");
    }

    @Override
    public void startUnary(UnaryPredicateMetadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("start UnaryMetadata ").append(metadata).append(" = ").append(metadata.getOperator());
        this.sb.append("\n");
    }

    @Override
    public void startBinary(BinaryPredicateMetadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("start BinaryMetadata ").append(metadata).append(" = ").append("---");
        this.sb.append("\n");
    }

    @Override
    public void afterChildBinary(BinaryPredicateMetadata metadata, Metadata child, boolean hasNext, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("visit BinaryMetadata ").append(metadata).append(" = ").append(metadata.getOperator());
        this.sb.append("\n");
    }

    @Override
    public void endBinary(BinaryPredicateMetadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("end BinaryMetadata ").append(metadata).append(" = ").append("---");
        this.sb.append("\n");
    }

    @Override
    public void startNary(NaryPredicateMetadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("start NaryMetadata ").append(metadata).append(" = ").append(metadata.getOperator());
        this.sb.append("\n");
    }

    @Override
    public void afterChildNary(NaryPredicateMetadata metadata, Metadata child, boolean hasNext, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("visit NaryMetadata ").append(metadata).append(" = ").append("---");
        this.sb.append("\n");
    }

    @Override
    public void endNary(NaryPredicateMetadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("end NaryMetadata ").append(metadata).append(" = ").append("---");
        this.sb.append("\n");
    }

    @Override
    public void startRule(Metadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("start ValidationRule ").append(metadata).append(" = ").append("rule");
        this.sb.append("\n");
    }

    @Override
    public void endRule(Metadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("end ValidationRule ").append(metadata).append(" = ").append("validate");
        this.sb.append("\n");
    }

    @Override
    public void startWhen(Metadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("start StepWhen ").append(metadata).append(" = ").append("when");
        this.sb.append("\n");
    }

    @Override
    public void endWhen(Metadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("end StepWhen ").append(metadata).append(" = ").append("---");
        this.sb.append("\n");
    }

    @Override
    public void visitCondition(StepCondition metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("visit StepCondition ").append(metadata).append(" = ").append("---");
        this.sb.append("\n");
    }

    @Override
    protected int getIndentSize() {
        return 4;
    }
}

