/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.meta.Element;
import io.doov.core.dsl.meta.ElementType;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.MappingOperator;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;

public class MappingMetadata
extends LeafMetadata<MappingMetadata> {
    private MappingMetadata(MetadataType type) {
        super(type);
    }

    public static MappingMetadata mappings(MappingOperator operator) {
        return (MappingMetadata)new MappingMetadata(MetadataType.MULTIPLE_MAPPING).operator(operator);
    }

    public static MappingMetadata inputMetadata(String readable) {
        return (MappingMetadata)new MappingMetadata(MetadataType.MAPPING_LEAF).valueReadable(() -> readable);
    }

    public static MappingMetadata valueInput(Supplier<?> supplier) {
        return (MappingMetadata)new MappingMetadata(MetadataType.MAPPING_LEAF).valueSupplier(supplier);
    }

    public static MappingMetadata fieldsInput(List<DslField<?>> fields) {
        return new MappingMetadata(MetadataType.MAPPING_LEAF).fields(fields);
    }

    public static MappingMetadata functionInput() {
        return new MappingMetadata(MetadataType.MAPPING_LEAF).function();
    }

    public static MappingMetadata fieldInput(DslField<?> field) {
        return (MappingMetadata)new MappingMetadata(MetadataType.MAPPING_LEAF).field(field);
    }

    public static MappingMetadata metadataInput(Metadata ... metadata) {
        return new MappingMetadata(MetadataType.MAPPING_LEAF).mergeMetadata(metadata);
    }

    public static MappingMetadata outputMetadata(String readable) {
        return (MappingMetadata)new MappingMetadata(MetadataType.MAPPING_LEAF).valueReadable(() -> readable);
    }

    public static MappingMetadata fieldOutput(DslField<?> field) {
        return (MappingMetadata)new MappingMetadata(MetadataType.MAPPING_LEAF).field(field);
    }

    public static MappingMetadata functionOutput() {
        return new MappingMetadata(MetadataType.MAPPING_LEAF).function();
    }

    private MappingMetadata fields(List<DslField<?>> fields) {
        Iterator<DslField<?>> iterator = fields.iterator();
        while (iterator.hasNext()) {
            DslField<?> f = iterator.next();
            this.field(f);
            if (!iterator.hasNext()) continue;
            this.operator(MappingOperator.and);
        }
        return this;
    }

    private MappingMetadata mergeMetadata(Metadata ... metadata) {
        Iterator<Metadata> iterator = Arrays.asList(metadata).iterator();
        while (iterator.hasNext()) {
            MappingMetadata m = (MappingMetadata)iterator.next();
            m.elements().forEach(this::add);
            if (!iterator.hasNext()) continue;
            this.operator(MappingOperator.and);
        }
        return this;
    }

    private MappingMetadata function() {
        return (MappingMetadata)this.add(new Element(() -> "-function-", ElementType.UNKNOWN));
    }
}

