/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.lang.ValidationRule;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.Operator;
import io.doov.core.dsl.meta.ReturnType;
import io.doov.core.dsl.meta.ast.ExclusionBar;
import io.doov.core.dsl.meta.i18n.ResourceProvider;
import io.doov.core.dsl.meta.predicate.PredicateMetadata;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class HtmlWriter {
    static final String SPACE = "&nbsp;";
    static final String APOS = "&apos;";
    static final String BR = "<br>";
    static final String CSS_VALIDATION_RULE = "dsl-validation-rule";
    static final String CSS_VALIDATE = "dsl-token-validate";
    static final String CSS_NARY = "dsl-token-nary";
    static final String CSS_WHEN = "dsl-token-when";
    static final String CSS_OPERATOR = "dsl-token-operator";
    static final String CSS_VALUE = "dsl-token-value";
    static final String CSS_FIELD = "dsl-token-field";
    static final String CSS_UNKNOWN = "dsl-token-unknown";
    static final String CSS_LI_LEAF = "dsl-li-leaf";
    static final String CSS_LI_BINARY = "dsl-li-binary";
    static final String CSS_LI_UNARY = "dsl-li-unary";
    static final String CSS_LI_NARY = "dsl-li-nary";
    static final String CSS_UL_WHEN = "dsl-ul-when";
    static final String CSS_UL_BINARY = "dsl-ul-binary";
    static final String CSS_UL_UNARY = "dsl-ul-unary";
    static final String CSS_OL_NARY = "dsl-ol-nary";
    private final Locale locale;
    private final OutputStream os;
    private final ResourceProvider resources;
    private static final List<Operator> OP_BOOLEAN_PARAMS = Arrays.asList(DefaultOperator.and, DefaultOperator.or, DefaultOperator.match_all, DefaultOperator.match_any, DefaultOperator.match_none, DefaultOperator.count, DefaultOperator.when);
    private static final List<Operator> OP_BIG_BAR = Arrays.asList(DefaultOperator.match_all, DefaultOperator.match_any, DefaultOperator.match_none);

    public HtmlWriter(Locale locale, OutputStream os, ResourceProvider resources) {
        this.locale = locale;
        this.os = os;
        this.resources = resources;
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected void write(String value) {
        try {
            this.os.write(value.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeFromBundle(Operator operator) {
        this.write(this.resources.get(operator, this.locale));
    }

    protected void writeFromBundle(String key) {
        this.write(this.resources.get(key, this.locale));
    }

    protected void writeBeginLi(String ... classes) {
        this.write(HtmlWriter.beginLi(classes));
    }

    protected void writeEndLi() {
        this.write(HtmlWriter.endLi());
    }

    protected void writeBeginUl(String ... classes) {
        this.write(HtmlWriter.beginUl(classes));
    }

    protected void writeEndUl() {
        this.write(HtmlWriter.endUl());
    }

    protected void writeBeginOl(String ... classes) {
        this.write(HtmlWriter.beginOl(classes));
    }

    protected void writeEndOl() {
        this.write(HtmlWriter.endOl());
    }

    protected void writeBeginDiv(String ... classes) {
        this.write(HtmlWriter.beginDiv(classes));
    }

    protected void writeBeginSpan(String ... classes) {
        this.write(HtmlWriter.beginSpan(classes));
    }

    protected void writeBeginDivWithStyle(String style, String ... classes) {
        this.write(HtmlWriter.beginDivWithStyle(style, classes));
    }

    protected void writeEndDiv() {
        this.write(HtmlWriter.endDiv());
    }

    protected void writeEndSpan() {
        this.write(HtmlWriter.endSpan());
    }

    protected void writeExclusionBar(Metadata metadata, ArrayDeque<Metadata> parents) {
        Optional pmd = parents.stream().skip(1L).findFirst();
        if (metadata.getOperator().returnType() == ReturnType.BOOLEAN || pmd.map(m -> OP_BOOLEAN_PARAMS.contains(m.getOperator())).orElse(false).booleanValue()) {
            ExclusionBar barSize = pmd.map(m -> m.getOperator() == DefaultOperator.when || OP_BIG_BAR.contains(metadata.getOperator()) ? ExclusionBar.BIG : ExclusionBar.SMALL).orElse(ExclusionBar.SMALL);
            this.write(HtmlWriter.exclusionBar((PredicateMetadata)metadata, barSize, this.locale));
        }
    }

    static String beginElement(String elementType, String ... classes) {
        return "<" + elementType + (classes.length > 0 ? " class='" + String.join((CharSequence)" ", classes) + "'" : "") + ">";
    }

    static String beginElementWithStyle(String elementType, String style, String ... classes) {
        return "<" + elementType + (classes.length > 0 ? " class='" + String.join((CharSequence)" ", classes) + "'" : "") + (style != null ? " style='" + style + "'" : "") + ">";
    }

    static String endElement(String elementType) {
        return "</" + elementType + ">";
    }

    static String beginLi(String ... classes) {
        return HtmlWriter.beginElement("li", classes);
    }

    static String endLi() {
        return HtmlWriter.endElement("li");
    }

    static String beginUl(String ... classes) {
        return HtmlWriter.beginElement("ul", classes);
    }

    static String endUl() {
        return HtmlWriter.endElement("ul");
    }

    static String beginOl(String ... classes) {
        return HtmlWriter.beginElement("ol", classes);
    }

    static String endOl() {
        return HtmlWriter.endElement("ol");
    }

    static String beginDiv(String ... classes) {
        return HtmlWriter.beginElement("div", classes);
    }

    static String beginSpan(String ... classes) {
        return HtmlWriter.beginElement("span", classes);
    }

    static String beginDivWithStyle(String style, String ... classes) {
        return HtmlWriter.beginElementWithStyle("div", style, classes);
    }

    static String endDiv() {
        return HtmlWriter.endElement("div");
    }

    static String endSpan() {
        return HtmlWriter.endElement("span");
    }

    static String exclusionBar(PredicateMetadata metadata, ExclusionBar cssClass, Locale locale) {
        int nbTrue = metadata.trueEvalCount();
        int nbFalse = metadata.falseEvalCount();
        if (nbTrue == 0 && nbFalse == 0) {
            return HtmlWriter.formatExclusionBar(cssClass);
        }
        double percentage = Math.floor((double)nbTrue / ((double)nbTrue + (double)nbFalse) * 1000.0) / 10.0;
        return HtmlWriter.formatExclusionBar(cssClass, percentage, locale);
    }

    private static String formatExclusionBar(ExclusionBar cssClass) {
        return HtmlWriter.beginDiv(cssClass.getWrapperClass()) + HtmlWriter.beginDiv("percentage-value") + " n/a" + HtmlWriter.endDiv() + HtmlWriter.beginDiv(cssClass.getBorderClass()) + HtmlWriter.beginDivWithStyle("width:0%;", cssClass.getFillingClass()) + HtmlWriter.endDiv() + HtmlWriter.endDiv() + HtmlWriter.endDiv();
    }

    private static String formatExclusionBar(ExclusionBar cssClass, double percentage, Locale locale) {
        return HtmlWriter.beginDiv(cssClass.getWrapperClass()) + HtmlWriter.beginDiv("percentage-value") + NumberFormat.getInstance(locale).format(percentage) + " %" + HtmlWriter.endDiv() + HtmlWriter.beginDiv(cssClass.getBorderClass()) + HtmlWriter.beginDivWithStyle("width:" + percentage + "%;", cssClass.getFillingClass()) + HtmlWriter.endDiv() + HtmlWriter.endDiv() + HtmlWriter.endDiv();
    }

    public static String exclusionBar(ValidationRule rule, ExclusionBar cssClass, Locale locale) {
        Metadata conditionMetadata = rule.getStepWhen().stepCondition().metadata();
        if (conditionMetadata instanceof PredicateMetadata) {
            return HtmlWriter.exclusionBar((PredicateMetadata)conditionMetadata, cssClass, locale);
        }
        return "";
    }
}

