/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.Element;
import io.doov.core.dsl.meta.ElementType;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.Operator;
import io.doov.core.dsl.meta.ReturnType;
import io.doov.core.dsl.meta.ast.HtmlWriter;
import io.doov.core.dsl.meta.i18n.ResourceBundleProvider;
import io.doov.core.dsl.meta.i18n.ResourceProvider;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.text.StringEscapeUtils;

public class AstHtmlRenderer
extends HtmlWriter {
    private static final List<Operator> AND_OR = Arrays.asList(DefaultOperator.and, DefaultOperator.or);

    public static String toHtml(Metadata metadata, Locale locale) {
        ByteArrayOutputStream ops = new ByteArrayOutputStream();
        new AstHtmlRenderer(locale, ops, ResourceBundleProvider.BUNDLE).toHtml(metadata);
        return new String(ops.toByteArray(), StandardCharsets.UTF_8);
    }

    public AstHtmlRenderer(Locale locale, OutputStream os, ResourceProvider resources) {
        super(locale, os, resources);
    }

    public void toHtml(Metadata metadata) {
        this.toHtml(metadata, new ArrayDeque<Metadata>());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void toHtml(Metadata metadata, ArrayDeque<Metadata> parents) {
        parents.push(metadata);
        try {
            switch (metadata.type()) {
                case RULE: {
                    this.rule(metadata, parents);
                    return;
                }
                case WHEN: {
                    this.when(metadata, parents);
                    return;
                }
                case BINARY_PREDICATE: {
                    this.binary(metadata, parents);
                    return;
                }
                case LEAF_PREDICATE: 
                case FIELD_PREDICATE: 
                case LEAF_VALUE: {
                    this.leaf(metadata, parents);
                    return;
                }
                case UNARY_PREDICATE: {
                    this.unary(metadata, parents);
                    return;
                }
                case NARY_PREDICATE: {
                    this.nary(metadata, parents);
                    return;
                }
                case FIELD_PREDICATE_MATCH_ANY: {
                    this.fieldMatchAny(metadata, parents);
                    return;
                }
                default: {
                    throw new IllegalStateException(metadata.type().name());
                }
            }
        }
        finally {
            parents.pop();
        }
    }

    private void when(Metadata metadata, ArrayDeque<Metadata> parents) {
        this.writeBeginSpan("dsl-token-when");
        this.writeFromBundle(metadata.getOperator());
        this.writeEndSpan();
        this.writeBeginUl("dsl-ul-when");
        this.toHtml(metadata.childAt(0), parents);
        this.writeEndUl();
        this.writeBeginSpan("dsl-token-validate");
        this.writeFromBundle(DefaultOperator.validate);
        this.writeEndSpan();
    }

    private void fieldMatchAny(Metadata metadata, ArrayDeque<Metadata> parents) {
        this.writeBeginSpan("dsl-token-value");
        for (Element e : ((LeafMetadata)metadata).elements()) {
            this.writeFromBundle(StringEscapeUtils.escapeHtml4((String)e.getReadable().readable()));
        }
        this.writeEndSpan();
    }

    private void nary(Metadata metadata, ArrayDeque<Metadata> parents) {
        Optional pmd = parents.stream().skip(1L).findFirst();
        if (pmd.map(m -> m.getOperator().returnType() == ReturnType.BOOLEAN).orElse(false).booleanValue()) {
            this.writeExclusionBar(metadata, parents);
            this.writeBeginSpan("dsl-token-nary");
            this.writeFromBundle(metadata.getOperator());
            this.writeEndSpan();
            this.writeBeginOl("dsl-ol-nary");
            metadata.children().forEach(m -> this.toHtml((Metadata)m, parents));
            this.writeEndOl();
        } else {
            this.writeBeginLi("dsl-li-nary");
            this.writeExclusionBar(metadata, parents);
            this.writeBeginSpan("dsl-token-nary");
            this.writeFromBundle(metadata.getOperator());
            this.writeEndSpan();
            this.writeBeginOl("dsl-ol-nary");
            metadata.children().forEach(m -> this.toHtml((Metadata)m, parents));
            this.writeEndOl();
            this.writeEndLi();
        }
    }

    private void rule(Metadata metadata, ArrayDeque<Metadata> parents) {
        this.writeBeginDiv("dsl-validation-rule");
        metadata.children().forEach(m -> this.toHtml((Metadata)m, parents));
        this.writeEndDiv();
    }

    private void binary(Metadata metadata, ArrayDeque<Metadata> parents) {
        Optional pmd = parents.stream().skip(1L).findFirst();
        MetadataType pmdType = pmd.map(Metadata::type).orElse(null);
        Operator pmdOperator = pmd.map(Metadata::getOperator).orElse(null);
        boolean leftChild = pmd.map(m -> m.childAt(0) == metadata).orElse(false);
        if (!AND_OR.contains(pmdOperator) && metadata.getOperator() == DefaultOperator.and) {
            this.writeBeginLi("dsl-li-binary");
            this.binary_BR(metadata, parents);
            this.writeEndLi();
        } else if (pmdOperator == DefaultOperator.and && metadata.getOperator() == DefaultOperator.and) {
            this.binary_BR(metadata, parents);
        } else if (!AND_OR.contains(pmdOperator) && metadata.getOperator() == DefaultOperator.or) {
            this.writeBeginLi("dsl-li-binary");
            this.binary_BR(metadata, parents);
            this.writeEndLi();
        } else if (pmdOperator == DefaultOperator.or && metadata.getOperator() == DefaultOperator.or) {
            this.binary_BR(metadata, parents);
        } else if (pmdOperator == DefaultOperator.or && metadata.getOperator() == DefaultOperator.and && leftChild) {
            this.binary_SPACE(metadata, parents);
        } else if (pmdOperator == DefaultOperator.and && metadata.getOperator() == DefaultOperator.or && leftChild) {
            this.binary_BR(metadata, parents);
        } else if (pmdType == MetadataType.BINARY_PREDICATE && AND_OR.contains(metadata.getOperator())) {
            this.writeBeginUl("dsl-ul-binary");
            this.writeBeginLi("dsl-li-binary");
            this.binary_BR(metadata, parents);
            this.writeEndLi();
            this.writeEndUl();
        } else if (pmdType == MetadataType.BINARY_PREDICATE && !AND_OR.contains(metadata.getOperator())) {
            this.binary_SPACE(metadata, parents);
        } else if (pmdType == MetadataType.NARY_PREDICATE && AND_OR.contains(metadata.getOperator())) {
            this.writeBeginLi("dsl-li-binary");
            this.binary_BR(metadata, parents);
            this.writeEndLi();
        } else if (pmdType == MetadataType.NARY_PREDICATE && !AND_OR.contains(metadata.getOperator())) {
            this.writeBeginLi("dsl-li-binary");
            this.binary_SPACE(metadata, parents);
            this.writeEndLi();
        } else if (pmdType == MetadataType.UNARY_PREDICATE) {
            this.writeBeginUl("dsl-ul-unary");
            this.binary_SPACE(metadata, parents);
            this.writeEndUl();
        } else if (AND_OR.contains(metadata.getOperator())) {
            this.writeBeginLi("dsl-li-binary");
            this.binary_BR(metadata, parents);
            this.writeEndLi();
        } else {
            this.binary_SPACE(metadata, parents);
        }
    }

    private void binary_BR(Metadata metadata, ArrayDeque<Metadata> parents) {
        this.toHtml(metadata.childAt(0), parents);
        this.write("<br>");
        this.writeBeginSpan("dsl-token-operator");
        this.writeFromBundle(metadata.getOperator());
        this.writeEndSpan();
        this.write("&nbsp;");
        this.toHtml(metadata.childAt(1), parents);
    }

    private void binary_SPACE(Metadata metadata, ArrayDeque<Metadata> parents) {
        Optional pmd = parents.stream().skip(1L).findFirst();
        Operator pmdOperator = pmd.map(Metadata::getOperator).orElse(null);
        boolean leftChild = pmd.map(m -> m.childAt(0) == metadata).orElse(false);
        if (!leftChild || pmdOperator != DefaultOperator.or || metadata.getOperator() != DefaultOperator.and) {
            this.writeExclusionBar(metadata, parents);
        }
        this.toHtml(metadata.childAt(0), parents);
        this.write("&nbsp;");
        this.writeBeginSpan("dsl-token-operator");
        this.writeFromBundle(metadata.getOperator());
        this.writeEndSpan();
        this.write("&nbsp;");
        this.toHtml(metadata.childAt(1), parents);
    }

    private void unary(Metadata metadata, ArrayDeque<Metadata> parents) {
        Optional pmd = parents.stream().skip(1L).findFirst();
        Operator pmdOperator = pmd.map(Metadata::getOperator).orElse(null);
        if (AND_OR.contains(pmdOperator) && metadata.getOperator() == DefaultOperator.not) {
            this.writeExclusionBar(metadata, parents);
            this.prefixUnary(metadata, parents);
        } else if (!AND_OR.contains(pmdOperator) && metadata.getOperator() == DefaultOperator.not) {
            this.writeBeginLi("dsl-li-unary");
            this.prefixUnary(metadata, parents);
            this.writeEndLi();
        } else if (pmd.map(m -> m.type() == MetadataType.NARY_PREDICATE).orElse(false).booleanValue()) {
            this.writeBeginLi("dsl-li-leaf");
            this.writeExclusionBar(metadata, parents);
            this.postfixUnary(metadata, parents);
            this.writeEndLi();
        } else {
            this.writeExclusionBar(metadata, parents);
            this.postfixUnary(metadata, parents);
        }
    }

    private void prefixUnary(Metadata metadata, ArrayDeque<Metadata> parents) {
        this.writeBeginSpan("dsl-token-operator");
        this.writeFromBundle(metadata.getOperator());
        this.writeEndSpan();
        this.write("&nbsp;");
        this.toHtml(metadata.childAt(0), parents);
    }

    private void postfixUnary(Metadata metadata, ArrayDeque<Metadata> parents) {
        this.toHtml(metadata.childAt(0), parents);
        this.write("&nbsp;");
        this.writeBeginSpan("dsl-token-operator");
        this.writeFromBundle(metadata.getOperator());
        this.writeEndSpan();
    }

    private void leaf(Metadata metadata, ArrayDeque<Metadata> parents) {
        this.writeExclusionBar(metadata, parents);
        Optional pmd = parents.stream().skip(1L).findFirst();
        if (pmd.map(m -> m.type() == MetadataType.NARY_PREDICATE).orElse(false).booleanValue()) {
            this.writeBeginLi("dsl-li-leaf");
        }
        ArrayList<Element> elts = new ArrayList<Element>(((LeafMetadata)metadata).elements());
        for (Element e : elts) {
            this.writeBeginSpan(AstHtmlRenderer.spanClass(e.getType()));
            switch (e.getType()) {
                case OPERATOR: {
                    this.writeFromBundle((Operator)e.getReadable());
                    break;
                }
                case TEMPORAL_UNIT: {
                    this.writeFromBundle(e.getReadable().readable());
                    break;
                }
                case FIELD: {
                    this.handleField((DslField)e.getReadable());
                    break;
                }
                case STRING_VALUE: {
                    this.write("&apos;");
                    this.write(StringEscapeUtils.escapeHtml4((String)e.getReadable().readable()));
                    this.write("&apos;");
                    break;
                }
                default: {
                    this.writeFromBundle(StringEscapeUtils.escapeHtml4((String)e.getReadable().readable()));
                }
            }
            this.writeEndSpan();
            if (elts.indexOf(e) == elts.size() - 1) continue;
            this.write("&nbsp;");
        }
        if (pmd.map(m -> m.type() == MetadataType.NARY_PREDICATE).orElse(false).booleanValue()) {
            this.writeEndLi();
        }
    }

    protected void handleField(DslField<?> field) {
        this.writeFromBundle(StringEscapeUtils.escapeHtml4((String)field.readable()));
    }

    private static String spanClass(ElementType type) {
        switch (type) {
            case OPERATOR: 
            case TEMPORAL_UNIT: {
                return "dsl-token-operator";
            }
            case STRING_VALUE: 
            case VALUE: {
                return "dsl-token-value";
            }
            case FIELD: {
                return "dsl-token-field";
            }
            case UNKNOWN: {
                return "dsl-token-unknown";
            }
        }
        throw new IllegalStateException(type.name());
    }
}

