/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.field;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.impl.DefaultCondition;
import io.doov.core.dsl.impl.StringFunction;
import io.doov.core.dsl.impl.num.IntegerFunction;
import io.doov.core.dsl.lang.StepCondition;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface BaseFieldInfo<T>
extends DslField<T> {
    default public StepCondition isNull() {
        return this.getDefaultFunction().isNull();
    }

    default public StepCondition isNotNull() {
        return this.getDefaultFunction().isNotNull();
    }

    default public StepCondition eq(T value) {
        return this.getDefaultFunction().eq(value);
    }

    default public StepCondition eq(BaseFieldInfo<T> value) {
        return this.getDefaultFunction().eq(value);
    }

    default public StepCondition eq(Supplier<T> supplier) {
        return this.getDefaultFunction().eq(supplier);
    }

    default public StepCondition notEq(T value) {
        return this.getDefaultFunction().notEq(value);
    }

    default public StepCondition notEq(BaseFieldInfo<T> value) {
        return this.getDefaultFunction().notEq(value);
    }

    default public StepCondition notEq(Supplier<T> supplier) {
        return this.getDefaultFunction().notEq(supplier);
    }

    default public StepCondition anyMatch(Predicate<T> value) {
        return this.getDefaultFunction().anyMatch(Collections.singletonList(value));
    }

    default public StepCondition anyMatch(T ... values) {
        return this.getDefaultFunction().anyMatch((Collection<T>)Arrays.asList(values));
    }

    default public StepCondition anyMatch(Collection<T> values) {
        return this.getDefaultFunction().anyMatch(values);
    }

    default public StepCondition allMatch(Predicate<T> value) {
        return this.getDefaultFunction().allMatch(Collections.singletonList(value));
    }

    default public StepCondition allMatch(T ... values) {
        return this.getDefaultFunction().allMatch((Collection<T>)Arrays.asList(values));
    }

    default public StepCondition allMatch(Collection<T> values) {
        return this.getDefaultFunction().allMatch(values);
    }

    default public StepCondition noneMatch(Predicate<T> value) {
        return this.getDefaultFunction().noneMatch(Collections.singletonList(value));
    }

    default public StepCondition noneMatch(T ... values) {
        return this.getDefaultFunction().noneMatch((Collection<T>)Arrays.asList(values));
    }

    default public StepCondition noneMatch(Collection<T> values) {
        return this.getDefaultFunction().noneMatch(values);
    }

    default public IntegerFunction mapToInt(Function<T, Integer> mapper) {
        return this.getDefaultFunction().mapToInt(mapper);
    }

    default public StringFunction mapToString(Function<T, String> mapper) {
        return this.getDefaultFunction().mapToString(mapper);
    }

    default public <R> DefaultCondition<R> map(String readable, Function<T, R> mapper) {
        return this.getDefaultFunction().map(readable, mapper);
    }

    default public <U, R> DefaultCondition<R> mapUsing(String readable, DslField<U> condition, BiFunction<T, U, R> mapper) {
        return this.getDefaultFunction().mapUsing(readable, condition.getDefaultFunction(), mapper);
    }
}

