/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.predicate;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.impl.DefaultCondition;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.Readable;
import io.doov.core.dsl.lang.ReduceType;
import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.Element;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.predicate.PredicateMetadata;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class LeafPredicateMetadata<M extends LeafPredicateMetadata<M>>
extends LeafMetadata<M>
implements PredicateMetadata {
    private final AtomicInteger evalTrue = new AtomicInteger();
    private final AtomicInteger evalFalse = new AtomicInteger();

    private LeafPredicateMetadata(Deque<Element> elements, MetadataType type) {
        super(elements, type);
    }

    public LeafPredicateMetadata(MetadataType type) {
        this(new ArrayDeque<Element>(), type);
    }

    public LeafPredicateMetadata(Metadata metadata) {
        this(new ArrayDeque<Element>(metadata.flatten()), metadata.type());
    }

    public LeafPredicateMetadata(Metadata metadata, MetadataType type) {
        this(new ArrayDeque<Element>(metadata.flatten()), type);
    }

    @Override
    public AtomicInteger evalTrue() {
        return this.evalTrue;
    }

    @Override
    public AtomicInteger evalFalse() {
        return this.evalFalse;
    }

    @Override
    public LeafPredicateMetadata<M> merge(LeafMetadata<?> other) {
        LeafPredicateMetadata.removeDuplicate(this.elements(), other.elements());
        ArrayDeque<Element> merge = new ArrayDeque<Element>(this.elements());
        merge.addAll(other.elements());
        return new LeafPredicateMetadata<M>(merge, LeafPredicateMetadata.mergeType(this.type(), other.type()));
    }

    private static MetadataType mergeType(MetadataType current, MetadataType merged) {
        if (current == MetadataType.FIELD_PREDICATE && merged == MetadataType.FIELD_PREDICATE_MATCH_ANY) {
            return MetadataType.FIELD_PREDICATE_MATCH_ANY;
        }
        return current;
    }

    private static void removeDuplicate(Deque<Element> current, Deque<Element> merged) {
        if (current.isEmpty() || merged.isEmpty()) {
            return;
        }
        for (Element element : current) {
            if (merged.isEmpty()) break;
            if (merged.peek().getType() != element.getType() || !merged.peek().getReadable().readable().equals(element.getReadable().readable())) continue;
            merged.pop();
        }
    }

    @Override
    public Metadata reduce(Context context, ReduceType type) {
        if (this.type() == MetadataType.FIELD_PREDICATE_MATCH_ANY) {
            DslField field = (DslField)this.elements().getFirst().getReadable();
            return ((LeafPredicateMetadata)((LeafPredicateMetadata)new LeafPredicateMetadata<M>(MetadataType.FIELD_PREDICATE).field(field)).operator(DefaultOperator.equals)).valueObject(context.getEvalValue(field.id()));
        }
        return this;
    }

    public static <M extends LeafPredicateMetadata<M>> M fieldMetadata(DslField<?> field) {
        return (M)((LeafPredicateMetadata)new LeafPredicateMetadata<M>(MetadataType.FIELD_PREDICATE).field(field));
    }

    public static <M extends LeafPredicateMetadata<M>> M trueMetadata() {
        return (M)((LeafPredicateMetadata)new LeafPredicateMetadata<M>(MetadataType.LEAF_PREDICATE).operator(DefaultOperator.always_true));
    }

    public static <M extends LeafPredicateMetadata<M>> M falseMetadata() {
        return (M)((LeafPredicateMetadata)new LeafPredicateMetadata<M>(MetadataType.LEAF_PREDICATE).operator(DefaultOperator.always_false));
    }

    public static <M extends LeafPredicateMetadata<M>> M whenMetadata(Metadata metadata, StepCondition condition) {
        LeafPredicateMetadata exp = (LeafPredicateMetadata)new LeafPredicateMetadata<M>(metadata, MetadataType.FIELD_PREDICATE).operator(DefaultOperator.when);
        exp.elements().add(Element.leftParenthesis());
        exp.elements().addAll(condition.metadata().flatten());
        exp.elements().add(Element.rightParenthesis());
        return (M)exp;
    }

    public static <M extends LeafPredicateMetadata<M>> M equalsMetadata(Metadata metadata, Object value) {
        return (M)((LeafPredicateMetadata)((LeafPredicateMetadata)new LeafPredicateMetadata<M>(metadata, MetadataType.FIELD_PREDICATE).operator(DefaultOperator.equals)).valueObject(value));
    }

    public static <M extends LeafPredicateMetadata<M>> M equalsMetadata(Metadata metadata, Supplier<?> value) {
        return (M)((LeafPredicateMetadata)((LeafPredicateMetadata)new LeafPredicateMetadata<M>(metadata, MetadataType.FIELD_PREDICATE).operator(DefaultOperator.equals)).valueUnknown("-function-"));
    }

    public static <M extends LeafPredicateMetadata<M>> M equalsMetadata(Metadata metadata, Readable value) {
        return (M)((LeafPredicateMetadata)((LeafPredicateMetadata)new LeafPredicateMetadata<M>(metadata, MetadataType.FIELD_PREDICATE).operator(DefaultOperator.equals)).valueReadable(value));
    }

    public static <M extends LeafPredicateMetadata<M>> M equalsMetadata(Metadata metadata, DefaultCondition<?> condition) {
        return (M)((LeafPredicateMetadata)((LeafPredicateMetadata)new LeafPredicateMetadata<M>(metadata, MetadataType.FIELD_PREDICATE).operator(DefaultOperator.equals)).valueCondition(condition));
    }

    public static <M extends LeafPredicateMetadata<M>> M notEqualsMetadata(Metadata metadata, Object value) {
        return (M)((LeafPredicateMetadata)((LeafPredicateMetadata)new LeafPredicateMetadata<M>(metadata, MetadataType.FIELD_PREDICATE).operator(DefaultOperator.not_equals)).valueObject(value));
    }

    public static <M extends LeafPredicateMetadata<M>> M notEqualsMetadata(Metadata metadata, Supplier<?> value) {
        return (M)((LeafPredicateMetadata)((LeafPredicateMetadata)new LeafPredicateMetadata<M>(metadata, MetadataType.FIELD_PREDICATE).operator(DefaultOperator.not_equals)).valueUnknown("-function-"));
    }

    public static <M extends LeafPredicateMetadata<M>> M notEqualsMetadata(Metadata metadata, Readable value) {
        return (M)((LeafPredicateMetadata)((LeafPredicateMetadata)new LeafPredicateMetadata<M>(metadata, MetadataType.FIELD_PREDICATE).operator(DefaultOperator.not_equals)).valueReadable(value));
    }

    public static <M extends LeafPredicateMetadata<M>> M nullMetadata(Metadata metadata) {
        return (M)((LeafPredicateMetadata)new LeafPredicateMetadata<M>(metadata, MetadataType.FIELD_PREDICATE).operator(DefaultOperator.is_null));
    }

    public static <M extends LeafPredicateMetadata<M>> M notNullMetadata(Metadata metadata) {
        return (M)((LeafPredicateMetadata)new LeafPredicateMetadata<M>(metadata, MetadataType.FIELD_PREDICATE).operator(DefaultOperator.is_not_null));
    }

    public static <M extends LeafPredicateMetadata<M>> M matchAnyMetadata(Metadata metadata) {
        return (M)((LeafPredicateMetadata)((LeafPredicateMetadata)new LeafPredicateMetadata<M>(metadata, MetadataType.FIELD_PREDICATE_MATCH_ANY).operator(DefaultOperator.match_any)).valueUnknown("-function-"));
    }

    public static <M extends LeafPredicateMetadata<M>> M matchAnyMetadata(Metadata metadata, Collection<?> values) {
        return (M)((LeafPredicateMetadata)((LeafPredicateMetadata)new LeafPredicateMetadata<M>(metadata, MetadataType.FIELD_PREDICATE_MATCH_ANY).operator(DefaultOperator.match_any)).valueListObject(values));
    }

    public static <M extends LeafPredicateMetadata<M>> M matchAllMetadata(Metadata metadata) {
        return (M)((LeafPredicateMetadata)((LeafPredicateMetadata)new LeafPredicateMetadata<M>(metadata, MetadataType.FIELD_PREDICATE).operator(DefaultOperator.match_all)).valueUnknown("-function-"));
    }

    public static <M extends LeafPredicateMetadata<M>> M matchAllMetadata(Metadata metadata, Collection<?> values) {
        return (M)((LeafPredicateMetadata)((LeafPredicateMetadata)new LeafPredicateMetadata<M>(metadata, MetadataType.FIELD_PREDICATE).operator(DefaultOperator.match_all)).valueListObject(values));
    }

    public static <M extends LeafPredicateMetadata<M>> M matchNoneMetadata(Metadata metadata) {
        return (M)((LeafPredicateMetadata)((LeafPredicateMetadata)new LeafPredicateMetadata<M>(metadata, MetadataType.FIELD_PREDICATE).operator(DefaultOperator.match_none)).valueUnknown("-function-"));
    }

    public static <M extends LeafPredicateMetadata<M>> M matchNoneMetadata(Metadata metadata, Collection<?> values) {
        return (M)((LeafPredicateMetadata)((LeafPredicateMetadata)new LeafPredicateMetadata<M>(metadata, MetadataType.FIELD_PREDICATE).operator(DefaultOperator.match_none)).valueListObject(values));
    }
}

