/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.predicate;

import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.ReduceType;
import io.doov.core.dsl.meta.BinaryMetadata;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.EmptyMetadata;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.Operator;
import io.doov.core.dsl.meta.predicate.NaryPredicateMetadata;
import io.doov.core.dsl.meta.predicate.PredicateMetadata;
import java.util.concurrent.atomic.AtomicInteger;

public class BinaryPredicateMetadata
extends BinaryMetadata
implements PredicateMetadata {
    private final AtomicInteger evalTrue = new AtomicInteger();
    private final AtomicInteger evalFalse = new AtomicInteger();

    BinaryPredicateMetadata(Metadata left, Operator operator, Metadata right) {
        super(left, operator, right);
    }

    @Override
    public AtomicInteger evalTrue() {
        return this.evalTrue;
    }

    @Override
    public AtomicInteger evalFalse() {
        return this.evalFalse;
    }

    public static BinaryPredicateMetadata andMetadata(Metadata left, Metadata right) {
        return new BinaryPredicateMetadata(left, DefaultOperator.and, right);
    }

    public static BinaryPredicateMetadata orMetadata(Metadata left, Metadata right) {
        return new BinaryPredicateMetadata(left, DefaultOperator.or, right);
    }

    @Override
    public Metadata reduce(Context context, ReduceType type) {
        boolean right;
        boolean result;
        boolean bl = result = context.isEvalTrue(this) || !context.isEvalFalse(this);
        if (!result && type == ReduceType.SUCCESS) {
            return new EmptyMetadata();
        }
        if (result && type == ReduceType.FAILURE) {
            return new EmptyMetadata();
        }
        boolean left = context.isEvalTrue(this.getLeft()) || !context.isEvalFalse(this.getLeft());
        boolean bl2 = right = context.isEvalTrue(this.getRight()) || !context.isEvalFalse(this.getRight());
        if (this.getOperator() == DefaultOperator.and) {
            if (!right && left) {
                return this.getRight().reduce(context, type);
            }
            if (!left && right) {
                return this.getLeft().reduce(context, type);
            }
        } else if (this.getOperator() == DefaultOperator.or) {
            if (!right && left) {
                return this.getLeft().reduce(context, type);
            }
            if (!left && right) {
                return this.getRight().reduce(context, type);
            }
        } else if (this.getLeft().type() == MetadataType.NARY_PREDICATE && ((NaryPredicateMetadata)this.getLeft()).getOperator() == DefaultOperator.count) {
            return this.getLeft().reduce(context, type);
        }
        return new BinaryPredicateMetadata(this.getLeft().reduce(context, type), this.getOperator(), this.getRight().reduce(context, type));
    }
}

