/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.WhenMetadata;
import io.doov.core.dsl.meta.ast.AstLineVisitor;
import io.doov.core.dsl.meta.i18n.ResourceProvider;
import io.doov.core.dsl.meta.predicate.BinaryPredicateMetadata;
import io.doov.core.dsl.meta.predicate.LeafPredicateMetadata;
import io.doov.core.dsl.meta.predicate.NaryPredicateMetadata;
import io.doov.core.dsl.meta.predicate.PredicateMetadata;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.stream.Collectors;

public class AstLinePercentVisitor
extends AstLineVisitor {
    private static final NumberFormat formatter = new DecimalFormat("###.#");

    public AstLinePercentVisitor(StringBuilder stringBuilder, ResourceProvider bundle, Locale locale) {
        super(stringBuilder, bundle, locale);
    }

    @Override
    public void startWhen(WhenMetadata metadata, int depth) {
        this.sb.append(this.percentage(metadata.children().findFirst().orElse(null)) + " ");
        super.startWhen(metadata, depth);
    }

    @Override
    public void startBinary(BinaryPredicateMetadata metadata, int depth) {
        super.startBinary(metadata, depth);
        if (((Metadata)metadata.children().collect(Collectors.toList()).get(0)).type() == MetadataType.NARY_PREDICATE) {
            this.sb.append(this.percentage(metadata));
        }
    }

    @Override
    public void startNary(NaryPredicateMetadata metadata, int depth) {
        if (metadata.getOperator() != DefaultOperator.count && metadata.getOperator() != DefaultOperator.sum) {
            this.sb.append(this.percentage(metadata));
        }
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
        this.sb.append(this.formatNewLine());
        this.sb.append("[");
    }

    @Override
    protected String formatLeafMetadata(LeafPredicateMetadata<?> metadata) {
        if (this.stackPeek() == MetadataType.BINARY_PREDICATE) {
            return super.formatLeafMetadata(metadata);
        }
        return this.percentage(metadata) + super.formatLeafMetadata(metadata);
    }

    private String percentage(PredicateMetadata metadata) {
        int t = metadata.trueEvalCount();
        int f = metadata.falseEvalCount();
        if (f == 0 && t == 0) {
            return "[n/a]";
        }
        return "[" + formatter.format((double)t / ((double)t + (double)f) * 100.0) + "]";
    }
}

