/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.lang.ValidationRule;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.Element;
import io.doov.core.dsl.meta.ElementType;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.Operator;
import io.doov.core.dsl.meta.RuleMetadata;
import io.doov.core.dsl.meta.WhenMetadata;
import io.doov.core.dsl.meta.ast.AbstractAstVisitor;
import io.doov.core.dsl.meta.ast.ExclusionBar;
import io.doov.core.dsl.meta.i18n.ResourceBundleProvider;
import io.doov.core.dsl.meta.i18n.ResourceProvider;
import io.doov.core.dsl.meta.predicate.BinaryPredicateMetadata;
import io.doov.core.dsl.meta.predicate.LeafPredicateMetadata;
import io.doov.core.dsl.meta.predicate.NaryPredicateMetadata;
import io.doov.core.dsl.meta.predicate.PredicateMetadata;
import io.doov.core.dsl.meta.predicate.UnaryPredicateMetadata;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;

public class AstHtmlVisitor
extends AbstractAstVisitor {
    protected static final String CSS_CLASS_VALIDATION_RULE = "dsl-validation-rule";
    protected static final String CSS_CLASS_VALIDATE = "dsl-token-validate";
    protected static final String CSS_CLASS_BINARY = "dsl-token-binary";
    protected static final String CSS_CLASS_UNARY = "dsl-token-unary";
    protected static final String CSS_CLASS_NARY = "dsl-token-nary";
    protected static final String CSS_CLASS_WHEN = "dsl-token-when";
    protected static final String CSS_CLASS_LI_LEAF = "dsl-li-leaf";
    protected static final String CSS_CLASS_LI_BINARY = "dsl-li-binary";
    protected static final String CSS_CLASS_LI_UNARY = "dsl-li-unary";
    protected static final String CSS_CLASS_LI_NARY = "dsl-li-nary";
    protected static final String CSS_CLASS_UL_WHEN = "dsl-ul-when";
    protected static final String CSS_CLASS_UL_BINARY = "dsl-ul-binary";
    protected static final String CSS_CLASS_UL_BINARY_CHILD = "dsl-ul-binary-child";
    protected static final String CSS_CLASS_UL_UNARY = "dsl-ul-unary";
    protected static final String CSS_CLASS_OL_NARY = "dsl-ol-nary";
    protected final OutputStream ops;
    protected final ResourceProvider bundle;
    protected Locale locale;
    protected boolean closeSum = false;
    protected int closeUnaryUL = 0;
    protected int insideNary = 0;
    protected int nbImbriBinary = 0;
    protected boolean rightSideOfBinary = false;
    private boolean closeUn = false;
    private boolean insideSum = false;
    private boolean noExclusionNextLeaf = false;

    public static String astToHtml(Metadata metadata, Locale locale) {
        ByteArrayOutputStream ops = new ByteArrayOutputStream();
        new AstHtmlVisitor(ops, ResourceBundleProvider.BUNDLE, locale).browse(metadata, 0);
        return new String(ops.toByteArray(), StandardCharsets.UTF_8);
    }

    private static String beginElement(String elementType, String ... classes) {
        return "<" + elementType + (classes.length > 0 ? " class='" + String.join((CharSequence)" ", classes) + "'" : "") + ">";
    }

    private static String beginElementWithStyle(String elementType, String style, String ... classes) {
        return "<" + elementType + (classes.length > 0 ? " class='" + String.join((CharSequence)" ", classes) + "'" : "") + (style != null ? " style='" + style + "'" : "") + ">";
    }

    private static String endElement(String elementType) {
        return "</" + elementType + ">";
    }

    private static String beginLi(String ... classes) {
        return AstHtmlVisitor.beginElement("li", classes);
    }

    private static String endLi() {
        return AstHtmlVisitor.endElement("li");
    }

    private static String beginUl(String ... classes) {
        return AstHtmlVisitor.beginElement("ul", classes);
    }

    private static String endUl() {
        return AstHtmlVisitor.endElement("ul");
    }

    private static String beginOl(String ... classes) {
        return AstHtmlVisitor.beginElement("ol", classes);
    }

    private static String endOl() {
        return AstHtmlVisitor.endElement("ol");
    }

    private static String beginDiv(String ... classes) {
        return AstHtmlVisitor.beginElement("div", classes);
    }

    private static String beginDivWithStyle(String style, String ... classes) {
        return AstHtmlVisitor.beginElementWithStyle("div", style, classes);
    }

    private static String endDiv() {
        return AstHtmlVisitor.endElement("div");
    }

    private String exclusionBar(PredicateMetadata metadata, ExclusionBar cssClass) {
        int nbTrue = metadata.trueEvalCount();
        int nbFalse = metadata.falseEvalCount();
        if (nbTrue == 0 && nbFalse == 0) {
            return this.formatExclusionBar(cssClass);
        }
        double percentage = Math.floor((double)nbTrue / ((double)nbTrue + (double)nbFalse) * 1000.0) / 10.0;
        return this.formatExclusionBar(cssClass, percentage);
    }

    private String formatExclusionBar(ExclusionBar cssClass) {
        return AstHtmlVisitor.beginDiv(cssClass.getWrapperClass()) + AstHtmlVisitor.beginDiv("percentage-value") + " n/a" + AstHtmlVisitor.endDiv() + AstHtmlVisitor.beginDiv(cssClass.getBorderClass()) + AstHtmlVisitor.beginDivWithStyle("width:0%;", cssClass.getFillingClass()) + AstHtmlVisitor.endDiv() + AstHtmlVisitor.endDiv() + AstHtmlVisitor.endDiv();
    }

    private String formatExclusionBar(ExclusionBar cssClass, double percentage) {
        return AstHtmlVisitor.beginDiv(cssClass.getWrapperClass()) + AstHtmlVisitor.beginDiv("percentage-value") + NumberFormat.getInstance(this.locale).format(percentage) + " %" + AstHtmlVisitor.endDiv() + AstHtmlVisitor.beginDiv(cssClass.getBorderClass()) + AstHtmlVisitor.beginDivWithStyle("width:" + percentage + "%;", cssClass.getFillingClass()) + AstHtmlVisitor.endDiv() + AstHtmlVisitor.endDiv() + AstHtmlVisitor.endDiv();
    }

    public String exclusionBar(ValidationRule rule, ExclusionBar cssClass) {
        Metadata conditionMetadata = rule.getStepWhen().stepCondition().metadata();
        if (conditionMetadata instanceof PredicateMetadata) {
            return this.exclusionBar((PredicateMetadata)conditionMetadata, cssClass);
        }
        return "";
    }

    public AstHtmlVisitor(OutputStream ops, ResourceProvider bundle, Locale locale) {
        this.ops = ops;
        this.bundle = bundle;
        this.locale = locale;
    }

    @Override
    public void startWhen(WhenMetadata metadata, int depth) {
        this.htmlFormatSpan(CSS_CLASS_WHEN, this.formatWhen());
        this.write(AstHtmlVisitor.beginUl(CSS_CLASS_UL_WHEN));
    }

    @Override
    public void endWhen(WhenMetadata metadata, int depth) {
        this.write(AstHtmlVisitor.endUl());
    }

    @Override
    public void startLeaf(LeafPredicateMetadata<?> leaf, int depth) {
        if (this.stackPeek() == MetadataType.WHEN || this.insideNary > 0 && this.stackPeek() != MetadataType.BINARY_PREDICATE) {
            this.write(AstHtmlVisitor.beginLi(CSS_CLASS_LI_LEAF));
        }
        if (!this.insideSum) {
            if (this.noExclusionNextLeaf) {
                this.noExclusionNextLeaf = false;
            } else {
                this.write(this.exclusionBar(leaf, ExclusionBar.SMALL));
            }
        }
        leaf.elements().stream().forEach(e -> {
            switch (e.getType()) {
                case PARENTHESIS_LEFT: 
                case PARENTHESIS_RIGHT: {
                    this.formatParenthesis((Element)e);
                    break;
                }
                case OPERATOR: {
                    this.formatLeafOperator((Element)e);
                    break;
                }
                case TEMPORAL_UNIT: {
                    this.formatTemporalUnit((Element)e);
                    break;
                }
                case FIELD: {
                    this.formatLeafField((Element)e);
                    break;
                }
                case VALUE: 
                case STRING_VALUE: {
                    this.formatLeafValue((Element)e);
                    break;
                }
                case UNKNOWN: {
                    this.formatLeafUnknown((Element)e);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown element type " + (Object)((Object)e.getType()));
                }
            }
        });
    }

    @Override
    public void endLeaf(LeafPredicateMetadata<?> metadata, int depth) {
        if (this.stackPeek() == MetadataType.WHEN || this.insideNary > 0 && !this.isImmediateBinaryChild()) {
            this.write(AstHtmlVisitor.endLi());
        }
    }

    @Override
    public void startBinary(BinaryPredicateMetadata metadata, int depth) {
        Metadata leftChild = metadata.getLeft();
        if (MetadataType.NARY_PREDICATE == this.stackPeek() && metadata.getOperator() != DefaultOperator.or && metadata.getOperator() != DefaultOperator.and) {
            this.write(AstHtmlVisitor.beginLi(CSS_CLASS_LI_BINARY));
            this.closeSum = true;
        }
        if (this.rightSideOfBinary && leftChild.type() != MetadataType.NARY_PREDICATE) {
            this.write(AstHtmlVisitor.beginUl(CSS_CLASS_UL_BINARY));
            ++this.nbImbriBinary;
            this.rightSideOfBinary = false;
        }
        if (leftChild.type() != MetadataType.BINARY_PREDICATE && leftChild.type() != MetadataType.NARY_PREDICATE) {
            this.write(AstHtmlVisitor.beginLi(CSS_CLASS_LI_BINARY));
        }
        if (metadata.getOperator() != DefaultOperator.and && metadata.getOperator() != DefaultOperator.or) {
            this.write(this.exclusionBar(metadata, ExclusionBar.BIG));
        }
    }

    @Override
    public void afterChildBinary(BinaryPredicateMetadata metadata, Metadata child, boolean hasNext, int depth) {
        if (hasNext) {
            if (metadata.getOperator() == DefaultOperator.and || metadata.getOperator() == DefaultOperator.or) {
                this.write("<br>");
            }
            this.htmlFormatSpan(CSS_CLASS_BINARY, StringEscapeUtils.escapeHtml4((String)this.bundle.get(metadata.getOperator(), this.locale)));
            if (metadata.getRight().type() == MetadataType.UNARY_PREDICATE) {
                this.write(AstHtmlVisitor.beginUl(CSS_CLASS_UL_BINARY_CHILD));
                this.closeUn = true;
            }
            this.rightSideOfBinary = true;
            if (metadata.getOperator() != DefaultOperator.and && metadata.getOperator() != DefaultOperator.or) {
                this.noExclusionNextLeaf = true;
            }
        }
    }

    @Override
    public void endBinary(BinaryPredicateMetadata metadata, int depth) {
        if (this.nbImbriBinary > 0) {
            this.write(AstHtmlVisitor.endUl());
            --this.nbImbriBinary;
        }
        if (this.closeSum) {
            this.write(AstHtmlVisitor.endLi());
            this.closeSum = false;
        }
        this.rightSideOfBinary = false;
    }

    @Override
    public void startNary(NaryPredicateMetadata metadata, int depth) {
        if (metadata.getOperator() == DefaultOperator.sum || metadata.getOperator() == DefaultOperator.min) {
            this.insideSum = true;
        }
        if (!(this.insideNary != 0 || this.rightSideOfBinary || metadata.getOperator() != DefaultOperator.sum && metadata.getOperator() != DefaultOperator.count && metadata.getOperator() != DefaultOperator.min)) {
            this.write(AstHtmlVisitor.beginLi(CSS_CLASS_LI_NARY));
        }
        if (this.stackPeek() == MetadataType.WHEN || this.stackPeek() != MetadataType.BINARY_PREDICATE) {
            this.write(AstHtmlVisitor.beginLi(CSS_CLASS_LI_NARY));
        }
        if (metadata.getOperator() != DefaultOperator.count && metadata.getOperator() != DefaultOperator.sum && metadata.getOperator() != DefaultOperator.min) {
            this.write(this.exclusionBar(metadata, ExclusionBar.BIG));
        }
        this.htmlFormatSpan(CSS_CLASS_NARY, StringEscapeUtils.escapeHtml4((String)this.bundle.get(metadata.getOperator(), this.locale)));
        this.rightSideOfBinary = false;
        this.write(AstHtmlVisitor.beginOl(CSS_CLASS_OL_NARY));
        ++this.insideNary;
    }

    @Override
    public void endNary(NaryPredicateMetadata metadata, int depth) {
        this.write(AstHtmlVisitor.endOl());
        --this.insideNary;
        if (metadata.getOperator() == DefaultOperator.sum || metadata.getOperator() == DefaultOperator.min) {
            this.insideSum = false;
        }
    }

    @Override
    public void startUnary(UnaryPredicateMetadata metadata, int depth) {
        this.write(AstHtmlVisitor.beginLi(CSS_CLASS_LI_UNARY));
        this.htmlFormatSpan(CSS_CLASS_UNARY, StringEscapeUtils.escapeHtml4((String)this.bundle.get(metadata.getOperator(), this.locale)));
        if (((Metadata)metadata.children().collect(Collectors.toList()).get(0)).type() != MetadataType.LEAF_PREDICATE) {
            this.write(AstHtmlVisitor.beginUl(CSS_CLASS_UL_UNARY));
            ++this.closeUnaryUL;
        }
    }

    @Override
    public void endUnary(UnaryPredicateMetadata metadata, int depth) {
        if (this.closeUn) {
            this.write(AstHtmlVisitor.endUl());
            this.closeUn = false;
        }
        if (this.closeUnaryUL > 0) {
            this.write(AstHtmlVisitor.endUl());
            --this.closeUnaryUL;
        }
        this.write(AstHtmlVisitor.endLi());
    }

    @Override
    public void startRule(RuleMetadata metadata, int depth) {
        this.formatDivStart(CSS_CLASS_VALIDATION_RULE);
    }

    @Override
    public void endRule(RuleMetadata metadata, int depth) {
        this.htmlFormatSpan(CSS_CLASS_VALIDATE, this.bundle.get(DefaultOperator.validate, this.locale));
        this.write(AstHtmlVisitor.endDiv());
    }

    @Override
    public void afterChildDefault(Metadata metadata, Metadata child, boolean hasNext, int depth) {
        this.write(metadata.readable());
    }

    protected String formatWhen() {
        return this.bundle.get(DefaultOperator.when, this.locale);
    }

    protected void formatLeafOperator(Element e) {
        this.htmlFormatSpan("dsl-token-operator", StringEscapeUtils.escapeHtml4((String)this.bundle.get((Operator)e.getReadable(), this.locale)));
    }

    protected void formatTemporalUnit(Element e) {
        this.htmlFormatSpan("dsl-token-operator", this.bundle.get(e.getReadable().readable(), this.locale));
    }

    protected void formatLeafField(Element e) {
        this.htmlFormatSpan("dsl-token-field", e.getReadable().readable());
    }

    protected void formatParenthesis(Element e) {
        this.htmlFormatSpan("dsl-token-parenthesis", e.getReadable().readable());
    }

    protected void formatLeafValue(Element e) {
        if (e.getType() == ElementType.STRING_VALUE) {
            this.htmlFormatSpan("dsl-token-value", "'" + StringEscapeUtils.escapeHtml4((String)this.bundle.get(e.getReadable().readable(), this.locale)) + "'");
        } else {
            this.htmlFormatSpan("dsl-token-value", StringEscapeUtils.escapeHtml4((String)this.bundle.get(e.getReadable().readable(), this.locale)));
        }
    }

    protected void formatLeafUnknown(Element e) {
        this.htmlFormatSpan("dsl-token-unknown", StringEscapeUtils.escapeHtml4((String)this.bundle.get(e.getReadable().readable(), this.locale)));
    }

    protected void htmlFormatSpan(String cssClass, String content) {
        this.write("<span class=\"" + cssClass + "\">" + content + "</span> ");
    }

    private void formatDivStart(String cssClass) {
        this.write("<div class=\"" + cssClass + "\">");
    }

    protected void write(String s) {
        try {
            this.ops.write(s.getBytes("UTF-8"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    private boolean isImmediateBinaryChild() {
        List stack = this.stackSteam().collect(Collectors.toList());
        if (stack.size() > 1) {
            return stack.get(1) == MetadataType.BINARY_PREDICATE;
        }
        return false;
    }
}

