/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta;

import io.doov.core.dsl.meta.AbstractMetadata;
import io.doov.core.dsl.meta.Element;
import io.doov.core.dsl.meta.ElementType;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.Operator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class UnaryMetadata
extends AbstractMetadata {
    private final Operator operator;
    private final Metadata value;

    public UnaryMetadata(Operator operator, Metadata value) {
        this.operator = operator;
        this.value = value;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Metadata getValue() {
        return this.value;
    }

    @Override
    public MetadataType type() {
        return MetadataType.UNARY_PREDICATE;
    }

    @Override
    public List<Element> flatten() {
        ArrayList<Element> flatten = new ArrayList<Element>();
        flatten.add(new Element(this.operator, ElementType.OPERATOR));
        flatten.addAll(this.value.flatten());
        return flatten;
    }

    @Override
    public Stream<Metadata> right() {
        return Stream.of(this.value);
    }
}

