/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.mapping;

import io.doov.core.FieldInfo;
import io.doov.core.dsl.DslField;
import io.doov.core.dsl.DslModel;
import io.doov.core.dsl.lang.BiTypeConverter;
import io.doov.core.dsl.lang.NaryTypeConverter;
import io.doov.core.dsl.lang.TypeConverter;
import io.doov.core.dsl.mapping.converter.DefaultBiTypeConverter;
import io.doov.core.dsl.mapping.converter.DefaultNaryTypeConverter;
import io.doov.core.dsl.mapping.converter.DefaultTypeConverter;
import io.doov.core.serial.TypeAdapter;
import io.doov.core.serial.TypeAdapterRegistry;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

public class TypeConverters {
    public static <I, O> TypeConverter<I, O> converter(Function<I, O> converter, String description) {
        return new DefaultTypeConverter(i -> i.map(converter).orElseGet(() -> converter.apply(null)), description);
    }

    public static <I> TypeConverter<I, String> asString(TypeAdapterRegistry typeAdapters) {
        return new DefaultTypeConverter((context, i) -> i.map(value -> typeAdapters.stream().filter(t -> t.accept(value)).findFirst().orElseThrow(() -> new IllegalStateException("cannot convert value " + value + " to string.")).toString(value)).orElse("null"), "as string");
    }

    public static <O, T extends DslField<O> & FieldInfo> TypeConverter<String, O> fromString(T fieldInfo, TypeAdapterRegistry typeAdapters) {
        TypeAdapter adapter = typeAdapters.stream().filter(t -> t.accept((FieldInfo)((Object)fieldInfo))).findFirst().orElseThrow(() -> new IllegalArgumentException("cannot find type adapter for field " + fieldInfo.id()));
        return new DefaultTypeConverter((context, i) -> i.map(value -> adapter.fromString((FieldInfo)((Object)fieldInfo), (String)value)).orElse(null), "from string");
    }

    public static <I, O> TypeConverter<I, O> converter(Function<I, O> converter, O nullCase, String description) {
        return new DefaultTypeConverter(i -> i.map(converter).orElse(nullCase), description);
    }

    public static <I, J, O> BiTypeConverter<I, J, O> biConverter(BiFunction<Optional<I>, Optional<J>, O> converter, String description) {
        return new DefaultBiTypeConverter<I, J, O>(converter, description);
    }

    public static <I, J, O> BiTypeConverter<I, J, O> biConverter(BiFunction<I, J, O> converter, O nullCase, String description) {
        return new DefaultBiTypeConverter((i, j) -> i.isPresent() && j.isPresent() ? converter.apply(i.get(), j.get()) : nullCase, description);
    }

    public static <I, J, O> BiTypeConverter<I, J, O> biConverter(BiFunction<I, J, O> converter, I nullIn, J nullIn2, String description) {
        return new DefaultBiTypeConverter((i, j) -> converter.apply(i.orElse(nullIn), j.orElse(nullIn2)), description);
    }

    public static <O> NaryTypeConverter<O> nConverter(BiFunction<DslModel, List<DslField>, O> function, String description) {
        return new DefaultNaryTypeConverter<O>(function, description);
    }

    public static NaryTypeConverter<Integer> counter(String description) {
        return TypeConverters.nConverter((model, fieldInfos) -> (int)fieldInfos.stream().map(f -> model.get(f.id())).filter(Objects::nonNull).count(), description);
    }
}

