/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.DslModel;
import io.doov.core.dsl.impl.DefaultCondition;
import io.doov.core.dsl.impl.LeafStepCondition;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.function.IterableFunctionMetadata;
import io.doov.core.dsl.meta.predicate.PredicateMetadata;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class IterableCondition<T, C extends Iterable<T>>
extends DefaultCondition<C> {
    public IterableCondition(DslField<C> field) {
        super(field);
    }

    public IterableCondition(PredicateMetadata metadata, BiFunction<DslModel, Context, Optional<C>> value) {
        super(metadata, value);
    }

    public StepCondition contains(T value) {
        return LeafStepCondition.predicate(this, IterableFunctionMetadata.containsMetadata((Metadata)this.metadata, value), collection -> StreamSupport.stream(collection.spliterator(), false).anyMatch(value::equals));
    }

    @SafeVarargs
    public final StepCondition containsAll(T ... values) {
        return LeafStepCondition.predicate(this, IterableFunctionMetadata.containsMetadata((Metadata)this.metadata, Arrays.asList(values)), iterable -> StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toSet()).containsAll(Arrays.asList(values)));
    }

    public StepCondition isEmpty() {
        return LeafStepCondition.predicate(this, IterableFunctionMetadata.isEmptyMetadata(this.metadata), iterable -> !iterable.iterator().hasNext());
    }

    public StepCondition isNotEmpty() {
        return LeafStepCondition.predicate(this, IterableFunctionMetadata.isNotEmptyMetadata(this.metadata), iterable -> iterable.iterator().hasNext());
    }

    public StepCondition hasSize(int size) {
        return LeafStepCondition.predicate(this, IterableFunctionMetadata.hasSizeMetadata(this.metadata, size), iterable -> StreamSupport.stream(iterable.spliterator(), false).count() == (long)size);
    }

    public StepCondition hasNotSize(int size) {
        return LeafStepCondition.predicate(this, IterableFunctionMetadata.hasNotSizeMetadata(this.metadata, size), iterable -> StreamSupport.stream(iterable.spliterator(), false).count() != (long)size);
    }
}

