/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.DslModel;
import io.doov.core.dsl.field.types.Condition;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.meta.predicate.PredicateMetadata;
import java.util.Optional;
import java.util.function.BiFunction;

abstract class AbstractCondition<N>
implements Condition<N> {
    protected final PredicateMetadata metadata;
    protected final BiFunction<DslModel, Context, Optional<N>> function;

    protected static <T> Optional<T> valueModel(DslModel model, DslField<T> field) {
        return Optional.ofNullable(model.get(field.id()));
    }

    protected AbstractCondition(PredicateMetadata metadata, BiFunction<DslModel, Context, Optional<N>> function) {
        this.metadata = metadata;
        this.function = function;
    }

    @Override
    public Optional<N> value(DslModel model, Context context) {
        return this.function.apply(model, context);
    }

    public PredicateMetadata getMetadata() {
        return this.metadata;
    }

    public BiFunction<DslModel, Context, Optional<N>> getFunction() {
        return this.function;
    }

    @Override
    public String readable() {
        return this.metadata.readable();
    }
}

