/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.DslModel;
import io.doov.core.dsl.Streams;
import io.doov.core.dsl.field.types.NumericFieldInfo;
import io.doov.core.dsl.impl.DefaultCondition;
import io.doov.core.dsl.impl.DefaultStepCondition;
import io.doov.core.dsl.impl.DefaultStepWhen;
import io.doov.core.dsl.impl.LogicalNaryCondition;
import io.doov.core.dsl.impl.LogicalUnaryCondition;
import io.doov.core.dsl.impl.num.IntegerFunction;
import io.doov.core.dsl.impl.num.NumericCondition;
import io.doov.core.dsl.impl.num.NumericFunction;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.MappingInput;
import io.doov.core.dsl.lang.MappingRule;
import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.lang.StepWhen;
import io.doov.core.dsl.mapping.MappingRegistry;
import io.doov.core.dsl.mapping.builder.BiStepMap;
import io.doov.core.dsl.mapping.builder.ContextawareStepMap;
import io.doov.core.dsl.mapping.builder.NaryStepMap;
import io.doov.core.dsl.mapping.builder.SimpleStepMap;
import io.doov.core.dsl.mapping.builder.StaticStepMap;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.predicate.LeafPredicateMetadata;
import io.doov.core.dsl.meta.predicate.PredicateMetadata;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class DOOV {
    private DOOV() {
    }

    public static StepWhen when(StepCondition condition) {
        return new DefaultStepWhen(condition);
    }

    public static StepCondition alwaysTrue() {
        return new DefaultStepCondition((PredicateMetadata)LeafPredicateMetadata.trueMetadata(), (model, context) -> true);
    }

    public static StepCondition alwaysTrue(String readable) {
        return new DefaultStepCondition((PredicateMetadata)((LeafMetadata)LeafPredicateMetadata.trueMetadata()).valueReadable(() -> readable), (model, context) -> true);
    }

    public static StepCondition alwaysFalse() {
        return new DefaultStepCondition((PredicateMetadata)LeafPredicateMetadata.falseMetadata(), (model, context) -> false);
    }

    public static StepCondition alwaysFalse(String readable) {
        return new DefaultStepCondition((PredicateMetadata)((LeafMetadata)LeafPredicateMetadata.falseMetadata()).valueReadable(() -> readable), (model, context) -> false);
    }

    public static IntegerFunction count(StepCondition ... steps) {
        return LogicalNaryCondition.count(Arrays.asList(steps));
    }

    public static StepCondition matchAny(StepCondition ... steps) {
        return LogicalNaryCondition.matchAny(Arrays.asList(steps));
    }

    public static StepCondition not(StepCondition step) {
        return LogicalUnaryCondition.negate(step);
    }

    public static StepCondition matchAny(Stream<? extends DslField<?>> dslFields, Function<DefaultCondition<?>, StepCondition> stepConditionFunction) {
        return LogicalNaryCondition.matchAny(dslFields.filter(Objects::nonNull).map(DslField::getDefaultCondition).map(stepConditionFunction).collect(Collectors.toList()));
    }

    public static StepCondition matchAll(StepCondition ... steps) {
        return LogicalNaryCondition.matchAll(Arrays.asList(steps));
    }

    public static StepCondition matchAll(Stream<? extends DslField<?>> dslFields, Function<DefaultCondition<?>, StepCondition> stepConditionFunction) {
        return LogicalNaryCondition.matchAll(dslFields.filter(Objects::nonNull).map(DslField::getDefaultCondition).map(stepConditionFunction).collect(Collectors.toList()));
    }

    public static StepCondition matchNone(StepCondition ... steps) {
        return LogicalNaryCondition.matchNone(Arrays.asList(steps));
    }

    public static StepCondition matchNone(Stream<? extends DslField<?>> dslFields, Function<DefaultCondition<?>, StepCondition> stepConditionFunction) {
        return LogicalNaryCondition.matchNone(dslFields.filter(Objects::nonNull).map(DslField::getDefaultCondition).map(stepConditionFunction).collect(Collectors.toList()));
    }

    public static <I> SimpleStepMap<I> map(DslField<I> inFieldInfo) {
        return new SimpleStepMap<I>(inFieldInfo);
    }

    public static <I, J> BiStepMap<I, J> map(DslField<I> inFieldInfo, DslField<J> in2FieldInfo) {
        return new BiStepMap<I, J>(inFieldInfo, in2FieldInfo);
    }

    public static NaryStepMap map(DslField<?> ... inFieldInfos) {
        return new NaryStepMap(Arrays.asList(inFieldInfos));
    }

    public static NaryStepMap map(Stream<? extends DslField<?>> inFieldInfos) {
        return new NaryStepMap(inFieldInfos.collect(Collectors.toList()));
    }

    public static <I> StaticStepMap<I> map(Supplier<I> valueSupplier) {
        return new StaticStepMap<I>(valueSupplier);
    }

    public static <I> StaticStepMap<I> map(I value) {
        return new StaticStepMap<Object>(() -> value);
    }

    public static <O> MappingRule mapNull(DslField<O> outFieldInfo) {
        return new StaticStepMap<Object>(() -> null).to(outFieldInfo);
    }

    public static <I> ContextawareStepMap<I> map(BiFunction<DslModel, Context, I> valueFunction) {
        return new ContextawareStepMap<I>(valueFunction);
    }

    public static <I> ContextawareStepMap<I> map(MappingInput<I> input) {
        return new ContextawareStepMap<I>(input);
    }

    public static MappingRegistry mappings(MappingRule ... mappingRules) {
        return MappingRegistry.mappings(mappingRules);
    }

    public static MappingRegistry mapRange(int startInclusive, int endExclusive, Function<Integer, MappingRule> mappingRuleFunction) {
        return MappingRegistry.mappings((MappingRule[])IntStream.range(startInclusive, endExclusive).mapToObj(mappingRuleFunction::apply).toArray(MappingRule[]::new));
    }

    public static <T extends DslField<?>> MappingRegistry mapFor(Stream<T> fieldStream, Function<T, MappingRule> mappingRuleFunction) {
        return MappingRegistry.mappings((MappingRule[])fieldStream.filter(Objects::nonNull).map(mappingRuleFunction).toArray(MappingRule[]::new));
    }

    public static <T extends DslField<?>> MappingRegistry mapWithIndex(Stream<T> fieldStream, BiFunction<T, Integer, MappingRule> mappingRuleFunction) {
        return MappingRegistry.mappings((MappingRule[])Streams.mapWithIndex(fieldStream, (? super T f, Long l) -> (MappingRule)mappingRuleFunction.apply(f, l.intValue())).toArray(MappingRule[]::new));
    }

    public static <T extends DslField<?>> T fieldInPosition(Stream<T> fieldStream, int index) {
        return (T)fieldStream.filter(Objects::nonNull).filter(f -> f.id().position() == index).findFirst().orElseThrow(() -> new IllegalArgumentException("Field with position " + index + " not found."));
    }

    @SafeVarargs
    public static <N extends Number> NumericFunction<N> min(NumericFieldInfo<N> ... fields) {
        return Arrays.stream(fields).filter(Objects::nonNull).findFirst().map(NumericFieldInfo::getNumericCondition).map(c -> c.min(Arrays.asList(fields))).orElseThrow(IllegalArgumentException::new);
    }

    @SafeVarargs
    public static <N extends Number> NumericCondition<N> sum(NumericFieldInfo<N> ... fields) {
        return Arrays.stream(fields).filter(Objects::nonNull).findFirst().map(NumericFieldInfo::getNumericCondition).map(c -> c.sum(Arrays.asList(fields))).orElseThrow(IllegalArgumentException::new);
    }

    @SafeVarargs
    public static <N extends Number> NumericFunction<N> sum(NumericFunction<N> ... conditions) {
        return Arrays.stream(conditions).filter(Objects::nonNull).findFirst().map(c -> c.sumConditions(Arrays.asList(conditions))).orElseThrow(IllegalArgumentException::new);
    }
}

