/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.lang.ValidationRule;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.Element;
import io.doov.core.dsl.meta.ElementType;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.Operator;
import io.doov.core.dsl.meta.RuleMetadata;
import io.doov.core.dsl.meta.WhenMetadata;
import io.doov.core.dsl.meta.ast.AbstractAstVisitor;
import io.doov.core.dsl.meta.ast.ExclusionBar;
import io.doov.core.dsl.meta.i18n.ResourceProvider;
import io.doov.core.dsl.meta.predicate.BinaryPredicateMetadata;
import io.doov.core.dsl.meta.predicate.LeafPredicateMetadata;
import io.doov.core.dsl.meta.predicate.NaryPredicateMetadata;
import io.doov.core.dsl.meta.predicate.PredicateMetadata;
import io.doov.core.dsl.meta.predicate.UnaryPredicateMetadata;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;

public class AstHtmlVisitor
extends AbstractAstVisitor {
    protected static final String CSS_CLASS_VALIDATION_RULE = "dsl-validation-rule";
    protected static final String CSS_CLASS_VALIDATE = "dsl-token-validate";
    protected static final String CSS_CLASS_BINARY = "dsl-token-binary";
    protected static final String CSS_CLASS_UNARY = "dsl-token-unary";
    protected static final String CSS_CLASS_NARY = "dsl-token-nary";
    protected static final String CSS_CLASS_WHEN = "dsl-token-when";
    protected static final String END_DIV = "</div>";
    protected static final String BEG_LI = "<li>";
    protected static final String END_LI = "</li>";
    protected static final String BEG_OL = "<ol>";
    protected static final String END_OL = "</ol>";
    protected static final String BEG_UL = "<ul>";
    protected static final String END_UL = "</ul>";
    protected final OutputStream ops;
    protected final ResourceProvider bundle;
    protected Locale locale;
    protected boolean closeSum = false;
    protected int closeUnaryUL = 0;
    protected int insideNary = 0;
    protected int nbImbriBinary = 0;
    protected boolean rightSideOfBinary = false;
    private boolean closeUn = false;
    private boolean insideSum = false;
    private boolean noExclusionNextLeaf = false;
    private static final MessageFormat format_bar_not_available = new MessageFormat("<div class=''{0}''><div class=''percentage-value''> n/a</div><div class=''{1}''><div class=''{2}'' style=''width:0%;''></div></div></div>", Locale.US);
    private static final MessageFormat format_bar_percentage = new MessageFormat("<div class=''{0}''><div class=''percentage-value''>{1} %</div><div class=''{2}''><div class=''{3}'' style=''width:{4}%;''></div></div></div>", Locale.US);

    private String exclusionBar(PredicateMetadata metadata, ExclusionBar cssClass) {
        int nbTrue = metadata.trueEvalCount();
        int nbFalse = metadata.falseEvalCount();
        if (nbTrue == 0 && nbFalse == 0) {
            return format_bar_not_available.format(new Object[]{cssClass.getWrapperClass(), cssClass.getBorderClass(), cssClass.getFillingClass()});
        }
        Double percentage = Math.floor((double)nbTrue / ((double)nbTrue + (double)nbFalse) * 1000.0) / 10.0;
        return format_bar_percentage.format(new Object[]{cssClass.getWrapperClass(), percentage, cssClass.getBorderClass(), cssClass.getFillingClass(), percentage});
    }

    public String exclusionBar(ValidationRule rule, ExclusionBar cssClass) {
        Metadata conditionMetadata = rule.getStepWhen().stepCondition().metadata();
        if (conditionMetadata instanceof PredicateMetadata) {
            return this.exclusionBar((PredicateMetadata)conditionMetadata, cssClass);
        }
        return "";
    }

    public AstHtmlVisitor(OutputStream ops, ResourceProvider bundle, Locale locale) {
        this.ops = ops;
        this.bundle = bundle;
        this.locale = locale;
    }

    @Override
    public void startWhen(WhenMetadata metadata, int depth) {
        this.htmlFormatSpan(CSS_CLASS_WHEN, this.formatWhen());
        this.write(BEG_UL);
    }

    @Override
    public void endWhen(WhenMetadata metadata, int depth) {
        this.write(END_UL);
    }

    @Override
    public void startLeaf(LeafPredicateMetadata<?> leaf, int depth) {
        if (this.stackPeek() == MetadataType.WHEN || this.insideNary > 0 && this.stackPeek() != MetadataType.BINARY_PREDICATE) {
            this.write(BEG_LI);
        }
        if (!this.insideSum) {
            if (this.noExclusionNextLeaf) {
                this.noExclusionNextLeaf = false;
            } else {
                this.write(this.exclusionBar(leaf, ExclusionBar.SMALL));
            }
        }
        leaf.elements().stream().forEach(e -> {
            switch (e.getType()) {
                case PARENTHESIS_LEFT: 
                case PARENTHESIS_RIGHT: {
                    this.formatParenthesis((Element)e);
                    break;
                }
                case OPERATOR: {
                    this.formatLeafOperator((Element)e);
                    break;
                }
                case TEMPORAL_UNIT: {
                    this.formatTemporalUnit((Element)e);
                    break;
                }
                case FIELD: {
                    this.formatLeafField((Element)e);
                    break;
                }
                case VALUE: 
                case STRING_VALUE: {
                    this.formatLeafValue((Element)e);
                    break;
                }
                case UNKNOWN: {
                    this.formatLeafUnknown((Element)e);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown element type " + (Object)((Object)e.getType()));
                }
            }
        });
    }

    @Override
    public void endLeaf(LeafPredicateMetadata<?> metadata, int depth) {
        if (this.stackPeek() == MetadataType.WHEN || this.insideNary > 0 && !this.isImmediateBinaryChild()) {
            this.write(END_LI);
        }
    }

    @Override
    public void startBinary(BinaryPredicateMetadata metadata, int depth) {
        Metadata leftChild = metadata.getLeft();
        if (MetadataType.NARY_PREDICATE == this.stackPeek() && metadata.getOperator() != DefaultOperator.or && metadata.getOperator() != DefaultOperator.and) {
            this.write(BEG_LI);
            this.closeSum = true;
        }
        if (this.rightSideOfBinary && leftChild.type() != MetadataType.NARY_PREDICATE) {
            this.write(BEG_UL);
            ++this.nbImbriBinary;
            this.rightSideOfBinary = false;
        }
        if (leftChild.type() != MetadataType.BINARY_PREDICATE && leftChild.type() != MetadataType.NARY_PREDICATE) {
            this.write(BEG_LI);
        }
        if (metadata.getOperator() != DefaultOperator.and && metadata.getOperator() != DefaultOperator.or) {
            this.write(this.exclusionBar(metadata, ExclusionBar.BIG));
        }
    }

    @Override
    public void afterChildBinary(BinaryPredicateMetadata metadata, Metadata child, boolean hasNext, int depth) {
        if (hasNext) {
            if (metadata.getOperator() == DefaultOperator.and || metadata.getOperator() == DefaultOperator.or) {
                this.write("<br>");
            }
            this.htmlFormatSpan(CSS_CLASS_BINARY, StringEscapeUtils.escapeHtml4((String)this.bundle.get(metadata.getOperator(), this.locale)));
            if (metadata.getRight().type() == MetadataType.UNARY_PREDICATE) {
                this.write(BEG_UL);
                this.closeUn = true;
            }
            this.rightSideOfBinary = true;
            if (metadata.getOperator() != DefaultOperator.and && metadata.getOperator() != DefaultOperator.or) {
                this.noExclusionNextLeaf = true;
            }
        }
    }

    @Override
    public void endBinary(BinaryPredicateMetadata metadata, int depth) {
        if (this.nbImbriBinary > 0) {
            this.write(END_UL);
            --this.nbImbriBinary;
        }
        if (this.closeSum) {
            this.write(END_LI);
            this.closeSum = false;
        }
        this.rightSideOfBinary = false;
    }

    @Override
    public void startNary(NaryPredicateMetadata metadata, int depth) {
        if (metadata.getOperator() == DefaultOperator.sum || metadata.getOperator() == DefaultOperator.min) {
            this.insideSum = true;
        }
        if (!(this.insideNary != 0 || this.rightSideOfBinary || metadata.getOperator() != DefaultOperator.sum && metadata.getOperator() != DefaultOperator.count && metadata.getOperator() != DefaultOperator.min)) {
            this.write(BEG_LI);
        }
        if (this.stackPeek() == MetadataType.WHEN || this.stackPeek() != MetadataType.BINARY_PREDICATE) {
            this.write(BEG_LI);
        }
        if (metadata.getOperator() != DefaultOperator.count && metadata.getOperator() != DefaultOperator.sum && metadata.getOperator() != DefaultOperator.min) {
            this.write(this.exclusionBar(metadata, ExclusionBar.BIG));
        }
        this.htmlFormatSpan(CSS_CLASS_NARY, StringEscapeUtils.escapeHtml4((String)this.bundle.get(metadata.getOperator(), this.locale)));
        this.rightSideOfBinary = false;
        this.write(BEG_OL);
        ++this.insideNary;
    }

    @Override
    public void endNary(NaryPredicateMetadata metadata, int depth) {
        this.write(END_OL);
        --this.insideNary;
        if (metadata.getOperator() == DefaultOperator.sum || metadata.getOperator() == DefaultOperator.min) {
            this.insideSum = false;
        }
    }

    @Override
    public void startUnary(UnaryPredicateMetadata metadata, int depth) {
        this.write(BEG_LI);
        this.htmlFormatSpan(CSS_CLASS_UNARY, StringEscapeUtils.escapeHtml4((String)this.bundle.get(metadata.getOperator(), this.locale)));
        if (((Metadata)metadata.children().collect(Collectors.toList()).get(0)).type() != MetadataType.LEAF_PREDICATE) {
            this.write(BEG_UL);
            ++this.closeUnaryUL;
        }
    }

    @Override
    public void endUnary(UnaryPredicateMetadata metadata, int depth) {
        if (this.closeUn) {
            this.write(END_UL);
            this.closeUn = false;
        }
        if (this.closeUnaryUL > 0) {
            this.write(END_UL);
            --this.closeUnaryUL;
        }
        this.write(END_LI);
    }

    @Override
    public void startRule(RuleMetadata metadata, int depth) {
        this.formatDivStart(CSS_CLASS_VALIDATION_RULE);
    }

    @Override
    public void endRule(RuleMetadata metadata, int depth) {
        this.htmlFormatSpan(CSS_CLASS_VALIDATE, this.bundle.get(DefaultOperator.validate, this.locale));
        this.write(END_DIV);
    }

    @Override
    public void afterChildDefault(Metadata metadata, Metadata child, boolean hasNext, int depth) {
        this.write(metadata.readable());
    }

    protected String formatWhen() {
        return this.bundle.get(DefaultOperator.when, this.locale);
    }

    protected void formatLeafOperator(Element e) {
        this.htmlFormatSpan("dsl-token-operator", StringEscapeUtils.escapeHtml4((String)this.bundle.get((Operator)e.getReadable(), this.locale)));
    }

    protected void formatTemporalUnit(Element e) {
        this.htmlFormatSpan("dsl-token-operator", this.bundle.get(e.getReadable().readable(), this.locale));
    }

    protected void formatLeafField(Element e) {
        this.htmlFormatSpan("dsl-token-field", e.getReadable().readable());
    }

    protected void formatParenthesis(Element e) {
        this.htmlFormatSpan("dsl-token-parenthesis", e.getReadable().readable());
    }

    protected void formatLeafValue(Element e) {
        if (e.getType() == ElementType.STRING_VALUE) {
            this.htmlFormatSpan("dsl-token-value", "'" + StringEscapeUtils.escapeHtml4((String)this.bundle.get(e.getReadable().readable(), this.locale)) + "'");
        } else {
            this.htmlFormatSpan("dsl-token-value", StringEscapeUtils.escapeHtml4((String)this.bundle.get(e.getReadable().readable(), this.locale)));
        }
    }

    protected void formatLeafUnknown(Element e) {
        this.htmlFormatSpan("dsl-token-unknown", StringEscapeUtils.escapeHtml4((String)this.bundle.get(e.getReadable().readable(), this.locale)));
    }

    protected void htmlFormatSpan(String cssClass, String content) {
        this.write("<span class=\"" + cssClass + "\">" + content + "</span> ");
    }

    private void formatDivStart(String cssClass) {
        this.write("<div class=\"" + cssClass + "\">");
    }

    protected void write(String s) {
        try {
            this.ops.write(s.getBytes("UTF-8"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    private boolean isImmediateBinaryChild() {
        List stack = this.stackSteam().collect(Collectors.toList());
        if (stack.size() > 1) {
            return stack.get(1) == MetadataType.BINARY_PREDICATE;
        }
        return false;
    }
}

