/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.meta.ConverterMetadata;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.MetadataVisitor;
import io.doov.core.dsl.meta.RuleMetadata;
import io.doov.core.dsl.meta.WhenMetadata;
import io.doov.core.dsl.meta.predicate.BinaryPredicateMetadata;
import io.doov.core.dsl.meta.predicate.LeafPredicateMetadata;
import io.doov.core.dsl.meta.predicate.NaryPredicateMetadata;
import io.doov.core.dsl.meta.predicate.UnaryPredicateMetadata;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public abstract class AbstractAstVisitor
implements MetadataVisitor {
    private final Deque<MetadataType> stack = new ArrayDeque<MetadataType>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void start(Metadata metadata, int depth) {
        try {
            switch (metadata.type()) {
                case WHEN: {
                    this.startWhen((WhenMetadata)metadata, depth);
                    return;
                }
                case UNARY_PREDICATE: {
                    this.startUnary((UnaryPredicateMetadata)metadata, depth);
                    return;
                }
                case FIELD_PREDICATE: 
                case FIELD_PREDICATE_MATCH_ANY: 
                case LEAF_PREDICATE: {
                    this.startLeaf((LeafPredicateMetadata)metadata, depth);
                    return;
                }
                case BINARY_PREDICATE: {
                    this.startBinary((BinaryPredicateMetadata)metadata, depth);
                    return;
                }
                case MAPPING_INPUT: 
                case MAPPING_LEAF: 
                case SINGLE_MAPPING: 
                case MULTIPLE_MAPPING: 
                case THEN_MAPPING: 
                case ELSE_MAPPING: {
                    this.startMappingRule(metadata, depth);
                    return;
                }
                case NARY_PREDICATE: {
                    this.startNary((NaryPredicateMetadata)metadata, depth);
                    return;
                }
                case RULE: {
                    this.startRule((RuleMetadata)metadata, depth);
                    return;
                }
                case TYPE_CONVERTER: 
                case TYPE_CONVERTER_IDENTITY: {
                    this.startTypeConverter((ConverterMetadata)metadata, depth);
                    return;
                }
                default: {
                    this.startDefault(metadata, depth);
                    return;
                }
            }
        }
        finally {
            this.stack.push(metadata.type());
        }
    }

    @Override
    public void beforeChild(Metadata metadata, Metadata child, int depth) {
        switch (metadata.type()) {
            case WHEN: {
                this.beforeChildWhen((WhenMetadata)metadata, child, depth);
                break;
            }
            case RULE: {
                this.beforeChildRule((RuleMetadata)metadata, child, depth);
                break;
            }
            case UNARY_PREDICATE: {
                this.beforeChildUnary((UnaryPredicateMetadata)metadata, child, depth);
                break;
            }
            case LEAF_PREDICATE: {
                throw new IllegalStateException("no visit : there is no children");
            }
            case FIELD_PREDICATE: 
            case FIELD_PREDICATE_MATCH_ANY: 
            case BINARY_PREDICATE: {
                this.beforeChildBinary((BinaryPredicateMetadata)metadata, child, depth);
                break;
            }
            case MAPPING_INPUT: 
            case MAPPING_LEAF: 
            case SINGLE_MAPPING: 
            case MULTIPLE_MAPPING: 
            case THEN_MAPPING: 
            case ELSE_MAPPING: {
                this.beforeChildMappingRule(metadata, child, depth);
                break;
            }
            case NARY_PREDICATE: {
                this.beforeChildNary((NaryPredicateMetadata)metadata, child, depth);
                break;
            }
            case TYPE_CONVERTER: 
            case TYPE_CONVERTER_IDENTITY: {
                this.beforeChildTypeConverter((ConverterMetadata)metadata, child, depth);
                break;
            }
            default: {
                this.beforeChildDefault(metadata, depth);
            }
        }
    }

    @Override
    public void afterChild(Metadata metadata, Metadata child, boolean hasNext, int depth) {
        switch (metadata.type()) {
            case WHEN: {
                this.afterChildWhen((WhenMetadata)metadata, child, hasNext, depth);
                break;
            }
            case UNARY_PREDICATE: {
                this.afterChildUnary((UnaryPredicateMetadata)metadata, child, hasNext, depth);
                break;
            }
            case RULE: {
                this.afterChildRule((RuleMetadata)metadata, child, hasNext, depth);
                break;
            }
            case LEAF_PREDICATE: {
                throw new IllegalStateException("no visit : there is no children");
            }
            case FIELD_PREDICATE: 
            case FIELD_PREDICATE_MATCH_ANY: 
            case BINARY_PREDICATE: {
                this.afterChildBinary((BinaryPredicateMetadata)metadata, child, hasNext, depth);
                break;
            }
            case MAPPING_INPUT: 
            case MAPPING_LEAF: 
            case SINGLE_MAPPING: 
            case MULTIPLE_MAPPING: 
            case THEN_MAPPING: 
            case ELSE_MAPPING: {
                this.afterChildMappingRule(metadata, child, hasNext, depth);
                break;
            }
            case NARY_PREDICATE: {
                this.afterChildNary((NaryPredicateMetadata)metadata, child, hasNext, depth);
                break;
            }
            case TYPE_CONVERTER: 
            case TYPE_CONVERTER_IDENTITY: {
                this.afterChildTypeConverter((ConverterMetadata)metadata, child, hasNext, depth);
                break;
            }
            default: {
                this.afterChildDefault(metadata, child, hasNext, depth);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void end(Metadata metadata, int depth) {
        try {
            switch (metadata.type()) {
                case WHEN: {
                    this.endWhen((WhenMetadata)metadata, depth);
                    return;
                }
                case UNARY_PREDICATE: {
                    this.endUnary((UnaryPredicateMetadata)metadata, depth);
                    return;
                }
                case FIELD_PREDICATE: 
                case FIELD_PREDICATE_MATCH_ANY: 
                case LEAF_PREDICATE: {
                    this.endLeaf((LeafPredicateMetadata)metadata, depth);
                    return;
                }
                case BINARY_PREDICATE: {
                    this.endBinary((BinaryPredicateMetadata)metadata, depth);
                    return;
                }
                case MAPPING_INPUT: 
                case MAPPING_LEAF: 
                case SINGLE_MAPPING: 
                case MULTIPLE_MAPPING: 
                case THEN_MAPPING: 
                case ELSE_MAPPING: {
                    this.endMappingRule(metadata, depth);
                    return;
                }
                case NARY_PREDICATE: {
                    this.endNary((NaryPredicateMetadata)metadata, depth);
                    return;
                }
                case RULE: {
                    this.endRule((RuleMetadata)metadata, depth);
                    return;
                }
                case TYPE_CONVERTER: 
                case TYPE_CONVERTER_IDENTITY: {
                    this.endTypeConverter((ConverterMetadata)metadata, depth);
                    return;
                }
                default: {
                    this.endDefault(metadata, depth);
                    return;
                }
            }
        }
        finally {
            this.stack.pop();
        }
    }

    public void startDefault(Metadata metadata, int depth) {
    }

    public void beforeChildDefault(Metadata metadata, int depth) {
    }

    public void afterChildDefault(Metadata metadata, Metadata child, boolean hasNext, int depth) {
    }

    public void endDefault(Metadata metadata, int depth) {
    }

    public void startLeaf(LeafPredicateMetadata<?> metadata, int depth) {
    }

    public void endLeaf(LeafPredicateMetadata<?> metadata, int depth) {
    }

    public void startUnary(UnaryPredicateMetadata metadata, int depth) {
    }

    public void beforeChildUnary(UnaryPredicateMetadata metadata, Metadata child, int depth) {
    }

    public void afterChildUnary(UnaryPredicateMetadata metadata, Metadata child, boolean hasNext, int depth) {
    }

    public void endUnary(UnaryPredicateMetadata metadata, int depth) {
    }

    public void startBinary(BinaryPredicateMetadata metadata, int depth) {
    }

    public void beforeChildBinary(BinaryPredicateMetadata metadata, Metadata child, int depth) {
    }

    public void afterChildBinary(BinaryPredicateMetadata metadata, Metadata child, boolean hasNext, int depth) {
    }

    public void endBinary(BinaryPredicateMetadata metadata, int depth) {
    }

    public void startNary(NaryPredicateMetadata metadata, int depth) {
    }

    public void visitNary(NaryPredicateMetadata metadata, int depth) {
    }

    public void beforeChildNary(NaryPredicateMetadata metadata, Metadata child, int depth) {
    }

    public void afterChildNary(NaryPredicateMetadata metadata, Metadata child, boolean hasNext, int depth) {
    }

    public void endNary(NaryPredicateMetadata metadata, int depth) {
    }

    public void startRule(RuleMetadata metadata, int depth) {
    }

    public void beforeChildRule(RuleMetadata metadata, Metadata child, int depth) {
    }

    public void afterChildRule(RuleMetadata metadata, Metadata child, boolean hasNext, int depth) {
    }

    public void endRule(RuleMetadata metadata, int depth) {
    }

    public void startWhen(WhenMetadata metadata, int depth) {
    }

    public void beforeChildWhen(WhenMetadata metadata, Metadata child, int depth) {
    }

    public void afterChildWhen(WhenMetadata metadata, Metadata child, boolean hasNext, int depth) {
    }

    public void endWhen(WhenMetadata metadata, int depth) {
    }

    public void startTypeConverter(ConverterMetadata metadata, int depth) {
    }

    public void beforeChildTypeConverter(ConverterMetadata metadata, Metadata child, int depth) {
    }

    public void afterChildTypeConverter(ConverterMetadata metadata, Metadata child, boolean hasNext, int depth) {
    }

    public void endTypeConverter(ConverterMetadata metadata, int depth) {
    }

    public void startMappingRule(Metadata metadata, int depth) {
    }

    public void beforeChildMappingRule(Metadata metadata, Metadata child, int depth) {
    }

    public void afterChildMappingRule(Metadata metadata, Metadata child, boolean hasNext, int depth) {
    }

    public void endMappingRule(Metadata metadata, int depth) {
    }

    public void visitCondition(StepCondition metadata, int depth) {
    }

    protected int getIndentSize() {
        return 0;
    }

    protected int getCurrentIndentSize() {
        return this.stack.size() * this.getIndentSize();
    }

    protected String formatCurrentIndent() {
        return IntStream.range(0, this.getCurrentIndentSize()).mapToObj(i -> " ").collect(Collectors.joining(""));
    }

    protected String formatNewLine() {
        return "\n";
    }

    protected MetadataType stackPeek() {
        return this.stack.peek();
    }

    protected final Stream<MetadataType> stackSteam() {
        return this.stack.stream();
    }
}

