/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta;

import io.doov.core.dsl.meta.AbstractMetadata;
import io.doov.core.dsl.meta.Element;
import io.doov.core.dsl.meta.ElementType;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.Operator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class BinaryMetadata
extends AbstractMetadata {
    private final Metadata left;
    private final Operator operator;
    private final Metadata right;

    public BinaryMetadata(Metadata left, Operator operator, Metadata right) {
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    public Metadata getLeft() {
        return this.left;
    }

    public Metadata getRight() {
        return this.right;
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public Stream<Metadata> children() {
        return Stream.of(this.left, this.right);
    }

    @Override
    public MetadataType type() {
        return MetadataType.BINARY_PREDICATE;
    }

    @Override
    public List<Element> flatten() {
        ArrayList<Element> flatten = new ArrayList<Element>(this.left.flatten());
        flatten.add(new Element(this.operator, ElementType.OPERATOR));
        flatten.addAll(this.right.flatten());
        return flatten;
    }
}

