/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl.time;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.DslModel;
import io.doov.core.dsl.field.types.TemporalFieldInfo;
import io.doov.core.dsl.impl.DefaultCondition;
import io.doov.core.dsl.impl.LeafStepCondition;
import io.doov.core.dsl.impl.LogicalBinaryCondition;
import io.doov.core.dsl.impl.LogicalUnaryCondition;
import io.doov.core.dsl.impl.time.TemporalOperators;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.function.TemporalFunctionMetadata;
import io.doov.core.dsl.meta.predicate.LeafPredicateMetadata;
import io.doov.core.dsl.meta.predicate.PredicateMetadata;
import java.time.temporal.Temporal;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public abstract class TemporalCondition<N extends Temporal>
extends DefaultCondition<N>
implements TemporalOperators<N> {
    public TemporalCondition(DslField<N> field) {
        super(field);
    }

    public TemporalCondition(PredicateMetadata metadata, BiFunction<DslModel, Context, Optional<N>> value) {
        super(metadata, value);
    }

    abstract TemporalCondition<N> temporalCondition(PredicateMetadata var1, BiFunction<DslModel, Context, Optional<N>> var2);

    @Override
    public final StepCondition eq(TemporalCondition<N> value) {
        return LeafStepCondition.predicate(this, LeafPredicateMetadata.equalsMetadata((Metadata)this.metadata, value), value, Object::equals);
    }

    public final StepCondition before(N value) {
        return LeafStepCondition.predicate(this, TemporalFunctionMetadata.beforeValueMetadata(this, value), value, (l, r) -> this.beforeFunction().apply(l, r));
    }

    public final StepCondition before(TemporalFieldInfo<N> value) {
        return LeafStepCondition.predicate(this, TemporalFunctionMetadata.beforeTemporalFieldMetadata(this, value), value, (l, r) -> this.beforeFunction().apply(l, r));
    }

    public final StepCondition before(Supplier<N> value) {
        return LeafStepCondition.predicate(this, TemporalFunctionMetadata.beforeSupplierMetadata(this, value), value, (l, r) -> this.beforeFunction().apply(l, r));
    }

    public final StepCondition before(TemporalCondition<N> value) {
        return LeafStepCondition.predicate(this, TemporalFunctionMetadata.beforeTemporalConditionMetadata(this, value), value, (l, r) -> this.beforeFunction().apply(l, r));
    }

    public final StepCondition beforeOrEq(N value) {
        return LeafStepCondition.predicate(this, TemporalFunctionMetadata.beforeOrEqualsValueMetadata(this, value), value, (l, r) -> this.beforeOrEqualsFunction().apply(l, r));
    }

    public final StepCondition beforeOrEq(Supplier<N> value) {
        return LeafStepCondition.predicate(this, TemporalFunctionMetadata.beforeOrEqualsSupplierMetadata(this, value), value, (l, r) -> this.beforeOrEqualsFunction().apply(l, r));
    }

    public final StepCondition beforeOrEq(TemporalCondition<N> value) {
        return LeafStepCondition.predicate(this, TemporalFunctionMetadata.beforeOrEqualsTemporalConditionMetadata(this, value), value, (l, r) -> this.beforeOrEqualsFunction().apply(l, r));
    }

    public final StepCondition after(N value) {
        return LeafStepCondition.predicate(this, TemporalFunctionMetadata.afterValueMetadata(this, value), value, (l, r) -> this.afterFunction().apply(l, r));
    }

    public final StepCondition after(TemporalFieldInfo<N> value) {
        return LeafStepCondition.predicate(this, TemporalFunctionMetadata.afterTemporalFieldMetadata(this, value), value, (l, r) -> this.afterFunction().apply(l, r));
    }

    public final StepCondition after(Supplier<N> value) {
        return LeafStepCondition.predicate(this, TemporalFunctionMetadata.afterSupplierMetadata(this, value), value, (l, r) -> this.afterFunction().apply(l, r));
    }

    public final StepCondition after(TemporalCondition<N> value) {
        return LeafStepCondition.predicate(this, TemporalFunctionMetadata.afterTemporalConditionMetadata(this, value), value, (l, r) -> this.afterFunction().apply(l, r));
    }

    public final StepCondition afterOrEq(N value) {
        return LeafStepCondition.predicate(this, TemporalFunctionMetadata.afterOrEqualsValueMetadata(this, value), value, (l, r) -> this.afterOrEqualsFunction().apply(l, r));
    }

    public final StepCondition afterOrEq(Supplier<N> value) {
        return LeafStepCondition.predicate(this, TemporalFunctionMetadata.afterOrEqualsSupplierMetadata(this, value), value, (l, r) -> this.afterOrEqualsFunction().apply(l, r));
    }

    public final StepCondition afterOrEq(TemporalCondition<N> value) {
        return LeafStepCondition.predicate(this, TemporalFunctionMetadata.afterOrEqualsTemporalConditionMetadata(this, value), value, (l, r) -> this.afterOrEqualsFunction().apply(l, r));
    }

    public final StepCondition between(N minIncluded, N maxExcluded) {
        return LogicalBinaryCondition.and(this.beforeOrEq(maxExcluded), this.afterOrEq(minIncluded));
    }

    public final StepCondition between(Supplier<N> minIncluded, Supplier<N> maxExcluded) {
        return LogicalBinaryCondition.and(this.beforeOrEq(maxExcluded), this.afterOrEq(minIncluded));
    }

    public final StepCondition between(TemporalCondition<N> minIncluded, TemporalCondition<N> maxExcluded) {
        return LogicalBinaryCondition.and(this.beforeOrEq(maxExcluded), this.afterOrEq(minIncluded));
    }

    public final StepCondition notBetween(N minIncluded, N maxExcluded) {
        return LogicalUnaryCondition.negate(this.between(minIncluded, maxExcluded));
    }

    public final StepCondition notBetween(Supplier<N> minIncluded, Supplier<N> maxExcluded) {
        return LogicalUnaryCondition.negate(this.between(minIncluded, maxExcluded));
    }

    public final StepCondition notBetween(TemporalCondition<N> minIncluded, TemporalCondition<N> maxExcluded) {
        return LogicalUnaryCondition.negate(this.between(minIncluded, maxExcluded));
    }
}

