/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.time;

import io.doov.core.dsl.impl.LocalDateCondition;
import io.doov.core.dsl.impl.TemporalCondition;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.PredicateMetadata;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalUnit;
import java.util.Optional;

public class LocalDateSuppliers {
    private static ThreadLocal<Clock> THREAD_CLOCK = new ThreadLocal();

    private LocalDateSuppliers() {
    }

    public static Clock createClockFrom(LocalDate localDate) {
        LocalDateTime time = LocalDateTime.of(localDate, LocalTime.of(0, 0));
        return Clock.fixed(time.atZone(ZoneId.systemDefault()).toInstant(), ZoneId.systemDefault());
    }

    public static boolean isClockSet() {
        return THREAD_CLOCK.get() != null;
    }

    public static void setClock(Clock clock) {
        THREAD_CLOCK.set(clock);
    }

    public static Clock getClock() {
        return LocalDateSuppliers.isClockSet() ? THREAD_CLOCK.get() : Clock.systemDefaultZone();
    }

    public static void setDefaultClock() {
        THREAD_CLOCK.remove();
    }

    public static TemporalCondition<LocalDate> today() {
        return new LocalDateCondition(null, (PredicateMetadata)LeafMetadata.todayMetadata(), (model, context) -> Optional.of(LocalDate.now(LocalDateSuppliers.getClock())));
    }

    public static TemporalCondition<LocalDate> todayPlus(int amountToAdd, TemporalUnit unit) {
        return new LocalDateCondition(null, (PredicateMetadata)LeafMetadata.todayPlusMetadata(amountToAdd, unit), (model, context) -> Optional.of(LocalDate.now(LocalDateSuppliers.getClock()).plus(amountToAdd, unit)));
    }

    public static TemporalCondition<LocalDate> todayPlusDays(int daysToAdd) {
        return LocalDateSuppliers.todayPlus(daysToAdd, ChronoUnit.DAYS);
    }

    public static TemporalCondition<LocalDate> todayPlusYears(int yearsToAdd) {
        return LocalDateSuppliers.todayPlus(yearsToAdd, ChronoUnit.YEARS);
    }

    public static TemporalCondition<LocalDate> todayMinus(int amountToSubstract, TemporalUnit unit) {
        return new LocalDateCondition(null, (PredicateMetadata)LeafMetadata.todayMinusMetadata(amountToSubstract, unit), (model, context) -> Optional.of(LocalDate.now(LocalDateSuppliers.getClock()).minus(amountToSubstract, unit)));
    }

    public static TemporalCondition<LocalDate> todayMinusDays(int daysToSubstract) {
        return LocalDateSuppliers.todayMinus(daysToSubstract, ChronoUnit.DAYS);
    }

    public static TemporalCondition<LocalDate> todayMinusYears(int yearsToSubstract) {
        return LocalDateSuppliers.todayMinus(yearsToSubstract, ChronoUnit.YEARS);
    }

    public static TemporalCondition<LocalDate> firstDayOfThisMonth() {
        return new LocalDateCondition(null, (PredicateMetadata)LeafMetadata.firstDayOfThisMonthMetadata(), (model, context) -> Optional.of(LocalDate.now(LocalDateSuppliers.getClock()).with(TemporalAdjusters.firstDayOfMonth())));
    }

    public static TemporalCondition<LocalDate> firstDayOfThisYear() {
        return new LocalDateCondition(null, (PredicateMetadata)LeafMetadata.firstDayOfThisYearMetadata(), (model, context) -> Optional.of(LocalDate.now(LocalDateSuppliers.getClock()).with(TemporalAdjusters.firstDayOfYear())));
    }

    public static TemporalCondition<LocalDate> lastDayOfThisMonth() {
        return new LocalDateCondition(null, (PredicateMetadata)LeafMetadata.lastDayOfThisMonthMetadata(), (model, context) -> Optional.of(LocalDate.now(LocalDateSuppliers.getClock()).with(TemporalAdjusters.lastDayOfMonth())));
    }

    public static TemporalCondition<LocalDate> lastDayOfThisYear() {
        return new LocalDateCondition(null, (PredicateMetadata)LeafMetadata.lastDayOfThisYearMetadata(), (model, context) -> Optional.of(LocalDate.now(LocalDateSuppliers.getClock()).with(TemporalAdjusters.lastDayOfYear())));
    }

    public static TemporalCondition<LocalDate> date(int year, int month, int dayOfMonth) {
        return new LocalDateCondition(null, (PredicateMetadata)LeafMetadata.dateMetadata(LocalDate.of(year, month, dayOfMonth)), (model, context) -> Optional.of(LocalDate.of(year, month, dayOfMonth)));
    }
}

