/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.i18n;

import io.doov.core.dsl.meta.Operator;
import io.doov.core.dsl.meta.i18n.ResourceProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;

public enum ResourceBundleProvider implements ResourceProvider
{
    BUNDLE;

    private final List<String> providers = new ArrayList<String>();

    private ResourceBundleProvider() {
        this.register("io.doov.core.dsl.meta.i18n.DefaultResourceBundle");
    }

    public void register(String bundleBaseName) {
        if (!this.providers.contains(bundleBaseName)) {
            this.providers.add(bundleBaseName);
        }
    }

    @Override
    public String get(Operator operator, Locale locale) {
        return this.providers.stream().map(b -> {
            try {
                return ResourceBundle.getBundle(b, locale).getString(operator.name());
            }
            catch (MissingResourceException e) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElse(operator.readable());
    }

    @Override
    public String get(String key, Locale locale) {
        return this.providers.stream().map(b -> {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(b, locale);
                return bundle.getString(key);
            }
            catch (MissingResourceException e) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElse(key);
    }
}

