/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.mapping;

import io.doov.core.FieldModel;
import io.doov.core.dsl.DslField;
import io.doov.core.dsl.lang.MappingRule;
import io.doov.core.dsl.lang.TypeConverter;
import io.doov.core.dsl.meta.MappingMetadata;
import io.doov.core.dsl.meta.MetadataVisitor;
import io.doov.core.dsl.meta.ast.AstVisitorUtils;
import java.util.Locale;

public class SimpleMappingRule<I, O>
implements MappingRule {
    private final MappingMetadata metadata;
    private final DslField<I> inFieldInfo;
    private final DslField<O> outFieldInfo;
    private final TypeConverter<I, O> typeConverter;

    SimpleMappingRule(DslField<I> inFieldInfo, DslField<O> outFieldInfo, TypeConverter<I, O> typeConverter) {
        this.inFieldInfo = inFieldInfo;
        this.outFieldInfo = outFieldInfo;
        this.metadata = MappingMetadata.mapping(inFieldInfo, outFieldInfo);
        this.typeConverter = typeConverter;
    }

    @Override
    public String readable(Locale locale) {
        return AstVisitorUtils.astToString(this, locale);
    }

    @Override
    public void accept(MetadataVisitor visitor, int depth) {
        this.metadata.accept(visitor, depth);
        this.typeConverter.accept(visitor, depth);
    }

    @Override
    public boolean validate(FieldModel inModel, FieldModel outModel) {
        return inModel.getFieldInfos().stream().anyMatch(f -> f.id().equals(this.inFieldInfo.id())) && outModel.getFieldInfos().stream().anyMatch(f -> f.id().equals(this.outFieldInfo.id()));
    }

    @Override
    public void executeOn(FieldModel inModel, FieldModel outModel) {
        outModel.set(this.outFieldInfo.id(), this.typeConverter.convert(inModel, this.inFieldInfo));
    }
}

