/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.mapping;

import io.doov.core.FieldModel;
import io.doov.core.dsl.lang.ConditionalMappingRule;
import io.doov.core.dsl.lang.MappingRule;
import io.doov.core.dsl.lang.StepWhen;
import io.doov.core.dsl.lang.ValidationRule;
import io.doov.core.dsl.mapping.MappingRegistry;
import io.doov.core.dsl.meta.MappingMetadata;
import io.doov.core.dsl.meta.MappingOperator;
import io.doov.core.dsl.meta.MetadataVisitor;
import io.doov.core.dsl.meta.ast.AstVisitorUtils;
import java.util.Locale;

public class DefaultConditionalMappingRule
implements ConditionalMappingRule {
    private final StepWhen stepWhen;
    private final ValidationRule validationRule;
    private final MappingRegistry mappingRules;
    private final MappingRegistry elseMappingRules;

    public DefaultConditionalMappingRule(StepWhen stepWhen, MappingRule ... mappingRules) {
        this(stepWhen, mappingRules, new MappingRule[0]);
    }

    private DefaultConditionalMappingRule(StepWhen stepWhen, MappingRule[] thenRules, MappingRule[] elseRules) {
        this.stepWhen = stepWhen;
        this.validationRule = stepWhen.validate();
        this.mappingRules = MappingRegistry.mappings(thenRules);
        this.elseMappingRules = MappingRegistry.mappings(elseRules);
    }

    private DefaultConditionalMappingRule(StepWhen stepWhen, MappingRegistry thenRules, MappingRule[] elseRules) {
        this.stepWhen = stepWhen;
        this.validationRule = stepWhen.validate();
        this.mappingRules = thenRules;
        this.elseMappingRules = MappingRegistry.mappings(elseRules);
    }

    @Override
    public ValidationRule validation() {
        return this.validationRule;
    }

    @Override
    public ConditionalMappingRule otherwise(MappingRule ... elseRules) {
        return new DefaultConditionalMappingRule(this.stepWhen, this.mappingRules, elseRules);
    }

    @Override
    public boolean validate(FieldModel inModel, FieldModel outModel) {
        return this.mappingRules.validate(inModel, outModel) && this.elseMappingRules.validate(inModel, outModel);
    }

    @Override
    public void executeOn(FieldModel inModel, FieldModel outModel) {
        if (this.validationRule.executeOn(inModel).isTrue()) {
            this.mappingRules.executeOn(inModel, outModel);
        } else if (!this.elseMappingRules.isEmpty()) {
            this.elseMappingRules.executeOn(inModel, outModel);
        }
    }

    @Override
    public String readable(Locale locale) {
        return AstVisitorUtils.astToString(this, locale);
    }

    @Override
    public void accept(MetadataVisitor visitor, int depth) {
        this.stepWhen.accept(visitor, depth);
        MappingMetadata thenMetadata = MappingMetadata.mappings(MappingOperator.then);
        visitor.start(thenMetadata, depth);
        visitor.visit(thenMetadata, depth);
        this.mappingRules.stream().forEach(r -> r.accept(visitor, depth + 1));
        visitor.end(thenMetadata, depth);
        if (!this.elseMappingRules.isEmpty()) {
            MappingMetadata elseMetadata = MappingMetadata.mappings(MappingOperator._else);
            visitor.start(elseMetadata, depth);
            visitor.visit(elseMetadata, depth);
            this.elseMappingRules.stream().forEach(r -> r.accept(visitor, depth + 1));
            visitor.end(elseMetadata, depth);
        }
    }
}

