/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.DslModel;
import io.doov.core.dsl.field.types.NumericFieldInfo;
import io.doov.core.dsl.field.types.TemporalFieldInfo;
import io.doov.core.dsl.impl.DefaultCondition;
import io.doov.core.dsl.impl.IntegerCondition;
import io.doov.core.dsl.impl.LogicalBinaryCondition;
import io.doov.core.dsl.impl.LogicalUnaryCondition;
import io.doov.core.dsl.impl.LongCondition;
import io.doov.core.dsl.impl.NumericCondition;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.PredicateMetadata;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalUnit;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class TemporalCondition<N extends Temporal>
extends DefaultCondition<N> {
    public TemporalCondition(DslField field) {
        super(field);
    }

    public TemporalCondition(DslField field, PredicateMetadata metadata, BiFunction<DslModel, Context, Optional<N>> value) {
        super(field, metadata, value);
    }

    abstract TemporalCondition<N> temporalCondition(DslField var1, PredicateMetadata var2, BiFunction<DslModel, Context, Optional<N>> var3);

    public final TemporalCondition<N> with(io.doov.core.dsl.time.TemporalAdjuster adjuster) {
        return this.temporalCondition(this.field, this.metadata.merge(LeafMetadata.withMetadata(this.field, adjuster.getMetadata())), (model, context) -> this.value((DslModel)model, this.field).map(v -> (Temporal)this.withFunction(adjuster.getAdjuster()).apply(v)));
    }

    abstract Function<N, N> withFunction(TemporalAdjuster var1);

    public final TemporalCondition<N> minus(int value, TemporalUnit unit) {
        return this.temporalCondition(this.field, this.metadata.merge(LeafMetadata.minusMetadata(this.field, value, (Object)unit)), (model, context) -> this.value((DslModel)model, this.field).map(v -> (Temporal)this.minusFunction(value, unit).apply(v)));
    }

    public final TemporalCondition<N> minus(NumericFieldInfo<Integer> value, TemporalUnit unit) {
        return this.temporalCondition(this.field, this.metadata.merge(LeafMetadata.minusMetadata(this.field, value, (Object)unit)), (model, context) -> this.value((DslModel)model, this.field).flatMap(l -> Optional.ofNullable(model.get(value.id())).map(r -> (Temporal)this.minusFunction((int)r, unit).apply(l))));
    }

    abstract Function<N, N> minusFunction(int var1, TemporalUnit var2);

    public final TemporalCondition<N> plus(int value, TemporalUnit unit) {
        return this.temporalCondition(this.field, this.metadata.merge(LeafMetadata.plusMetadata(this.field, value, (Object)unit)), (model, context) -> this.value((DslModel)model, this.field).map(v -> (Temporal)this.plusFunction(value, unit).apply(v)));
    }

    public final TemporalCondition<N> plus(NumericFieldInfo<Integer> value, TemporalUnit unit) {
        return this.temporalCondition(this.field, this.metadata.merge(LeafMetadata.plusMetadata(this.field, value, (Object)unit)), (model, context) -> this.value((DslModel)model, this.field).flatMap(l -> Optional.ofNullable(model.get(value.id())).map(r -> (Temporal)this.plusFunction((int)r, unit).apply(l))));
    }

    abstract Function<N, N> plusFunction(int var1, TemporalUnit var2);

    @Override
    public final StepCondition eq(TemporalCondition<N> value) {
        return this.predicate(LeafMetadata.equalsMetadata(this.field, value), value.function, Object::equals);
    }

    public final StepCondition before(N value) {
        return this.predicate(LeafMetadata.beforeValueMetadata(this, value), (model, context) -> Optional.ofNullable(value), (l, r) -> this.beforeFunction().apply(l, r));
    }

    public final StepCondition before(TemporalFieldInfo<N> value) {
        return this.predicate(LeafMetadata.beforeTemporalFieldMetadata(this, value), (model, context) -> this.value((DslModel)model, value), (l, r) -> this.beforeFunction().apply(l, r));
    }

    public final StepCondition before(Supplier<N> value) {
        return this.predicate(LeafMetadata.beforeSupplierMetadata(this, value), (model, context) -> Optional.ofNullable(value.get()), (l, r) -> this.beforeFunction().apply(l, r));
    }

    public final StepCondition before(TemporalCondition<N> value) {
        return this.predicate(LeafMetadata.beforeTemporalConditionMetadata(this, value), value.function, (l, r) -> this.beforeFunction().apply(l, r));
    }

    public final StepCondition beforeOrEq(N value) {
        return this.predicate(LeafMetadata.beforeOrEqualsValueMetadata(this, value), (model, context) -> Optional.ofNullable(value), (l, r) -> this.beforeOrEqualsFunction().apply(l, r));
    }

    public final StepCondition beforeOrEq(Supplier<N> value) {
        return this.predicate(LeafMetadata.beforeOrEqualsSupplierMetadata(this, value), (model, context) -> Optional.ofNullable(value.get()), (l, r) -> this.beforeOrEqualsFunction().apply(l, r));
    }

    public final StepCondition beforeOrEq(TemporalCondition<N> value) {
        return this.predicate(LeafMetadata.beforeOrEqualsTemporalConditionMetadata(this, value), value.function, (l, r) -> this.beforeOrEqualsFunction().apply(l, r));
    }

    abstract BiFunction<N, N, Boolean> beforeFunction();

    abstract BiFunction<N, N, Boolean> beforeOrEqualsFunction();

    public final StepCondition after(N value) {
        return this.predicate(LeafMetadata.afterValueMetadata(this, value), (model, context) -> Optional.ofNullable(value), (l, r) -> this.afterFunction().apply(l, r));
    }

    public final StepCondition after(TemporalFieldInfo<N> value) {
        return this.predicate(LeafMetadata.afterTemporalFieldMetadata(this, value), (model, context) -> this.value((DslModel)model, value), (l, r) -> this.afterFunction().apply(l, r));
    }

    public final StepCondition after(Supplier<N> value) {
        return this.predicate(LeafMetadata.afterSupplierMetadata(this, value), (model, context) -> Optional.ofNullable(value.get()), (l, r) -> this.afterFunction().apply(l, r));
    }

    public final StepCondition after(TemporalCondition<N> value) {
        return this.predicate(LeafMetadata.afterTemporalConditionMetadata(this, value), value.function, (l, r) -> this.afterFunction().apply(l, r));
    }

    public final StepCondition afterOrEq(N value) {
        return this.predicate(LeafMetadata.afterOrEqualsValueMetadata(this, value), (model, context) -> Optional.ofNullable(value), (l, r) -> this.afterOrEqualsFunction().apply(l, r));
    }

    public final StepCondition afterOrEq(Supplier<N> value) {
        return this.predicate(LeafMetadata.afterOrEqualsSupplierMetadata(this, value), (model, context) -> Optional.ofNullable(value.get()), (l, r) -> this.afterOrEqualsFunction().apply(l, r));
    }

    public final StepCondition afterOrEq(TemporalCondition<N> value) {
        return this.predicate(LeafMetadata.afterOrEqualsTemporalConditionMetadata(this, value), value.function, (l, r) -> this.afterOrEqualsFunction().apply(l, r));
    }

    abstract BiFunction<N, N, Boolean> afterFunction();

    abstract BiFunction<N, N, Boolean> afterOrEqualsFunction();

    public final StepCondition between(N minIncluded, N maxExcluded) {
        return LogicalBinaryCondition.and(this.beforeOrEq(maxExcluded), this.afterOrEq(minIncluded));
    }

    public final StepCondition between(Supplier<N> minIncluded, Supplier<N> maxExcluded) {
        return LogicalBinaryCondition.and(this.beforeOrEq(maxExcluded), this.afterOrEq(minIncluded));
    }

    public final StepCondition between(TemporalCondition<N> minIncluded, TemporalCondition<N> maxExcluded) {
        return LogicalBinaryCondition.and(this.beforeOrEq(maxExcluded), this.afterOrEq(minIncluded));
    }

    public final StepCondition notBetween(N minIncluded, N maxExcluded) {
        return LogicalUnaryCondition.negate(this.between(minIncluded, maxExcluded));
    }

    public final StepCondition notBetween(Supplier<N> minIncluded, Supplier<N> maxExcluded) {
        return LogicalUnaryCondition.negate(this.between(minIncluded, maxExcluded));
    }

    public final StepCondition notBetween(TemporalCondition<N> minIncluded, TemporalCondition<N> maxExcluded) {
        return LogicalUnaryCondition.negate(this.between(minIncluded, maxExcluded));
    }

    public final NumericCondition<Integer> ageAt(N value) {
        return new IntegerCondition(this.timeBetween((PredicateMetadata)LeafMetadata.ageAtValueMetadata(this, value), ChronoUnit.YEARS, value));
    }

    public final NumericCondition<Integer> ageAt(TemporalFieldInfo<N> value) {
        return new IntegerCondition(this.timeBetween((PredicateMetadata)LeafMetadata.ageAtTemporalFieldMetadata(this, value), ChronoUnit.YEARS, value));
    }

    public final NumericCondition<Integer> ageAt(TemporalCondition<N> value) {
        return new IntegerCondition(this.timeBetween((PredicateMetadata)LeafMetadata.ageAtTemporalConditionMetadata(this, value), ChronoUnit.YEARS, value));
    }

    public final NumericCondition<Integer> ageAt(Supplier<N> value) {
        return new IntegerCondition(this.timeBetween((PredicateMetadata)LeafMetadata.ageAtSupplierMetadata(this, value), ChronoUnit.YEARS, value));
    }

    public final NumericCondition<Integer> daysBetween(N value) {
        return new IntegerCondition(this.timeBetween((PredicateMetadata)LeafMetadata.ageAtValueMetadata(this, value), ChronoUnit.DAYS, value));
    }

    public final NumericCondition<Integer> daysBetween(TemporalFieldInfo<N> value) {
        return new IntegerCondition(this.timeBetween((PredicateMetadata)LeafMetadata.ageAtTemporalFieldMetadata(this, value), ChronoUnit.DAYS, value));
    }

    public final NumericCondition<Integer> daysBetween(TemporalCondition<N> value) {
        return new IntegerCondition(this.timeBetween((PredicateMetadata)LeafMetadata.ageAtTemporalConditionMetadata(this, value), ChronoUnit.DAYS, value));
    }

    public final NumericCondition<Integer> daysBetween(Supplier<N> value) {
        return new IntegerCondition(this.timeBetween((PredicateMetadata)LeafMetadata.ageAtSupplierMetadata(this, value), ChronoUnit.DAYS, value));
    }

    public final NumericCondition<Integer> monthsBetween(N value) {
        return new IntegerCondition(this.timeBetween((PredicateMetadata)LeafMetadata.ageAtValueMetadata(this, value), ChronoUnit.MONTHS, value));
    }

    public final NumericCondition<Integer> monthsBetween(TemporalFieldInfo<N> value) {
        return new IntegerCondition(this.timeBetween((PredicateMetadata)LeafMetadata.ageAtTemporalFieldMetadata(this, value), ChronoUnit.MONTHS, value));
    }

    public final NumericCondition<Integer> monthsBetween(TemporalCondition<N> value) {
        return new IntegerCondition(this.timeBetween((PredicateMetadata)LeafMetadata.ageAtTemporalConditionMetadata(this, value), ChronoUnit.MONTHS, value));
    }

    public final NumericCondition<Integer> monthsBetween(Supplier<N> value) {
        return new IntegerCondition(this.timeBetween((PredicateMetadata)LeafMetadata.ageAtSupplierMetadata(this, value), ChronoUnit.MONTHS, value));
    }

    public final NumericCondition<Integer> yearsBetween(N value) {
        return new IntegerCondition(this.timeBetween((PredicateMetadata)LeafMetadata.ageAtValueMetadata(this, value), ChronoUnit.YEARS, value));
    }

    public final NumericCondition<Integer> yearsBetween(TemporalFieldInfo<N> value) {
        return new IntegerCondition(this.timeBetween((PredicateMetadata)LeafMetadata.ageAtTemporalFieldMetadata(this, value), ChronoUnit.YEARS, value));
    }

    public final NumericCondition<Integer> yearsBetween(TemporalCondition<N> value) {
        return new IntegerCondition(this.timeBetween((PredicateMetadata)LeafMetadata.ageAtTemporalConditionMetadata(this, value), ChronoUnit.YEARS, value));
    }

    public final NumericCondition<Integer> yearsBetween(Supplier<N> value) {
        return new IntegerCondition(this.timeBetween((PredicateMetadata)LeafMetadata.ageAtSupplierMetadata(this, value), ChronoUnit.YEARS, value));
    }

    private NumericCondition<Long> timeBetween(PredicateMetadata metadata, ChronoUnit unit, N value) {
        return new LongCondition(this.field, metadata, (model, context) -> this.value((DslModel)model, this.field).flatMap(l -> Optional.ofNullable(value).map(r -> this.betweenFunction(unit).apply(l, r))));
    }

    private NumericCondition<Long> timeBetween(PredicateMetadata metadata, ChronoUnit unit, TemporalFieldInfo<N> value) {
        return new LongCondition(this.field, metadata, (model, context) -> this.value((DslModel)model, this.field).flatMap(l -> this.valueModel((DslModel)model, value).map(r -> this.betweenFunction(unit).apply(l, r))));
    }

    private NumericCondition<Long> timeBetween(PredicateMetadata metadata, ChronoUnit unit, TemporalCondition<N> value) {
        return new LongCondition(this.field, metadata, (model, context) -> this.value((DslModel)model, this.field).flatMap(l -> ((Optional)value.function.apply(model, context)).map(r -> this.betweenFunction(unit).apply(l, r))));
    }

    private NumericCondition<Long> timeBetween(PredicateMetadata metadata, ChronoUnit unit, Supplier<N> value) {
        return new LongCondition(this.field, metadata, (model, context) -> this.value((DslModel)model, this.field).flatMap(arg_0 -> this.lambda$null$46((Supplier)value, unit, arg_0)));
    }

    abstract BiFunction<N, N, Long> betweenFunction(ChronoUnit var1);

    private /* synthetic */ Optional lambda$null$46(Supplier value, ChronoUnit unit, Temporal l) {
        return Optional.ofNullable(value.get()).map(r -> this.betweenFunction(unit).apply(l, r));
    }
}

