/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.field.types.NumericFieldInfo;
import io.doov.core.dsl.impl.DefaultCondition;
import io.doov.core.dsl.impl.DefaultStepCondition;
import io.doov.core.dsl.impl.DefaultStepWhen;
import io.doov.core.dsl.impl.IntegerCondition;
import io.doov.core.dsl.impl.LogicalNaryCondition;
import io.doov.core.dsl.impl.LogicalUnaryCondition;
import io.doov.core.dsl.impl.NumericCondition;
import io.doov.core.dsl.lang.MappingRule;
import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.lang.StepWhen;
import io.doov.core.dsl.mapping.BiStepMap;
import io.doov.core.dsl.mapping.MappingRegistry;
import io.doov.core.dsl.mapping.NaryStepMap;
import io.doov.core.dsl.mapping.SimpleStepMap;
import io.doov.core.dsl.mapping.StaticStepMap;
import io.doov.core.dsl.meta.LeafMetadata;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class DOOV {
    private DOOV() {
    }

    public static StepWhen when(StepCondition condition) {
        return new DefaultStepWhen(condition);
    }

    public static StepCondition alwaysTrue() {
        return new DefaultStepCondition(LeafMetadata.trueMetadata(), (model, context) -> true);
    }

    public static StepCondition alwaysFalse() {
        return new DefaultStepCondition(LeafMetadata.falseMetadata(), (model, context) -> false);
    }

    public static IntegerCondition count(StepCondition ... steps) {
        return LogicalNaryCondition.count(Arrays.asList(steps));
    }

    public static StepCondition matchAny(StepCondition ... steps) {
        return LogicalNaryCondition.matchAny(Arrays.asList(steps));
    }

    public static StepCondition not(StepCondition step) {
        return LogicalUnaryCondition.negate(step);
    }

    public static StepCondition matchAny(Stream<? extends DslField<?>> dslFields, Function<DefaultCondition, StepCondition> stepConditionFunction) {
        return LogicalNaryCondition.matchAny(dslFields.filter(Objects::nonNull).map(DslField::getDefaultCondition).map(stepConditionFunction).collect(Collectors.toList()));
    }

    public static StepCondition matchAll(StepCondition ... steps) {
        return LogicalNaryCondition.matchAll(Arrays.asList(steps));
    }

    public static StepCondition matchAll(Stream<? extends DslField<?>> dslFields, Function<DefaultCondition, StepCondition> stepConditionFunction) {
        return LogicalNaryCondition.matchAll(dslFields.filter(Objects::nonNull).map(DslField::getDefaultCondition).map(stepConditionFunction).collect(Collectors.toList()));
    }

    public static StepCondition matchNone(StepCondition ... steps) {
        return LogicalNaryCondition.matchNone(Arrays.asList(steps));
    }

    public static StepCondition matchNone(Stream<? extends DslField<?>> dslFields, Function<DefaultCondition, StepCondition> stepConditionFunction) {
        return LogicalNaryCondition.matchNone(dslFields.filter(Objects::nonNull).map(DslField::getDefaultCondition).map(stepConditionFunction).collect(Collectors.toList()));
    }

    public static <I> SimpleStepMap<I> map(DslField<I> inFieldInfo) {
        return new SimpleStepMap<I>(inFieldInfo);
    }

    public static <I, J> BiStepMap<I, J> map(DslField<I> inFieldInfo, DslField<J> in2FieldInfo) {
        return new BiStepMap<I, J>(inFieldInfo, in2FieldInfo);
    }

    public static NaryStepMap map(DslField<?> ... inFieldInfos) {
        return new NaryStepMap(Arrays.asList(inFieldInfos));
    }

    public static NaryStepMap map(Stream<? extends DslField<?>> inFieldInfos) {
        return new NaryStepMap(inFieldInfos.collect(Collectors.toList()));
    }

    public static <I> StaticStepMap<I> map(Supplier<I> valueSupplier) {
        return new StaticStepMap<I>(valueSupplier);
    }

    public static <I> StaticStepMap<I> map(I value) {
        return new StaticStepMap<Object>(() -> value);
    }

    public static MappingRegistry mapRange(int startInclusive, int endExclusive, Function<Integer, MappingRule> mappingRuleFunction) {
        return MappingRegistry.mappings((MappingRule[])IntStream.range(startInclusive, endExclusive).mapToObj(mappingRuleFunction::apply).toArray(MappingRule[]::new));
    }

    public static MappingRegistry mapFor(Stream<? extends DslField<?>> fieldStream, Function<DslField<?>, MappingRule> mappingRuleFunction) {
        return MappingRegistry.mappings((MappingRule[])fieldStream.filter(Objects::nonNull).map(mappingRuleFunction::apply).toArray(MappingRule[]::new));
    }

    public static <T extends DslField<?>> T fieldInPosition(Stream<T> fieldStream, int index) {
        return (T)fieldStream.filter(Objects::nonNull).filter(f -> f.id().position() == index).findFirst().orElseThrow(() -> new IllegalArgumentException("Field with position " + index + " not found."));
    }

    @SafeVarargs
    public static <N extends Number> NumericCondition<N> min(NumericFieldInfo<N> ... fields) {
        return Arrays.stream(fields).filter(Objects::nonNull).findFirst().map(NumericFieldInfo::getNumericCondition).map(c -> c.min(Arrays.asList(fields))).orElseThrow(IllegalArgumentException::new);
    }

    @SafeVarargs
    public static <N extends Number> NumericCondition<N> sum(NumericFieldInfo<N> ... fields) {
        return Arrays.stream(fields).filter(Objects::nonNull).findFirst().map(NumericFieldInfo::getNumericCondition).map(c -> c.sum(Arrays.asList(fields))).orElseThrow(IllegalArgumentException::new);
    }

    @SafeVarargs
    public static <N extends Number> NumericCondition<N> sum(NumericCondition<N> ... conditions) {
        return Arrays.stream(conditions).filter(Objects::nonNull).findFirst().map(c -> c.sumConditions(Arrays.asList(conditions))).orElseThrow(IllegalArgumentException::new);
    }
}

