/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.lang.StepWhen;
import io.doov.core.dsl.meta.BinaryMetadata;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.NaryMetadata;
import io.doov.core.dsl.meta.PredicateMetadata;
import io.doov.core.dsl.meta.ast.AstLineVisitor;
import io.doov.core.dsl.meta.i18n.ResourceProvider;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class AstLinePercentVisitor
extends AstLineVisitor {
    private static final NumberFormat formatter = new DecimalFormat("###.#");

    public AstLinePercentVisitor(StringBuilder stringBuilder, ResourceProvider bundle, Locale locale) {
        super(stringBuilder, bundle, locale);
    }

    @Override
    public void startMetadata(StepWhen metadata, int depth) {
        this.sb.append(this.percentage((PredicateMetadata)metadata.stepCondition().getMetadata()) + " ");
        super.startMetadata(metadata, depth);
    }

    @Override
    public void startMetadata(BinaryMetadata metadata, int depth) {
        super.startMetadata(metadata, depth);
        if (metadata.children().get(0).type() == MetadataType.NARY_PREDICATE) {
            this.sb.append(this.percentage(metadata));
        }
    }

    @Override
    public void startMetadata(NaryMetadata metadata, int depth) {
        if (metadata.getOperator() != DefaultOperator.count && metadata.getOperator() != DefaultOperator.sum) {
            this.sb.append(this.percentage(metadata));
        }
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
        this.sb.append(this.formatNewLine());
        this.sb.append("[");
    }

    @Override
    protected String formatLeafMetadata(LeafMetadata metadata) {
        if (this.stackPeek() == MetadataType.BINARY_PREDICATE) {
            return super.formatLeafMetadata(metadata);
        }
        return this.percentage(metadata) + super.formatLeafMetadata(metadata);
    }

    private String percentage(PredicateMetadata metadata) {
        int t = metadata.trueEvalCount();
        int f = metadata.falseEvalCount();
        if (f == 0 && t == 0) {
            return "[n/a]";
        }
        return "[" + formatter.format((double)t / ((double)t + (double)f) * 100.0) + "]";
    }
}

