/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl;

import io.doov.core.dsl.DslModel;
import io.doov.core.dsl.impl.DefaultContext;
import io.doov.core.dsl.impl.DefaultResult;
import io.doov.core.dsl.lang.Result;
import io.doov.core.dsl.lang.RuleRegistry;
import io.doov.core.dsl.lang.StepWhen;
import io.doov.core.dsl.lang.ValidationRule;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataVisitor;
import io.doov.core.dsl.meta.ast.AstVisitorUtils;
import java.util.Locale;

public class DefaultValidationRule
implements ValidationRule {
    private final StepWhen stepWhen;
    private final boolean shortCircuit;

    public DefaultValidationRule(StepWhen stepWhen) {
        this(stepWhen, true);
    }

    public DefaultValidationRule(StepWhen stepWhen, boolean shortCircuit) {
        this.stepWhen = stepWhen;
        this.shortCircuit = shortCircuit;
    }

    protected boolean isShortCircuit() {
        return this.shortCircuit;
    }

    protected StepWhen getStepWhen() {
        return this.stepWhen;
    }

    @Override
    public ValidationRule withShortCircuit(boolean shortCircuit) {
        return new DefaultValidationRule(this.stepWhen, shortCircuit);
    }

    @Override
    public Result executeOn(DslModel model) {
        DefaultContext context = new DefaultContext(this.shortCircuit, this.stepWhen.stepCondition().getMetadata());
        boolean valid = this.stepWhen.stepCondition().predicate().test(model, context);
        return new DefaultResult(valid, context);
    }

    @Override
    public ValidationRule registerOn(RuleRegistry registry) {
        registry.register(this);
        return this;
    }

    @Override
    public String readable(Locale locale) {
        return AstVisitorUtils.astToString(this, locale);
    }

    @Override
    public void accept(MetadataVisitor visitor, int depth) {
        visitor.start(this, depth);
        this.stepWhen.accept(visitor, depth);
        visitor.visit(this, depth);
        visitor.end(this, depth);
    }

    @Override
    public Metadata getRootMetadata() {
        if (this.stepWhen == null) {
            return null;
        }
        if (this.stepWhen.stepCondition() == null) {
            return null;
        }
        return this.stepWhen.stepCondition().getMetadata();
    }
}

