/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core;

import io.doov.core.FieldId;
import io.doov.core.FieldInfo;
import io.doov.core.TagId;
import io.doov.core.dsl.DslModel;
import io.doov.core.serial.StringMapper;
import io.doov.core.serial.TypeAdapter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface FieldModel
extends Iterable<Map.Entry<FieldId, Object>>,
DslModel,
StringMapper {
    @Override
    public <T> T get(FieldId var1);

    @Override
    public <T> void set(FieldId var1, T var2);

    public Stream<Map.Entry<FieldId, Object>> stream();

    @Override
    public Spliterator<Map.Entry<FieldId, Object>> spliterator();

    public Stream<Map.Entry<FieldId, Object>> parallelStream();

    public List<FieldInfo> getFieldInfos();

    default public List<FieldId> getFieldIds() {
        return this.getFieldInfos().stream().map(FieldInfo::id).collect(Collectors.toList());
    }

    default public void setAll(FieldModel source) {
        this.getFieldInfos().stream().filter(info -> source.get(info.id()) != null).forEach(info -> this.set(info.id(), source.get(info.id())));
    }

    default public void clear() {
        this.getFieldInfos().stream().filter(info -> this.get(info.id()) != null).forEach(info -> this.set(info.id(), null));
    }

    default public void clear(TagId tag) {
        this.getFieldInfos().stream().filter(info -> info.id().hasTag(tag) && this.get(info.id()) != null).forEach(info -> this.set(info.id(), null));
    }

    default public FieldInfo info(FieldId id) {
        return this.getFieldInfos().stream().filter(info -> info.id() == id).findFirst().orElse(null);
    }

    @Override
    default public String getAsString(FieldId fieldId) {
        Object value = this.get(fieldId);
        if (value == null) {
            return null;
        }
        return this.getTypeAdapterRegistry().stream().filter(a -> a.accept(value)).findFirst().map(a -> a.toString(value)).orElse(null);
    }

    @Override
    default public String getAsString(FieldInfo info) {
        Objects.requireNonNull(info);
        return this.getAsString(info.id());
    }

    @Override
    default public void setAsString(FieldId fieldId, String value) {
        FieldInfo fieldInfo = this.info(fieldId);
        this.setAsString(fieldInfo, value);
    }

    @Override
    default public void setAsString(FieldInfo fieldInfo, String value) {
        Objects.requireNonNull(fieldInfo);
        if (value == null) {
            this.set(fieldInfo.id(), null);
        } else {
            TypeAdapter typeAdapter = this.getTypeAdapterRegistry().stream().filter(a -> a.accept(fieldInfo)).findFirst().orElseThrow(() -> new IllegalStateException("cannot set field " + fieldInfo.id() + " with value " + value));
            this.set(fieldInfo.id(), typeAdapter.fromString(fieldInfo, value));
        }
    }
}

