/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.lang.Readable;
import io.doov.core.dsl.lang.StepWhen;
import io.doov.core.dsl.lang.ValidationRule;
import io.doov.core.dsl.meta.BinaryMetadata;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.NaryMetadata;
import io.doov.core.dsl.meta.Operator;
import io.doov.core.dsl.meta.UnaryMetadata;
import io.doov.core.dsl.meta.ast.AbstractAstVisitor;
import io.doov.core.dsl.meta.ast.ResourceProvider;
import java.util.Locale;
import java.util.stream.Collectors;

public class AstTextVisitor
extends AbstractAstVisitor {
    private static final int INDENT_SIZE = 2;
    protected final StringBuilder sb;
    protected final ResourceProvider bundle;
    protected final Locale locale;
    protected int newLineIndex = 0;

    public AstTextVisitor(StringBuilder sb, ResourceProvider bundle, Locale locale) {
        this.sb = sb;
        this.bundle = bundle;
        this.locale = locale;
    }

    protected int getNewLineIndex() {
        return this.newLineIndex;
    }

    @Override
    protected String formatNewLine() {
        this.newLineIndex = this.sb.length();
        return "\n";
    }

    @Override
    public void visitMetadata(LeafMetadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(this.formatLeafMetadata(metadata));
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void visitMetadata(UnaryMetadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void visitMetadata(BinaryMetadata metadata, int depth) {
        this.sb.delete(this.getNewLineIndex(), this.sb.length());
        this.sb.append(" ");
        this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void startMetadata(NaryMetadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void startMetadata(ValidationRule metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(this.formatRule());
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void visitMetadata(ValidationRule metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(this.formatValidateWithMessage());
        this.sb.append(" ");
        this.sb.append(this.formatMessage(metadata));
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void startMetadata(StepWhen metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(this.formatWhen());
        this.sb.append(this.formatNewLine());
    }

    @Override
    protected int getIndentSize() {
        return 2;
    }

    @Override
    protected int getCurrentIndentSize() {
        if (MetadataType.BINARY_PREDICATE.equals((Object)this.stackPeek())) {
            return (int)this.stackSteam().filter(e -> !MetadataType.BINARY_PREDICATE.equals(e)).count() * this.getIndentSize();
        }
        return super.getCurrentIndentSize();
    }

    protected String formatLeafMetadata(LeafMetadata metadata) {
        return metadata.stream().map(e -> {
            switch (e.getType()) {
                case OPERATOR: {
                    return this.bundle.get((Operator)e.getReadable(), this.locale);
                }
                case FIELD: {
                    return e.getReadable().readable();
                }
                case STRING_VALUE: {
                    return "'" + this.bundle.get(e.getReadable().readable(), this.locale) + "'";
                }
            }
            return this.bundle.get(e.getReadable().readable(), this.locale);
        }).collect(Collectors.joining(" "));
    }

    protected String formatOperator(Operator operator) {
        return operator == null ? null : operator.readable();
    }

    protected String formatValue(Readable value) {
        return value == null ? null : value.readable();
    }

    protected String formatRule() {
        return this.bundle.get(DefaultOperator.rule, this.locale);
    }

    protected String formatValidateWithMessage() {
        return this.bundle.get(DefaultOperator.validate_with_message, this.locale);
    }

    protected String formatMessage(ValidationRule metadata) {
        String message = metadata.getMessage() == null ? this.bundle.get(DefaultOperator.empty, this.locale) : metadata.getMessage();
        return "'" + message + "'";
    }

    protected String formatWhen() {
        return this.bundle.get(DefaultOperator.when, this.locale);
    }
}

