/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.lang.ValidationRule;
import io.doov.core.dsl.meta.BinaryMetadata;
import io.doov.core.dsl.meta.NaryMetadata;
import io.doov.core.dsl.meta.ast.AstTextVisitor;
import io.doov.core.dsl.meta.ast.ResourceProvider;
import java.util.Locale;

public class AstLineVisitor
extends AstTextVisitor {
    public AstLineVisitor(StringBuilder stringBuilder, ResourceProvider bundle, Locale locale) {
        super(stringBuilder, bundle, locale);
    }

    @Override
    protected String formatCurrentIndent() {
        return "";
    }

    @Override
    protected String formatNewLine() {
        return " ";
    }

    @Override
    public void startMetadata(NaryMetadata metadata, int depth) {
        super.startMetadata(metadata, depth);
        this.sb.append("[");
    }

    @Override
    public void visitMetadata(NaryMetadata metadata, int depth) {
        super.visitMetadata(metadata, depth);
        this.sb.delete(this.sb.length() - 1, this.sb.length());
        this.sb.append(", ");
    }

    @Override
    protected void endMetadata(NaryMetadata metadata, int depth) {
        super.endMetadata(metadata, depth);
        this.sb.delete(this.sb.length() - 2, this.sb.length());
        this.sb.append("] ");
    }

    @Override
    protected void startMetadata(BinaryMetadata metadata, int depth) {
        super.startMetadata(metadata, depth);
        this.sb.append(depth > 0 ? "(" : "");
    }

    @Override
    public void visitMetadata(BinaryMetadata metadata, int depth) {
        this.sb.append(this.bundle.get(metadata.getOperator(), this.locale));
        this.sb.append(this.formatNewLine());
    }

    @Override
    protected void endMetadata(BinaryMetadata metadata, int depth) {
        super.endMetadata(metadata, depth);
        this.sb.delete(this.sb.length() - 1, this.sb.length());
        this.sb.append(depth > 0 ? ") " : " ");
    }

    @Override
    protected void endMetadata(ValidationRule metadata, int depth) {
        super.endMetadata(metadata, depth);
        this.sb.append("\n");
    }
}

