/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.lang.StepWhen;
import io.doov.core.dsl.lang.ValidationRule;
import io.doov.core.dsl.meta.BinaryMetadata;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.Element;
import io.doov.core.dsl.meta.ElementType;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.NaryMetadata;
import io.doov.core.dsl.meta.Operator;
import io.doov.core.dsl.meta.UnaryMetadata;
import io.doov.core.dsl.meta.ast.AbstractAstVisitor;
import io.doov.core.dsl.meta.ast.ResourceProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.text.StringEscapeUtils;

public class AstHtmlVisitor
extends AbstractAstVisitor {
    private static final String CSS_CLASS_VALIDATION_MESSAGE = "dsl-validation-message";
    private static final String CSS_CLASS_VALIDATION_RULE = "dsl-validation-rule";
    private static final String CSS_CLASS_VALIDATE = "dsl-token-validate";
    private static final String CSS_CLASS_BINARY = "dsl-token-binary";
    private static final String CSS_CLASS_UNARY = "dsl-token-unary";
    private static final String CSS_CLASS_NARY = "dsl-token-nary";
    private static final String CSS_CLASS_WHEN = "dsl-token-when";
    private static final String END_DIV = "</div>";
    private static final String BEG_LI = "<li>";
    private static final String END_LI = "</li>";
    private static final String BEG_OL = "<ol>";
    private static final String END_OL = "</ol>";
    private static final String BEG_UL = "<ul>";
    private static final String END_UL = "</ul>";
    private static final List<Operator> operatorList = Arrays.asList(DefaultOperator.greater_or_equals, DefaultOperator.greater_than, DefaultOperator.equals, DefaultOperator.not_equals, DefaultOperator.lesser_or_equals, DefaultOperator.lesser_than);
    private int binaryDeep = 0;
    private boolean endOfSum;
    private final String[] lastLines = new String[3];
    private final OutputStream ops;
    protected final ResourceProvider bundle;
    protected Locale locale;
    private boolean nextBinary;
    private boolean noLiNary = false;

    public AstHtmlVisitor(OutputStream ops, ResourceProvider bundle, Locale locale) {
        this.ops = ops;
        this.bundle = bundle;
        this.locale = locale;
    }

    @Override
    public void startMetadata(StepWhen metadata, int depth) {
        this.writeWithBuffer(this.formatNewLine());
        this.writeWithBuffer(this.formatCurrentIndent());
    }

    @Override
    public void visitMetadata(StepWhen metadata, int depth) {
        this.htmlFormatSpan(CSS_CLASS_WHEN, this.formatWhen());
        this.writeWithBuffer(this.formatNewLine());
        this.writeWithBuffer(this.formatCurrentIndent());
        this.writeWithBuffer(BEG_UL);
        this.writeWithBuffer(this.formatNewLine());
    }

    @Override
    public void endMetadata(StepWhen metadata, int depth) {
        this.writeWithBuffer(this.formatCurrentIndent());
        this.writeWithBuffer(END_UL);
        this.writeWithBuffer(this.formatNewLine());
    }

    @Override
    public void startMetadata(LeafMetadata metadata, int depth) {
        this.writeWithBuffer(this.formatCurrentIndent());
        if (!(this.lastLines[0].contains(">" + this.bundle.get(DefaultOperator.and, this.locale) + "<") || this.lastLines[0].contains(">" + this.bundle.get(DefaultOperator.or, this.locale) + "<") || this.endOfSum)) {
            this.writeWithBuffer(BEG_LI);
        }
    }

    @Override
    public void visitMetadata(LeafMetadata leaf, int depth) {
        leaf.stream().forEach(e -> {
            switch (e.getType()) {
                case PARENTHESIS_LEFT: 
                case PARENTHESIS_RIGHT: {
                    this.formatParenthesis((Element)e);
                    break;
                }
                case OPERATOR: {
                    this.formatLeafOperator((Element)e);
                    break;
                }
                case TEMPORAL_UNIT: {
                    this.formatTemporalUnit((Element)e);
                    break;
                }
                case FIELD: {
                    this.formatLeafField((Element)e);
                    break;
                }
                case VALUE: 
                case STRING_VALUE: {
                    this.formatLeafValue((Element)e);
                    break;
                }
                case UNKNOWN: {
                    this.formatLeafUnknown((Element)e);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown element type " + (Object)((Object)e.getType()));
                }
            }
        });
    }

    @Override
    public void endMetadata(LeafMetadata metadata, int depth) {
        if (this.endOfSum) {
            this.writeWithBuffer("</br>");
            this.endOfSum = false;
        }
        this.writeWithBuffer(this.formatNewLine());
    }

    @Override
    public void startMetadata(BinaryMetadata metadata, int depth) {
        if (this.stackPeek() == MetadataType.BINARY_PREDICATE && this.nextBinary) {
            this.writeWithBuffer(this.formatCurrentIndent());
            this.writeWithBuffer(BEG_UL);
            this.writeWithBuffer(this.formatNewLine());
            ++this.binaryDeep;
            this.nextBinary = false;
        }
        if (metadata.getRight().type() == MetadataType.BINARY_PREDICATE) {
            this.nextBinary = true;
        }
    }

    @Override
    public void visitMetadata(BinaryMetadata metadata, int depth) {
        this.writeWithBuffer(this.formatCurrentIndent());
        if (metadata.getLeft().type() != MetadataType.NARY_PREDICATE) {
            this.writeWithBuffer("<br>");
        }
        if (metadata.getRight().type() == MetadataType.NARY_PREDICATE || metadata.getRight().type() == MetadataType.UNARY_PREDICATE) {
            this.noLiNary = true;
        }
        this.htmlFormatSpan(CSS_CLASS_BINARY, StringEscapeUtils.escapeHtml4((String)this.bundle.get(metadata.getOperator(), this.locale)));
        if (operatorList.contains(metadata.getOperator())) {
            this.endOfSum = true;
        }
        this.writeWithBuffer(this.formatNewLine());
    }

    @Override
    public void endMetadata(BinaryMetadata metadata, int depth) {
        if (this.binaryDeep > 0) {
            this.writeWithBuffer(this.formatNewLine());
            this.writeWithBuffer(this.formatCurrentIndent());
            this.writeWithBuffer(END_UL);
            --this.binaryDeep;
        }
    }

    @Override
    public void startMetadata(NaryMetadata metadata, int depth) {
        this.writeWithBuffer(this.formatCurrentIndent());
        if (!this.noLiNary) {
            this.writeWithBuffer(BEG_LI);
            this.noLiNary = false;
        }
        this.writeWithBuffer(this.formatNewLine());
        this.writeWithBuffer(this.formatCurrentIndent());
        this.htmlFormatSpan(CSS_CLASS_NARY, StringEscapeUtils.escapeHtml4((String)this.bundle.get(metadata.getOperator(), this.locale)));
        this.writeWithBuffer(BEG_OL);
        this.writeWithBuffer(this.formatNewLine());
    }

    @Override
    public void endMetadata(NaryMetadata metadata, int depth) {
        this.writeWithBuffer(this.formatCurrentIndent());
        this.writeWithBuffer(END_OL);
        this.writeWithBuffer(this.formatNewLine());
        this.writeWithBuffer(this.formatCurrentIndent());
        this.writeWithBuffer(END_LI);
        this.writeWithBuffer(this.formatNewLine());
    }

    @Override
    public void visitMetadata(UnaryMetadata metadata, int depth) {
        if (!this.noLiNary) {
            this.writeWithBuffer(BEG_LI);
            this.noLiNary = false;
        }
        this.htmlFormatSpan(CSS_CLASS_UNARY, StringEscapeUtils.escapeHtml4((String)this.bundle.get(metadata.getOperator(), this.locale)));
        this.writeWithBuffer(END_LI);
        this.writeWithBuffer(BEG_UL);
    }

    @Override
    protected void endMetadata(UnaryMetadata metadata, int depth) {
        this.writeWithBuffer(END_UL);
    }

    @Override
    public void startMetadata(ValidationRule metadata, int depth) {
        this.formatDivStart(CSS_CLASS_VALIDATION_RULE);
        this.writeWithBuffer(this.formatNewLine());
        this.writeWithBuffer(this.formatCurrentIndent());
    }

    @Override
    public void visitMetadata(ValidationRule metadata, int depth) {
        this.htmlFormatSpan(CSS_CLASS_VALIDATE, this.bundle.get(DefaultOperator.validate_with_message, this.locale));
        this.writeWithBuffer(" ");
        this.htmlFormatSpan(CSS_CLASS_VALIDATION_MESSAGE, this.formatMessage(metadata));
        this.writeWithBuffer(this.formatNewLine());
    }

    @Override
    public void endMetadata(ValidationRule metadata, int depth) {
        this.writeWithBuffer(this.formatCurrentIndent());
        this.writeWithBuffer(this.formatNewLine());
        this.writeWithBuffer(END_DIV);
        this.writeWithBuffer(this.formatNewLine());
    }

    @Override
    public void visitMetadata(Metadata metadata, int depth) {
        this.writeWithBuffer(metadata.readable());
    }

    protected String formatWhen() {
        return this.bundle.get(DefaultOperator.when, this.locale);
    }

    protected String formatMessage(ValidationRule metadata) {
        return MessageFormat.format("\"{0}\"", metadata.getMessage() == null ? this.bundle.get(DefaultOperator.empty, this.locale) : metadata.getMessage());
    }

    protected void formatLeafOperator(Element e) {
        this.htmlFormatSpan("dsl-token-operator", this.bundle.get((Operator)e.getReadable(), this.locale));
    }

    protected void formatTemporalUnit(Element e) {
        this.htmlFormatSpan("dsl-token-operator", this.bundle.get(e.getReadable().readable(), this.locale));
    }

    protected void formatLeafField(Element e) {
        this.htmlFormatSpan("dsl-token-field", e.getReadable().readable());
    }

    protected void formatParenthesis(Element e) {
        this.htmlFormatSpan("dsl-token-parenthesis", e.getReadable().readable());
    }

    protected void formatLeafValue(Element e) {
        if (e.getType() == ElementType.STRING_VALUE) {
            this.htmlFormatSpan("dsl-token-value", "'" + this.bundle.get(e.getReadable().readable(), this.locale) + "'");
        } else {
            this.htmlFormatSpan("dsl-token-value", this.bundle.get(e.getReadable().readable(), this.locale));
        }
    }

    protected void formatLeafUnknown(Element e) {
        this.htmlFormatSpan("dsl-token-unknown", this.bundle.get(e.getReadable().readable(), this.locale));
    }

    protected void htmlFormatSpan(String cssClass, String content) {
        this.writeWithBuffer("<span class=\"" + cssClass + "\">" + content + "</span> ");
    }

    private void formatDivStart(String cssClass) {
        this.writeWithBuffer("<div class=\"" + cssClass + "\">");
    }

    protected void writeWithBuffer(String s) {
        this.lastLines[0] = this.lastLines[1];
        this.lastLines[1] = this.lastLines[2];
        this.lastLines[2] = s;
        try {
            this.ops.write(s.getBytes("UTF-8"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

