/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.lang.StepWhen;
import io.doov.core.dsl.lang.ValidationRule;
import io.doov.core.dsl.meta.BinaryMetadata;
import io.doov.core.dsl.meta.Element;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.NaryMetadata;
import io.doov.core.dsl.meta.UnaryMetadata;
import io.doov.core.dsl.meta.ast.AbstractAstVisitor;

public class AstFullVisitor
extends AbstractAstVisitor {
    private static final int INDENT_SIZE = 4;
    private final StringBuilder sb;

    public AstFullVisitor(StringBuilder sb) {
        this.sb = sb;
    }

    @Override
    public void visitMetadata(Metadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("visit Metadata ").append(metadata);
        this.sb.append("\n");
    }

    @Override
    public void visitMetadata(LeafMetadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("visit FieldMetadata ").append(metadata).append(" = ");
        metadata.stream().map(Element::getReadable).forEach(this.sb::append);
        this.sb.append("\n");
    }

    @Override
    public void visitMetadata(UnaryMetadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("visit UnaryMetadata ").append(metadata).append(" = ").append(metadata.getOperator());
        this.sb.append("\n");
    }

    @Override
    public void startMetadata(BinaryMetadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("start BinaryMetadata ").append(metadata).append(" = ").append("---");
        this.sb.append("\n");
    }

    @Override
    public void visitMetadata(BinaryMetadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("visit BinaryMetadata ").append(metadata).append(" = ").append(metadata.getOperator());
        this.sb.append("\n");
    }

    @Override
    public void endMetadata(BinaryMetadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("end BinaryMetadata ").append(metadata).append(" = ").append("---");
        this.sb.append("\n");
    }

    @Override
    public void startMetadata(NaryMetadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("start NaryMetadata ").append(metadata).append(" = ").append(metadata.getOperator());
        this.sb.append("\n");
    }

    @Override
    public void visitMetadata(NaryMetadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("visit NaryMetadata ").append(metadata).append(" = ").append("---");
        this.sb.append("\n");
    }

    @Override
    public void endMetadata(NaryMetadata metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("end NaryMetadata ").append(metadata).append(" = ").append("---");
        this.sb.append("\n");
    }

    @Override
    public void startMetadata(ValidationRule metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("start ValidationRule ").append(metadata).append(" = ").append("rule");
        this.sb.append("\n");
    }

    @Override
    public void visitMetadata(ValidationRule metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("visit ValidationRule ").append(metadata).append(" = ").append("validate with message");
        this.sb.append("\n");
    }

    @Override
    public void endMetadata(ValidationRule metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("end ValidationRule ").append(metadata).append(" = ").append(metadata.getMessage());
        this.sb.append("\n");
    }

    @Override
    public void startMetadata(StepWhen metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("start StepWhen ").append(metadata).append(" = ").append("when");
        this.sb.append("\n");
    }

    @Override
    public void visitMetadata(StepWhen metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("visit StepWhen ").append(metadata).append(" = ").append("---");
        this.sb.append("\n");
    }

    @Override
    public void endMetadata(StepWhen metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("end StepWhen ").append(metadata).append(" = ").append("---");
        this.sb.append("\n");
    }

    @Override
    public void visitMetadata(StepCondition metadata, int depth) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("visit StepCondition ").append(metadata).append(" = ").append("---");
        this.sb.append("\n");
    }

    @Override
    protected int getIndentSize() {
        return 4;
    }
}

