/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.lang.StepWhen;
import io.doov.core.dsl.lang.ValidationRule;
import io.doov.core.dsl.meta.BinaryMetadata;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.MetadataVisitor;
import io.doov.core.dsl.meta.NaryMetadata;
import io.doov.core.dsl.meta.UnaryMetadata;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public abstract class AbstractAstVisitor
implements MetadataVisitor {
    private final Deque<MetadataType> stack = new ArrayDeque<MetadataType>();

    @Override
    public final void visit(Metadata metadata, int depth) {
        this.visitMetadata(metadata, depth);
    }

    protected void visitMetadata(Metadata metadata, int depth) {
    }

    @Override
    public final void start(LeafMetadata metadata, int depth) {
        this.startMetadata(metadata, depth);
    }

    protected void startMetadata(LeafMetadata metadata, int depth) {
    }

    @Override
    public final void visit(LeafMetadata metadata, int depth) {
        this.visitMetadata(metadata, depth);
    }

    protected void visitMetadata(LeafMetadata metadata, int depth) {
    }

    @Override
    public final void end(LeafMetadata metadata, int depth) {
        this.endMetadata(metadata, depth);
    }

    protected void endMetadata(LeafMetadata metadata, int depth) {
    }

    @Override
    public final void visit(UnaryMetadata metadata, int depth) {
        this.visitMetadata(metadata, depth);
    }

    protected void visitMetadata(UnaryMetadata metadata, int depth) {
    }

    @Override
    public final void end(UnaryMetadata metadata, int depth) {
        this.endMetadata(metadata, depth);
    }

    protected void endMetadata(UnaryMetadata metadata, int depth) {
    }

    @Override
    public final void start(BinaryMetadata metadata, int depth) {
        this.startMetadata(metadata, depth);
        this.stack.push(MetadataType.BINARY_PREDICATE);
    }

    protected void startMetadata(BinaryMetadata metadata, int depth) {
    }

    @Override
    public final void visit(BinaryMetadata metadata, int depth) {
        this.visitMetadata(metadata, depth);
    }

    protected void visitMetadata(BinaryMetadata metadata, int depth) {
    }

    @Override
    public final void end(BinaryMetadata metadata, int depth) {
        this.stack.pop();
        this.endMetadata(metadata, depth);
    }

    protected void endMetadata(BinaryMetadata metadata, int depth) {
    }

    @Override
    public final void start(NaryMetadata metadata, int depth) {
        this.startMetadata(metadata, depth);
        this.stack.push(MetadataType.NARY_PREDICATE);
    }

    protected void startMetadata(NaryMetadata metadata, int depth) {
    }

    @Override
    public final void visit(NaryMetadata metadata, int depth) {
        this.visitMetadata(metadata, depth);
    }

    protected void visitMetadata(NaryMetadata metadata, int depth) {
    }

    @Override
    public final void end(NaryMetadata metadata, int depth) {
        this.stack.pop();
        this.endMetadata(metadata, depth);
    }

    protected void endMetadata(NaryMetadata metadata, int depth) {
    }

    @Override
    public final void start(ValidationRule metadata, int depth) {
        this.startMetadata(metadata, depth);
        this.stack.push(MetadataType.RULE);
    }

    protected void startMetadata(ValidationRule metadata, int depth) {
    }

    @Override
    public final void visit(ValidationRule metadata, int depth) {
        this.visitMetadata(metadata, depth);
    }

    protected void visitMetadata(ValidationRule metadata, int depth) {
    }

    @Override
    public final void end(ValidationRule metadata, int depth) {
        this.stack.pop();
        this.endMetadata(metadata, depth);
    }

    protected void endMetadata(ValidationRule metadata, int depth) {
    }

    @Override
    public final void start(StepWhen metadata, int depth) {
        this.startMetadata(metadata, depth);
        this.stack.push(MetadataType.WHEN);
    }

    protected void startMetadata(StepWhen metadata, int depth) {
    }

    @Override
    public final void visit(StepWhen metadata, int depth) {
        this.visitMetadata(metadata, depth);
    }

    protected void visitMetadata(StepWhen metadata, int depth) {
    }

    @Override
    public final void end(StepWhen metadata, int depth) {
        this.stack.pop();
        this.endMetadata(metadata, depth);
    }

    protected void endMetadata(StepWhen metadata, int depth) {
    }

    @Override
    public final void visit(StepCondition metadata, int depth) {
        this.visitMetadata(metadata, depth);
    }

    protected void visitMetadata(StepCondition metadata, int depth) {
    }

    protected int getIndentSize() {
        return 0;
    }

    protected int getCurrentIndentSize() {
        return this.stack.size() * this.getIndentSize();
    }

    protected String formatCurrentIndent() {
        return IntStream.range(0, this.getCurrentIndentSize()).mapToObj(i -> " ").collect(Collectors.joining(""));
    }

    protected String formatNewLine() {
        return "\n";
    }

    protected final MetadataType stackPeek() {
        return this.stack.peek();
    }

    protected final Stream<MetadataType> stackSteam() {
        return this.stack.stream();
    }
}

