/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.meta.BinaryMetadata;
import io.doov.core.dsl.meta.ComposeOperator;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.Element;
import io.doov.core.dsl.meta.ElementType;
import io.doov.core.dsl.meta.EmptyMetadata;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.MetadataVisitor;
import io.doov.core.dsl.meta.Operator;
import io.doov.core.dsl.meta.PredicateMetadata;
import io.doov.core.dsl.meta.ast.AstVisitorUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;

public class NaryMetadata
extends PredicateMetadata {
    private final Operator operator;
    private final List<Metadata> values;

    private NaryMetadata(Operator operator, List<Metadata> values) {
        this.operator = operator;
        this.values = values;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public static NaryMetadata matchAnyMetadata(List<Metadata> values) {
        return new NaryMetadata(DefaultOperator.match_any, values);
    }

    public static NaryMetadata matchAllMetadata(List<Metadata> values) {
        return new NaryMetadata(DefaultOperator.match_all, values);
    }

    public static NaryMetadata matchNoneMetadata(List<Metadata> values) {
        return new NaryMetadata(DefaultOperator.match_none, values);
    }

    public static NaryMetadata countMetadata(List<Metadata> values) {
        return new NaryMetadata(DefaultOperator.count, values);
    }

    public static NaryMetadata sumMetadata(List<Metadata> values) {
        return new NaryMetadata(DefaultOperator.sum, values);
    }

    public static NaryMetadata minMetadata(List<Metadata> values) {
        return new NaryMetadata(DefaultOperator.min, values);
    }

    @Override
    public String readable() {
        return AstVisitorUtils.astToString(this, Locale.getDefault());
    }

    @Override
    public void accept(MetadataVisitor visitor, int depth) {
        visitor.start(this, depth);
        this.values.stream().filter(Objects::nonNull).filter(md -> MetadataType.EMPTY != md.type()).forEach(v -> {
            v.accept(visitor, depth + 1);
            visitor.visit(this, depth);
        });
        visitor.end(this, depth);
    }

    @Override
    public PredicateMetadata merge(LeafMetadata other) {
        List elts = other.stream().collect(Collectors.toList());
        if (elts.size() == 2 && ((Element)elts.get(0)).getType() == ElementType.OPERATOR) {
            return new BinaryMetadata(this, (Operator)((Element)elts.get(0)).getReadable(), new LeafMetadata(MetadataType.LEAF_PREDICATE).valueReadable(((Element)elts.get(1)).getReadable()));
        }
        return new NaryMetadata(new ComposeOperator(this.operator, other), this.values);
    }

    @Override
    public List<Element> flatten() {
        ArrayList<Element> flatten = new ArrayList<Element>();
        flatten.add(new Element(this.operator, ElementType.OPERATOR));
        flatten.addAll(this.values.stream().map(Metadata::flatten).flatMap(Collection::stream).collect(Collectors.toList()));
        return flatten;
    }

    @Override
    public List<Metadata> children() {
        return Collections.unmodifiableList(this.values);
    }

    @Override
    public MetadataType type() {
        return MetadataType.NARY_PREDICATE;
    }

    @Override
    public Metadata message(Context context) {
        if (this.operator == DefaultOperator.match_all && context.isEvalFalse(this)) {
            return new EmptyMetadata();
        }
        if (this.operator == DefaultOperator.match_any) {
            List<Metadata> childMsgs = this.values.stream().filter(md -> context.isEvalTrue((Metadata)md)).map(md -> md.message(context)).filter(Objects::nonNull).filter(md -> MetadataType.EMPTY != md.type()).collect(Collectors.toList());
            if (childMsgs.size() == 1) {
                return (Metadata)childMsgs.get(0);
            }
            return new NaryMetadata(this.operator, childMsgs);
        }
        if (this.operator == DefaultOperator.sum) {
            return new NaryMetadata(DefaultOperator.sum, this.values.stream().filter(md -> {
                if (md.type() != MetadataType.FIELD_PREDICATE) {
                    return true;
                }
                List<Element> elements = md.flatten();
                if (elements.size() < 1) {
                    return true;
                }
                if (elements.get(0).getType() != ElementType.FIELD) {
                    return true;
                }
                Object value = context.getEvalValue(((DslField)elements.get(0).getReadable()).id());
                if (value == null) {
                    return false;
                }
                if (!Number.class.isAssignableFrom(value.getClass())) {
                    return true;
                }
                return ((Number)value).intValue() != 0;
            }).map(md -> md.message(context)).filter(Objects::nonNull).filter(md -> MetadataType.EMPTY != md.type()).collect(Collectors.toList()));
        }
        if (this.operator == DefaultOperator.count) {
            List<Metadata> childMsgs = this.values.stream().filter(md -> context.isEvalTrue((Metadata)md)).map(md -> md.message(context)).filter(Objects::nonNull).filter(md -> MetadataType.EMPTY != md.type()).collect(Collectors.toList());
            if (childMsgs.size() == 1) {
                return childMsgs.get(0);
            }
            return NaryMetadata.rewriteCount(childMsgs);
        }
        return new NaryMetadata(this.operator, this.values.stream().map(md -> md.message(context)).filter(Objects::nonNull).filter(md -> MetadataType.EMPTY != md.type()).collect(Collectors.toList()));
    }

    private static BinaryMetadata rewriteCount(List<Metadata> childMsgs) {
        if (childMsgs.size() == 2) {
            return new BinaryMetadata(childMsgs.get(0), DefaultOperator.and, childMsgs.get(1));
        }
        return new BinaryMetadata(childMsgs.get(0), DefaultOperator.and, NaryMetadata.rewriteCount(childMsgs.subList(1, childMsgs.size())));
    }
}

