/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.impl.DefaultCondition;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.Readable;
import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.Element;
import io.doov.core.dsl.meta.ElementType;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.MetadataVisitor;
import io.doov.core.dsl.meta.Operator;
import io.doov.core.dsl.meta.PredicateMetadata;
import io.doov.core.dsl.meta.ast.AstVisitorUtils;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LeafMetadata
extends PredicateMetadata {
    private static final Collector<CharSequence, ?, String> COLLECTOR_LIST = Collectors.joining(", ", " : ", "");
    private final Deque<Element> elements;
    private final MetadataType type;

    public LeafMetadata(MetadataType type) {
        this.elements = new ArrayDeque<Element>();
        this.type = type;
    }

    private LeafMetadata(Deque<Element> elements, MetadataType type) {
        this.elements = elements;
        this.type = type;
    }

    public Stream<Element> stream() {
        return this.elements.stream();
    }

    @Override
    public PredicateMetadata merge(LeafMetadata other) {
        LeafMetadata.removeDuplicate(this.elements, other.elements);
        ArrayDeque<Element> merge = new ArrayDeque<Element>(this.elements);
        merge.addAll(other.elements);
        return new LeafMetadata(merge, LeafMetadata.mergeType(this.type, other.type));
    }

    @Override
    public List<Element> flatten() {
        return this.elements.stream().collect(Collectors.toList());
    }

    private static MetadataType mergeType(MetadataType current, MetadataType merged) {
        if (current == MetadataType.FIELD_PREDICATE && merged == MetadataType.FIELD_PREDICATE_MATCH_ANY) {
            return MetadataType.FIELD_PREDICATE_MATCH_ANY;
        }
        return current;
    }

    private static void removeDuplicate(Deque<Element> current, Deque<Element> merged) {
        if (current.isEmpty() || merged.isEmpty()) {
            return;
        }
        for (Element element : current) {
            if (merged.isEmpty()) break;
            if (merged.peek().getType() != element.getType() || !merged.peek().getReadable().readable().equals(element.getReadable().readable())) continue;
            merged.pop();
        }
    }

    @Override
    public String readable() {
        return AstVisitorUtils.astToString(this, Locale.getDefault());
    }

    @Override
    public void accept(MetadataVisitor visitor, int depth) {
        visitor.start(this, depth);
        visitor.visit(this, depth);
        visitor.end(this, depth);
    }

    @Override
    public List<Metadata> children() {
        return Collections.emptyList();
    }

    @Override
    public MetadataType type() {
        return this.type;
    }

    @Override
    public Metadata message(Context context) {
        if (this.type == MetadataType.FIELD_PREDICATE_MATCH_ANY) {
            DslField field = (DslField)this.elements.getFirst().getReadable();
            return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.equals).valueObject(context.getEvalValue(field.id()));
        }
        return this;
    }

    private LeafMetadata add(Element element) {
        if (element != null) {
            this.elements.add(element);
        }
        return this;
    }

    public LeafMetadata field(DslField readable) {
        return this.add(readable == null ? null : new Element(readable, ElementType.FIELD));
    }

    public LeafMetadata operator(Operator op) {
        return this.add(op == null ? null : new Element(op, ElementType.OPERATOR));
    }

    public LeafMetadata valueObject(Object readable) {
        if (readable == null) {
            return null;
        }
        if (readable instanceof String) {
            return this.add(new Element(() -> (String)readable, ElementType.STRING_VALUE));
        }
        return this.add(new Element(() -> String.valueOf(readable), ElementType.VALUE));
    }

    public LeafMetadata valueString(String readable) {
        return this.add(readable == null ? null : new Element(() -> readable, ElementType.STRING_VALUE));
    }

    public LeafMetadata temporalUnit(Object unit) {
        return this.add(unit == null ? null : new Element(() -> unit.toString().toLowerCase(), ElementType.TEMPORAL_UNIT));
    }

    public LeafMetadata valueCondition(DefaultCondition<?> condition) {
        ((LeafMetadata)condition.getMetadata()).stream().forEach(e -> this.add((Element)e));
        return this;
    }

    public LeafMetadata valueReadable(Readable readable) {
        return this.add(readable == null ? null : new Element(readable, ElementType.VALUE));
    }

    public LeafMetadata valueTemporalAdjuster(Readable adjuster) {
        return this.add(((LeafMetadata)adjuster).elements.getFirst());
    }

    public LeafMetadata valueSupplier(Supplier<?> readable) {
        return this.add(readable == null ? null : new Element(() -> String.valueOf(readable.get()), ElementType.VALUE));
    }

    public LeafMetadata valueUnknown(String readable) {
        return this.add(readable == null ? null : new Element(() -> "-function- " + readable, ElementType.UNKNOWN));
    }

    public LeafMetadata valueListReadable(Collection<? extends Readable> readables) {
        return this.add(readables == null || readables.isEmpty() ? null : new Element(() -> LeafMetadata.formatListReadable(readables), ElementType.VALUE));
    }

    public LeafMetadata valueListObject(Collection<?> readables) {
        return this.add(readables == null || readables.isEmpty() ? null : new Element(() -> LeafMetadata.formatListObject(readables), ElementType.VALUE));
    }

    public static LeafMetadata fieldMetadata(DslField field) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field);
    }

    public static LeafMetadata unknownMetadata(String value) {
        return new LeafMetadata(MetadataType.LEAF_PREDICATE).valueUnknown(value);
    }

    public static LeafMetadata trueMetadata() {
        return new LeafMetadata(MetadataType.LEAF_PREDICATE).operator(DefaultOperator.always_true);
    }

    public static LeafMetadata falseMetadata() {
        return new LeafMetadata(MetadataType.LEAF_PREDICATE).operator(DefaultOperator.always_false);
    }

    public static LeafMetadata minMetadata(Collection<? extends Readable> values) {
        return new LeafMetadata(MetadataType.LEAF_PREDICATE).operator(DefaultOperator.min).valueListReadable(values);
    }

    public static LeafMetadata sumMetadata(Collection<? extends Readable> values) {
        return new LeafMetadata(MetadataType.LEAF_PREDICATE).operator(DefaultOperator.sum).valueListReadable(values);
    }

    public static LeafMetadata timesMetadata(DslField field, int multiplier) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.times).valueObject(multiplier);
    }

    public static LeafMetadata whenMetadata(DslField field, StepCondition condition) {
        LeafMetadata exp = new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.when);
        exp.elements.add(Element.leftParenthesis());
        exp.elements.addAll(condition.getMetadata().flatten());
        exp.elements.add(Element.rightParenthesis());
        return exp;
    }

    public static LeafMetadata equalsMetadata(DslField field, Object value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.equals).valueObject(value);
    }

    public static LeafMetadata equalsMetadata(DslField field, Readable value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.equals).valueReadable(value);
    }

    public static LeafMetadata equalsMetadata(DslField field, DefaultCondition<?> condition) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.equals).valueCondition(condition);
    }

    public static LeafMetadata notEqualsMetadata(DslField field, Object value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.not_equals).valueObject(value);
    }

    public static LeafMetadata notEqualsMetadata(DslField field, Readable value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.not_equals).valueReadable(value);
    }

    public static LeafMetadata nullMetadata(DslField field) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.is_null);
    }

    public static LeafMetadata notNullMetadata(DslField field) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.is_not_null);
    }

    public static LeafMetadata matchAnyMetadata(DslField field) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE_MATCH_ANY).field(field).operator(DefaultOperator.match_any).valueUnknown("-function-");
    }

    public static LeafMetadata matchAnyMetadata(DslField field, Collection<?> values) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE_MATCH_ANY).field(field).operator(DefaultOperator.match_any).valueListObject(values);
    }

    public static LeafMetadata matchAllMetadata(DslField field) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.match_all).valueUnknown("-function-");
    }

    public static LeafMetadata matchAllMetadata(DslField field, Collection<?> values) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.match_all).valueListObject(values);
    }

    public static LeafMetadata matchNoneMetadata(DslField field) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.match_none).valueUnknown("-function-");
    }

    public static LeafMetadata matchNoneMetadata(DslField field, Collection<?> values) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.match_none).valueListObject(values);
    }

    public static LeafMetadata mapToIntMetadata(DslField field) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.as_a_number).valueUnknown("");
    }

    public static LeafMetadata withMetadata(DslField field, Readable adjuster) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.with).valueTemporalAdjuster(adjuster);
    }

    public static LeafMetadata minusMetadata(DslField field, int value, Object unit) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.minus).valueObject(value).temporalUnit(unit);
    }

    public static LeafMetadata minusMetadata(DslField field1, DslField field2, Object unit) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field1).operator(DefaultOperator.minus).field(field2).temporalUnit(unit);
    }

    public static LeafMetadata plusMetadata(DslField field, int value, Object unit) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.plus).valueObject(value).temporalUnit(unit);
    }

    public static LeafMetadata plusMetadata(DslField field1, DslField field2, Object unit) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field1).operator(DefaultOperator.plus).field(field2).temporalUnit(unit);
    }

    public static LeafMetadata afterValueMetadata(DefaultCondition<?> condition, Object value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).valueCondition(condition).operator(DefaultOperator.after).valueObject(value);
    }

    public static LeafMetadata afterTemporalFieldMetadata(DefaultCondition<?> condition, DslField field) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).valueCondition(condition).operator(DefaultOperator.after).field(field);
    }

    public static LeafMetadata afterTemporalConditionMetadata(DefaultCondition<?> c1, DefaultCondition<?> c2) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).valueCondition(c1).operator(DefaultOperator.after).valueCondition(c2);
    }

    public static LeafMetadata afterSupplierMetadata(DefaultCondition<?> condition, Supplier<?> value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).valueCondition(condition).operator(DefaultOperator.after).valueSupplier(value);
    }

    public static LeafMetadata afterOrEqualsValueMetadata(DefaultCondition<?> condition, Object value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).valueCondition(condition).operator(DefaultOperator.after_or_equals).valueObject(value);
    }

    public static LeafMetadata afterOrEqualsSupplierMetadata(DefaultCondition<?> condition, Supplier<?> value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).valueCondition(condition).operator(DefaultOperator.after_or_equals).valueSupplier(value);
    }

    public static LeafMetadata afterOrEqualsTemporalConditionMetadata(DefaultCondition<?> c1, DefaultCondition<?> c2) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).valueCondition(c1).operator(DefaultOperator.after_or_equals).valueCondition(c2);
    }

    public static LeafMetadata beforeValueMetadata(DefaultCondition<?> condition, Object value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).valueCondition(condition).operator(DefaultOperator.before).valueObject(value);
    }

    public static LeafMetadata beforeTemporalFieldMetadata(DefaultCondition<?> condition, DslField field) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).valueCondition(condition).operator(DefaultOperator.before).field(field);
    }

    public static LeafMetadata beforeTemporalConditionMetadata(DefaultCondition<?> c1, DefaultCondition<?> c2) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).valueCondition(c1).operator(DefaultOperator.before).valueCondition(c2);
    }

    public static LeafMetadata beforeSupplierMetadata(DefaultCondition<?> condition, Supplier<?> value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).valueCondition(condition).operator(DefaultOperator.before).valueSupplier(value);
    }

    public static LeafMetadata beforeOrEqualsValueMetadata(DefaultCondition<?> condition, Object value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).valueCondition(condition).operator(DefaultOperator.before_or_equals).valueObject(value);
    }

    public static LeafMetadata beforeOrEqualsSupplierMetadata(DefaultCondition<?> condition, Supplier<?> value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).valueCondition(condition).operator(DefaultOperator.before_or_equals).valueSupplier(value);
    }

    public static LeafMetadata beforeOrEqualsTemporalConditionMetadata(DefaultCondition<?> c1, DefaultCondition<?> c2) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).valueCondition(c1).operator(DefaultOperator.before_or_equals).valueCondition(c2);
    }

    public static LeafMetadata ageAtValueMetadata(DefaultCondition<?> condition, Object value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).valueCondition(condition).operator(DefaultOperator.age_at).valueObject(value);
    }

    public static LeafMetadata ageAtTemporalFieldMetadata(DefaultCondition<?> condition, DslField field) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).valueCondition(condition).operator(DefaultOperator.age_at).field(field);
    }

    public static LeafMetadata ageAtTemporalConditionMetadata(DefaultCondition<?> c1, DefaultCondition<?> c2) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).valueCondition(c1).operator(DefaultOperator.age_at).valueCondition(c2);
    }

    public static LeafMetadata ageAtSupplierMetadata(DefaultCondition<?> condition, Supplier<?> supplier) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).valueCondition(condition).operator(DefaultOperator.age_at).valueSupplier(supplier);
    }

    public static LeafMetadata matchesMetadata(DslField field, String value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.matches).valueString(value);
    }

    public static LeafMetadata containsMetadata(DslField field, String value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.contains).valueString(value);
    }

    public static LeafMetadata startsWithMetadata(DslField field, String value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.starts_with).valueString(value);
    }

    public static LeafMetadata endsWithMetadata(DslField field, String value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.ends_with).valueString(value);
    }

    public static LeafMetadata notMetadata(DslField field) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.not);
    }

    public static LeafMetadata andMetadata(DslField field, boolean value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.and).valueObject(value);
    }

    public static LeafMetadata andMetadata(DslField field, Readable value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.and).valueReadable(value);
    }

    public static LeafMetadata orMetadata(DslField field, boolean value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.or).valueObject(value);
    }

    public static LeafMetadata orMetadata(DslField field, Readable value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.or).valueReadable(value);
    }

    public static LeafMetadata xorMetadata(DslField field, boolean value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.xor).valueObject(value);
    }

    public static LeafMetadata xorMetadata(DslField field, Readable value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.xor).valueReadable(value);
    }

    public static LeafMetadata isMetadata(DslField field, boolean value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.is).valueObject(value);
    }

    public static LeafMetadata lesserThanMetadata(DslField field, Object value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.lesser_than).valueObject(value);
    }

    public static LeafMetadata lesserThanMetadata(DslField field1, Readable field2) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field1).operator(DefaultOperator.lesser_than).valueReadable(field2);
    }

    public static LeafMetadata lesserThanMetadata(DslField field1, DslField field2) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field1).operator(DefaultOperator.lesser_than).field(field2);
    }

    public static LeafMetadata lesserOrEqualsMetadata(DslField field, Object value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.lesser_or_equals).valueObject(value);
    }

    public static LeafMetadata lesserOrEqualsMetadata(DslField field1, Readable field2) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field1).operator(DefaultOperator.lesser_or_equals).valueReadable(field2);
    }

    public static LeafMetadata lesserOrEqualsMetadata(DslField field1, DslField field2) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field1).operator(DefaultOperator.lesser_or_equals).field(field2);
    }

    public static LeafMetadata greaterThanMetadata(DslField field, Object value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.greater_than).valueObject(value);
    }

    public static LeafMetadata greaterThanMetadata(DslField field1, Readable field2) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field1).operator(DefaultOperator.greater_than).valueReadable(field2);
    }

    public static LeafMetadata greaterThanMetadata(DslField field1, DslField field2) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field1).operator(DefaultOperator.greater_than).field(field2);
    }

    public static LeafMetadata greaterOrEqualsMetadata(DslField field, Object value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.greater_or_equals).valueObject(value);
    }

    public static LeafMetadata greaterOrEqualsMetadata(DslField field1, Readable field2) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field1).operator(DefaultOperator.greater_or_equals).valueReadable(field2);
    }

    public static LeafMetadata greaterOrEqualsMetadata(DslField field1, DslField field2) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field1).operator(DefaultOperator.greater_or_equals).field(field2);
    }

    public static LeafMetadata lengthIsMetadata(DslField field) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.length_is);
    }

    public static LeafMetadata containsMetadata(DslField field, Object value) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.contains).valueObject(value);
    }

    public static LeafMetadata containsMetadata(DslField field, Collection<Object> values) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.contains).valueListObject(values);
    }

    public static LeafMetadata isEmptyMetadata(DslField field) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.is_empty);
    }

    public static LeafMetadata isNotEmptyMetadata(DslField field) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.is_not_empty);
    }

    public static LeafMetadata hasSizeMetadata(DslField field, int size) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.has_size).valueObject(size);
    }

    public static LeafMetadata hasNotSizeMetadata(DslField field, int size) {
        return new LeafMetadata(MetadataType.FIELD_PREDICATE).field(field).operator(DefaultOperator.has_not_size).valueObject(size);
    }

    public static LeafMetadata todayMetadata() {
        return new LeafMetadata(MetadataType.LEAF_PREDICATE).operator(DefaultOperator.today);
    }

    public static LeafMetadata todayPlusMetadata(int value, Object unit) {
        return new LeafMetadata(MetadataType.LEAF_PREDICATE).operator(DefaultOperator.today_plus).valueObject(value).temporalUnit(unit);
    }

    public static LeafMetadata todayMinusMetadata(int value, Object unit) {
        return new LeafMetadata(MetadataType.LEAF_PREDICATE).operator(DefaultOperator.today_minus).valueObject(value).temporalUnit(unit);
    }

    public static LeafMetadata firstDayOfThisMonthMetadata() {
        return new LeafMetadata(MetadataType.LEAF_PREDICATE).operator(DefaultOperator.first_day_of_this_month);
    }

    public static LeafMetadata firstDayOfThisYearMetadata() {
        return new LeafMetadata(MetadataType.LEAF_PREDICATE).operator(DefaultOperator.first_day_of_this_year);
    }

    public static LeafMetadata lastDayOfThisMonthMetadata() {
        return new LeafMetadata(MetadataType.LEAF_PREDICATE).operator(DefaultOperator.last_day_of_this_month);
    }

    public static LeafMetadata lastDayOfThisYearMetadata() {
        return new LeafMetadata(MetadataType.LEAF_PREDICATE).operator(DefaultOperator.last_day_of_this_year);
    }

    public static LeafMetadata dateMetadata(Object date) {
        return new LeafMetadata(MetadataType.LEAF_PREDICATE).valueString(date.toString());
    }

    public static LeafMetadata firstDayOfMonthMetadata() {
        return new LeafMetadata(MetadataType.LEAF_PREDICATE).operator(DefaultOperator.first_day_of_month);
    }

    public static LeafMetadata firstDayOfNextMonthMetadata() {
        return new LeafMetadata(MetadataType.LEAF_PREDICATE).operator(DefaultOperator.first_day_of_next_month);
    }

    public static LeafMetadata firstDayOfYearMetadata() {
        return new LeafMetadata(MetadataType.LEAF_PREDICATE).operator(DefaultOperator.first_day_of_year);
    }

    public static LeafMetadata firstDayOfNextYearMetadata() {
        return new LeafMetadata(MetadataType.LEAF_PREDICATE).operator(DefaultOperator.first_day_of_next_year);
    }

    public static LeafMetadata lastDayOfMonthMetadata() {
        return new LeafMetadata(MetadataType.LEAF_PREDICATE).operator(DefaultOperator.last_day_of_month);
    }

    public static LeafMetadata lastDayOfYearMetadata() {
        return new LeafMetadata(MetadataType.LEAF_PREDICATE).operator(DefaultOperator.last_day_of_year);
    }

    private static String formatListReadable(Collection<? extends Readable> readables) {
        return readables.stream().map(Readable::readable).collect(COLLECTOR_LIST);
    }

    private static String formatListObject(Collection<?> readables) {
        return readables.stream().map(Object::toString).collect(COLLECTOR_LIST);
    }
}

