/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta;

import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.Element;
import io.doov.core.dsl.meta.ElementType;
import io.doov.core.dsl.meta.EmptyMetadata;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.MetadataVisitor;
import io.doov.core.dsl.meta.NaryMetadata;
import io.doov.core.dsl.meta.Operator;
import io.doov.core.dsl.meta.PredicateMetadata;
import io.doov.core.dsl.meta.ast.AstVisitorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class BinaryMetadata
extends PredicateMetadata {
    private final Metadata left;
    private final Operator operator;
    private final Metadata right;

    BinaryMetadata(Metadata left, Operator operator, Metadata right) {
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Metadata getLeft() {
        return this.left;
    }

    public Metadata getRight() {
        return this.right;
    }

    public static BinaryMetadata andMetadata(Metadata left, Metadata right) {
        return new BinaryMetadata(left, DefaultOperator.and, right);
    }

    public static BinaryMetadata orMetadata(Metadata left, Metadata right) {
        return new BinaryMetadata(left, DefaultOperator.or, right);
    }

    @Override
    public String readable() {
        return AstVisitorUtils.astToString(this, Locale.getDefault());
    }

    @Override
    public void accept(MetadataVisitor visitor, int depth) {
        visitor.start(this, depth);
        this.left.accept(visitor, depth + 1);
        visitor.visit(this, depth);
        this.right.accept(visitor, depth + 1);
        visitor.end(this, depth);
    }

    @Override
    public List<Metadata> children() {
        return Arrays.asList(this.left, this.right);
    }

    @Override
    public MetadataType type() {
        return MetadataType.BINARY_PREDICATE;
    }

    @Override
    public Metadata message(Context context) {
        if (this.operator == DefaultOperator.or && context.isEvalTrue(this.left) && context.isEvalFalse(this.right)) {
            return this.left.message(context);
        }
        if (this.operator == DefaultOperator.or && context.isEvalFalse(this.left) && context.isEvalTrue(this.right)) {
            return this.right.message(context);
        }
        if (this.operator == DefaultOperator.and && context.isEvalFalse(this)) {
            return new EmptyMetadata();
        }
        if (NaryMetadata.class.isAssignableFrom(this.left.getClass()) && ((NaryMetadata)this.left).getOperator() == DefaultOperator.count) {
            return this.left.message(context);
        }
        return new BinaryMetadata(this.left.message(context), this.operator, this.right.message(context));
    }

    @Override
    public List<Element> flatten() {
        ArrayList<Element> flatten = new ArrayList<Element>(this.left.flatten());
        flatten.add(new Element(this.operator, ElementType.OPERATOR));
        flatten.addAll(this.right.flatten());
        return flatten;
    }
}

