/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.DslModel;
import io.doov.core.dsl.impl.NumericCondition;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.meta.PredicateMetadata;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;

public class LongCondition
extends NumericCondition<Long> {
    public LongCondition(DslField field) {
        super(field);
    }

    public LongCondition(DslField field, PredicateMetadata metadata, BiFunction<DslModel, Context, Optional<Long>> value) {
        super(field, metadata, value);
    }

    @Override
    NumericCondition<Long> numericCondition(DslField field, PredicateMetadata metadata, BiFunction<DslModel, Context, Optional<Long>> value) {
        return new LongCondition(field, metadata, value);
    }

    @Override
    public BiFunction<Long, Long, Boolean> lesserThanFunction() {
        return (l, r) -> l < r;
    }

    @Override
    public BiFunction<Long, Long, Boolean> lesserOrEqualsFunction() {
        return (l, r) -> l <= r;
    }

    @Override
    public BiFunction<Long, Long, Boolean> greaterThanFunction() {
        return (l, r) -> l > r;
    }

    @Override
    public BiFunction<Long, Long, Boolean> greaterOrEqualsFunction() {
        return (l, r) -> l >= r;
    }

    @Override
    BinaryOperator<Long> minFunction() {
        return Long::min;
    }

    @Override
    BinaryOperator<Long> sumFunction() {
        return Long::sum;
    }

    @Override
    BiFunction<Long, Integer, Long> timesFunction() {
        return (l, r) -> l * (long)r.intValue();
    }

    @Override
    Long identity() {
        return 0L;
    }
}

